% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mhp.R
\name{print.mhp}
\alias{print.mhp}
\title{Print Method for mhp Objects}
\usage{
\method{print}{mhp}(x, ...)
}
\arguments{
\item{x}{An object of class "mhp" from \code{mhp_filter(as_dt = FALSE)}.}

\item{...}{Additional arguments (ignored).}
}
\value{
Invisibly returns the input object.
}
\description{
Print a summary of Modified HP filter results.
}
\details{
Prints a formatted summary including:
- Number of observations
- Optimal lambda value
- GCV criterion value
- Cycle statistics (mean, SD, AR1)

Suitable for quick inspection of filter results.
}
\examples{
set.seed(42)
y <- cumsum(rnorm(100)) + sin((1:100) * pi / 20)
result <- mhp_filter(y, max_lambda = 10000, as_dt = FALSE)
print(result)

}
