% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decomplot.R
\name{decomplot}
\alias{decomplot}
\title{Decomposition of the MUMARINEX value into its three sub-indices
and representation as boxplots}
\usage{
decomplot(
  x,
  g,
  ref,
  fill = c("lightblue", "#FFFFE0DF", "#90F0909E"),
  border = c("#0080AB", "#C7C700DF", "#0091009E"),
  main = NULL
)
}
\arguments{
\item{x}{A data frame organized with samples in rows and species in columns.}

\item{g}{A vector of length \code{nrow(x)} indicating how the samples should be grouped (e.g., stations, treatments).}

\item{ref}{A logical or numeric vector identifying the reference row positions.}

\item{fill}{Fill color of the boxplots.}

\item{border}{Border color of the boxplots.}

\item{main}{Main title of the plot.}
}
\value{
A boxplot of length \code{g} representing the variations in the different MUMARINEX sub-indices (CSR, CBCD, and CPI).
}
\description{
Generates a graphical representation (boxplot) of MUMARINEX sub-indices to assess which component(s) contribute most strongly to the overall MUMARINEX score.
}
\details{
Decomposition of the MUMARINEX value into its three sub-indices
and representation as boxplots
}
\examples{
data("Simulated_data")
ref_idx<-41:50
stations<-matrix(unlist(strsplit(rownames(Simulated_data),".",fixed=TRUE)),ncol=2,byrow=TRUE)[,1]
decomplot(x=Simulated_data,g=stations,ref=ref_idx,main="Simulated data")
}
\seealso{
\code{\link[=diagnostic_tool]{diagnostic_tool()}}
}
