% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{inputs}
\alias{inputs}
\title{Extract input data from qlm_coded objects}
\usage{
inputs(x)
}
\arguments{
\item{x}{A \code{qlm_coded} object.}
}
\value{
The original input data: a character vector of texts (for text
codebooks) or file paths to images (for image codebooks). If the original
input had names, these are preserved.
}
\description{
Extracts the original input data (texts or image paths) from \code{qlm_coded}
objects. The inputs are the source material that was coded, constituting
a core component of the coded object.
}
\details{
The inputs are a core component of coded objects, representing the source
material that was coded. Like \code{\link[=codebook]{codebook()}}, this is a component extractor
rather than a metadata accessor.

The function name mirrors the \code{inputs} argument in \code{\link[=qlm_code]{qlm_code()}}, providing
a direct conceptual mapping: what is passed in via \verb{inputs =} is retrieved
back via \code{inputs()}.
}
\examples{
# Load example objects
examples <- readRDS(system.file("extdata", "example_objects.rds", package = "quallmer"))
coded <- examples$example_coded_sentiment

# Extract inputs
texts <- inputs(coded)
texts

}
\seealso{
\itemize{
\item \link{accessors} for an overview of the accessor function system
\item \code{\link[=qlm_code]{qlm_code()}} for creating coded objects
\item \code{\link[=codebook]{codebook()}} for extracting the codebook
\item \code{\link[=qlm_meta]{qlm_meta()}} for extracting metadata
}
}
