% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rblimp_source.R
\name{rblimp_source}
\alias{rblimp_source}
\title{Runs an 'imp' file with Blimp}
\usage{
rblimp_source(file, plots = FALSE, output = TRUE, nopowershell = FALSE)
}
\arguments{
\item{file}{a character string to the 'imp' file's location}

\item{plots}{a logical. Setting to \code{TRUE} will generate the data required for plotting by Blimp}

\item{output}{The type of output printed to the console.
\code{'iteration'} or logical \code{TRUE} is only iteration history, \code{'none'} or logical \code{FALSE}
suppresses all output to console, and \code{'all'} prints all output to console.}

\item{nopowershell}{Windows only. Uses cmd.exe with some limited functions (instead of powershell).}
}
\value{
a \code{blimp_out} object
}
\description{
This function runs 'imp' file with Blimp and captures the output only.
}
\details{
Running \code{rblimp_source} will also run a check to see if Blimp is up to date.
If Blimp is not up to date, it will prompt the user if it would like to update or not.
This check will only be performed on the first run in a session and then every ten hours.
This behavior can be disabled by setting the \code{check_blimp_update} option to FALSE using \code{\link{options}}.
This check is not performed if R is not being run with an interactive session. See \code{\link{interactive}} for more information.
}
\examples{
\dontshow{if (has_blimp()) withAutoprint(\{ # examplesIf}
# Run blimp script
\dontrun{output <- rblimp_source("filepath/to/syntax")}
\dontshow{\}) # examplesIf}
}
