% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.initials.logistic.R
\name{get.initials.logistic}
\alias{get.initials.logistic}
\title{Get initial values for spexvb}
\usage{
get.initials.logistic(
  X,
  Y,
  mu_0 = NULL,
  omega_0 = NULL,
  c_pi_0 = NULL,
  d_pi_0 = NULL,
  update_order = NULL,
  seed = 12376
)
}
\arguments{
\item{X}{A design matrix.}

\item{Y}{A response vector.}

\item{mu_0}{Initial mean.}

\item{omega_0}{Initial omega.}

\item{c_pi_0}{Initial c_pi.}

\item{d_pi_0}{Initial d_pi.}

\item{update_order}{Initial update order.}

\item{seed}{Seed for reproducibility.}
}
\value{
A list of initialized parameters.
}
\description{
This function initializes parameters for the spexvb model.
}
\details{
Generate Initial Values for Variational Inference in Sparse Logistic Regression

This helper function estimates initial values for variational parameters such as
regression coefficients (\code{mu}), spike probabilities (\code{omega}), and hyperparameters
like  \code{c_pi}, and \code{d_pi} using LASSO regression.
}
\examples{
\donttest{
n <- 50
p <- 100
X <- matrix(rnorm(n * p), n, p)
# Generate binary response
Y <- rbinom(n, 1, plogis(X[,1]))

initials <- get.initials.logistic(X, Y)

# View the initial mu (posterior means)
head(initials$mu_0)
}
}
