% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spexvb.logistic.R
\name{spexvb.logistic}
\alias{spexvb.logistic}
\title{Parameter Expanded Variational Bayes for Sparse Logistic Regression}
\usage{
spexvb.logistic(
  X,
  Y,
  mu_0 = NULL,
  omega_0 = NULL,
  c_pi_0 = NULL,
  d_pi_0 = NULL,
  update_order = NULL,
  mu_alpha = 1,
  tau_alpha = 10,
  tau_b = 1,
  max_iter = 300,
  tol = 1e-04
)
}
\arguments{
\item{X}{A numeric matrix. The design matrix (n observations × p predictors).}

\item{Y}{A numeric vector. The response vector (0/1).}

\item{mu_0}{Optional numeric vector. Initial variational means.}

\item{omega_0}{Optional numeric vector. Initial spike probabilities.}

\item{c_pi_0}{Optional numeric. Prior Beta(a, b) parameter a.}

\item{d_pi_0}{Optional numeric. Prior Beta(a, b) parameter b.}

\item{update_order}{Optional integer vector. Coordinate update order (0-indexed).}

\item{mu_alpha}{Prior mean for alpha. Default is 1.}

\item{tau_alpha}{Prior precision for alpha. Default is 10.}

\item{tau_b}{Slab prior precision. Default is 1.}

\item{max_iter}{Maximum iterations. Default is 300.}

\item{tol}{Convergence tolerance. Default is 1e-4.}
}
\value{
A list with posterior summaries including estimated coefficients (\code{mu}),
inclusion probabilities (\code{omega}), final expected slab precision (\code{tau_b}),
intercept (if applicable), convergence status, etc.
}
\description{
Fits a sparse logistic regression model using variational inference with an alpha expansion step.
}
\examples{
\donttest{
n <- 50
p <- 100
X <- matrix(rnorm(n * p), n, p)
# Generate binary response
Y <- rbinom(n, 1, plogis(X[,1] * 2))

fit <- spexvb.logistic(X, Y)

# Check convergence
print(fit$converged)
}
}
