% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_ast.R
\name{walk_ast}
\alias{walk_ast}
\title{Static code analysis for \code{tarchetypes}.}
\usage{
walk_ast(expr, walk_call)
}
\arguments{
\item{expr}{A language object or function to scan.}

\item{walk_call}{A function to handle a specific kind of function call
relevant to the code analysis at hand.}
}
\value{
A character vector of data found during static code analysis.
}
\description{
Walk an abstract syntax tree and capture data.
}
\details{
For internal use only. Not a user-side function.
Powers functionality like automatic detection of \code{tar_load()}/\code{tar_read()}
dependencies in \code{\link[=tar_render]{tar_render()}}.
Packages \code{codetools} and \code{CodeDepends} have different (more sophisticated
and elaborate) implementations of the concepts documented at
\url{https://adv-r.hadley.nz/expressions.html#ast-funs}.
}
\examples{
# How tar_render() really works:
expr <- quote({
  if (a > 1) {
    tar_load(target_name)
  }
  process_stuff(target_name)
})
walk_ast(expr, walk_call_knitr)
# Custom code analysis for developers of tarchetypes internals:
walk_custom <- function(expr, counter) {
  # New internals should use targets::tar_deparse_safe(backtick = FALSE).
  name <- deparse(expr[[1]])
  if (identical(name, "detect_this")) {
    counter_set_names(counter, as.character(expr[[2]]))
  }
}
expr <- quote({
  for (i in seq_len(10)) {
    for (j in seq_len(20)) {
      if (i > 1) {
        detect_this("prize")
      } else {
        ignore_this("penalty")
      }
    }
  }
})
walk_ast(expr, walk_custom)
}
\keyword{internal}
