% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_crew.R
\name{tar_crew}
\alias{tar_crew}
\title{Get crew worker info.}
\usage{
tar_crew(store = targets::tar_config_get("store"))
}
\arguments{
\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
A data frame one row per \code{crew} controller
(potentially multiple rows if \code{tar_option_get("controller")}
is a controller group) and the following columns:
\itemize{
\item \code{controller}: name of the \code{crew} controller.
\item \code{targets}: number of times the controller attempted to run a target.
\item \code{seconds}: number of seconds the workers spent running tasks.
}
}
\description{
For the most recent run of the pipeline with \code{\link[=tar_make]{tar_make()}}
where a \code{crew} controller was started, get summary-level information
of the workers.
}
\section{Storage access}{

Several functions like \code{tar_make()}, \code{tar_read()}, \code{tar_load()},
\code{tar_meta()}, and \code{tar_progress()} read or modify
the local data store of the pipeline.
The local data store is in flux while a pipeline is running,
and depending on how distributed computing or cloud computing is set up,
not all targets can even reach it. So please do not call these
functions from inside a target as part of a running
pipeline. The only exception is literate programming
target factories in the \code{tarchetypes} package such as \code{tar_render()}
and \code{tar_quarto()}.
}

\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
if (requireNamespace("crew", quietly = TRUE)) {
tar_script({
  library(targets)
  library(tarchetypes)
  tar_option_set(controller = crew::crew_controller_local())
  list(
    tar_target(x, seq_len(2)),
    tar_target(y, 2 * x, pattern = map(x))
  )
}, ask = FALSE)
tar_make()
tar_process()
tar_process(pid)
}
})
}
}
\seealso{
Other data: 
\code{\link{tar_pid}()},
\code{\link{tar_process}()}
}
\concept{data}
