% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_poor_fastq.R
\name{remove_poor_fastq}
\alias{remove_poor_fastq}
\title{Remove empty FASTQ}
\usage{
remove_poor_fastq(path2fastq, pattern = "fastq.gz", min_reads = 0)
}
\arguments{
\item{path2fastq}{Character. Path to the directory containing FASTQ files.}

\item{pattern}{Character. Pattern used to identify FASTQ files in
\code{path2fastq}.}

\item{min_reads}{Integer. FASTQ files with a number of reads less than or
equal to this threshold are removed.}
}
\value{
No return value. Called for its side effects: FASTA/FASTQ files in
\code{path2fastq} with a number of reads less than or equal to
\code{min_reads} are removed from disk. Invisibly returns \code{NULL}.
}
\description{
Removes FASTA/FASTQ files with a number of reads less than or equal to
\code{min_reads} from a specified directory.
}
\examples{
tmp <- tempdir()
fq <- file.path(tmp, "no_reads.fastq")
file.create(fq)
remove_poor_fastq(tmp, pattern = "fastq", min_reads = 0)
}
