% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ild_lme.R
\name{ild_lme}
\alias{ild_lme}
\title{Fit a linear mixed-effects model to ILD}
\usage{
ild_lme(
  formula,
  data,
  ar1 = FALSE,
  correlation_class = c("auto", "AR1", "CAR1"),
  random = ~1 | .ild_id,
  warn_no_ar1 = TRUE,
  ...
)
}
\arguments{
\item{formula}{Fixed-effects formula. For `ar1 = TRUE`, must be fixed-only
(e.g. `y ~ x`); random structure is set to `~ 1 | .ild_id` internally.
For `ar1 = FALSE`, formula may include random effects (e.g. `y ~ x + (1|id)`).}

\item{data}{An ILD object (see [is_ild()]).}

\item{ar1}{Logical. If `TRUE`, fit with nlme and residual AR1/CAR1
correlation; if `FALSE`, fit with lme4 (no residual correlation).}

\item{correlation_class}{Character. `"auto"` (default) uses [ild_spacing_class()]
to choose CAR1 (irregular-ish) or AR1 (regular-ish). Use `"CAR1"` or
`"AR1"` to override.}

\item{random}{For `ar1 = TRUE`, the random effects formula (default
`~ 1 | .ild_id`). Must use `.ild_id` as grouping for correlation to match.}

\item{warn_no_ar1}{If `TRUE` (default), warn when `ar1 = FALSE` that
temporal autocorrelation is not modeled.}

\item{...}{Passed to [lme4::lmer()] or [nlme::lme()].}
}
\value{
A fitted model object (class `lmerMod` or `lme`) with attribute
  `ild_data` (the ILD data) and `ild_ar1` (logical). When `ar1 = TRUE`,
  the returned object has class `ild_lme` prepended for [ild_diagnostics()]
  and [ild_plot()].
}
\description{
When `ar1 = FALSE`, fits with [lme4::lmer()] (no residual correlation).
When `ar1 = TRUE`, fits with [nlme::lme()] using a residual correlation
structure: CAR1 (continuous-time) by default for irregular spacing,
or AR1 when spacing is regular-ish. Use [ild_spacing_class()] to inform
the choice; override with `correlation_class`.
}
