% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_analysis.R
\name{param_trend}
\alias{param_trend}
\title{Tendencia temporal por parametro (por rio/ponto se existentes)}
\usage{
param_trend(df, parametro, rios = NULL, pontos = NULL, na_rm = TRUE)
}
\arguments{
\item{df}{Data frame com \code{data} e a coluna do \code{parametro}. Idealmente contem
\code{ponto}, e opcionalmente \code{rio}.}

\item{parametro}{Character; nome do parametro.}

\item{rios}{Vetor de nomes de rio a filtrar (opcional; usa coluna \code{rio} se existir).}

\item{pontos}{Vetor de pontos a filtrar (opcional; usa coluna \code{ponto} se existir).}

\item{na_rm}{Remover \code{NA} antes do ajuste? (default \code{TRUE})}
}
\value{
Tibble com colunas de agrupamento (quando existirem) + \code{slope} (por dia),
\code{p_value}, \code{r2}, \code{n}.
}
\description{
Ajusta um modelo \strong{lm(valor ~ tempo)} para \strong{um parametro}, retornando
\code{slope}, \code{p_value}, \code{r2} e \code{n}. Se existirem colunas \code{rio} e/ou \code{ponto},
calcula por grupo; caso contrario, calcula geral.
}
\examples{
\dontrun{
data("wq_demo", package = "tikatuwq")
param_trend(wq_demo, "turbidez", pontos = c("P1","P2"))
}
}
\seealso{
Other parameter-tools: 
\code{\link{param_plot}()},
\code{\link{param_plot_multi}()},
\code{\link{param_summary}()},
\code{\link{param_summary_multi}()},
\code{\link{param_trend_multi}()}
}
\concept{parameter-tools}
