% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tissot.R
\name{tissot_unproject}
\alias{tissot_unproject}
\title{Unproject coordinates to geographic (lon/lat) CRS}
\usage{
tissot_unproject(x, target = "EPSG:4326", ..., source = NULL)
}
\arguments{
\item{x}{input coordinates — any xy-ish object: a two-column matrix,
data.frame, tibble, list with \code{x}/\code{y} or \code{lon}/\code{lat} components,
or a length-2 numeric vector for a single point}

\item{target}{target CRS string (default \code{"EPSG:4326"}). Must be geographic.}

\item{...}{ignored}

\item{source}{source CRS string (required). Must be a projected CRS.}
}
\value{
A two-column matrix of longitude and latitude values.
}
\description{
A convenience wrapper around \code{\link[gdalraster:transform_xy]{gdalraster::transform_xy()}} for converting
projected coordinates to geographic. Useful for generating regular grids
in a projected CRS to feed to \code{\link[=tissot]{tissot()}}, which requires lon/lat input.
}
\examples{
## regular grid in UTM zone 55S, unprojected to lon/lat for tissot()
xy <- expand.grid(x = seq(4e5, 6e5, length.out = 5),
                  y = seq(5200000, 5400000, length.out = 4))
ll <- tissot_unproject(xy, source = "EPSG:32755")
tissot(ll, "+proj=utm +zone=55 +south")
}
\seealso{
\code{\link[=tissot]{tissot()}}, \code{\link[gdalraster:transform_xy]{gdalraster::transform_xy()}}
}
