% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/droptreedata.table.R
\name{droptreedata.table}
\alias{droptreedata.table}
\title{Function dropping taxa from an object of class \code{treedata.table}}
\usage{
droptreedata.table(tdObject, taxa)
}
\arguments{
\item{tdObject}{An object of class \code{treedata.table}}

\item{taxa}{A vector class \code{character} containing all taxa that needs to be
dropped from the original \code{treedata.table} object}
}
\value{
An object of class \code{treedata.table} with matching \verb{$dat} and \verb{$phy}
elements based on whether \code{taxa} were dropped or not.
}
\description{
This function can be used to remove species from an object of class
\code{treedata.table}. The resulting \code{treedata.table} will include fully matching
\verb{$dat} and \verb{$phy} elements. The user should confirm the changes before they
are processed.
}
\examples{
data(anolis)
# With a multiphylo object in the treedata.table object
td <- as.treedata.table(anolis$phy, anolis$dat)
droptreedata.table(
  tdObject = td, taxa =
    c("chamaeleonides", "eugenegrahami")
)

# With a multiphylo object in the treedata.table object
treesFM <- list(anolis$phy, anolis$phy)
class(treesFM) <- "multiPhylo"
td <- as.treedata.table(treesFM, anolis$dat)
droptreedata.table(
  tdObject = td, taxa =
    c("chamaeleonides", "eugenegrahami")
)
}
