% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_rel_risk_transformator.R
\name{create_rel_risk_transformator}
\alias{create_rel_risk_transformator}
\title{Create Relative risk column}
\usage{
create_rel_risk_transformator(dataname, column_name, control_group, label_name)
}
\arguments{
\item{dataname}{(\code{character(1)}) the name of the dataset
which columns will be used for possible transformation.
\code{dataname} should be passed in quotes ex: \code{"ADSL"}.}

\item{column_name}{(\code{character(1)}) field or variable from the dataset.}

\item{control_group}{(\code{character(1)}) one of the existing level from the selected \code{column_name}.}

\item{label_name}{(\code{character(1)}) label for the new field or variable.}
}
\value{
\code{teal::teal_transform_module}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
This transformator allows the user to select a column and control group from the dataset
and create a relative risk column.
}
\examples{

app <- teal::init(
  data = teal.data::teal_data(IRIS = iris, code = "IRIS <- iris"),
  modules = teal::modules(
    teal::example_module(
      transformators = list(create_rel_risk_transformator("IRIS"))
    )
  )
)
if (interactive()) {
  shiny::shinyApp(app$ui, app$server)
}

}
