% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/or_filtering_transformator.R
\name{or_filtering_transformator}
\alias{or_filtering_transformator}
\title{Apply Logical AND/OR filter transformations}
\usage{
or_filtering_transformator(dataname)
}
\arguments{
\item{dataname}{(\code{character(1)}) Name of the dataset to filter. Pass a single dataset name as a string.}
}
\value{
\code{teal::teal_transform_module}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
This transformator provides users with flexible, dynamic filtering capabilities for datasets.

Each instance of the transformator operates on a \strong{single dataset}.
Users can define multiple filter blocks, where:
\itemize{
\item Conditions within each block are combined with \strong{logical AND}.
\item Multiple blocks are combined with \strong{logical OR}.
}

This allows creating complex filter expressions like:

\code{(Condition1 AND Condition2) OR (Condition3 AND Condition4)}

To apply filtering across \strong{multiple datasets}, users can instantiate multiple
instances of this module, each configured for a different dataset.
Each module call is independent and manages filters for its specific dataset.
\itemize{
\item \strong{Supported Data Types & Expressions:}
\itemize{
\item Supports filtering on \code{character}, \code{factor}, and \code{numeric} columns.
\item Conditions can use operators: \code{==}, \code{!=}, \code{<}, \code{>}, \code{<=}, \code{>=}.
\item Conditions are specified as simple expressions, e.g.,
\code{columnA == 'value'}
\code{columnB != 5}
\code{columnC >= 10}
\item Each block's conditions are combined with \strong{AND}.
\item Multiple blocks are combined with \strong{OR}.
}
\item \strong{Features:}
\itemize{
\item \strong{Add Multiple OR Blocks:} Dynamically add new blocks for alternative conditions.
\item \strong{Add Conditions:} Within each block, add multiple conditions, with duplicate prevention.
\item \strong{Preview Filter Expression:} Generate and display the current combined filter expression.
\item \strong{Remove Conditions:} Remove individual conditions within a block.
\item \strong{Expression Generation:} The resulting expression can be directly used
with \code{dplyr::filter()} or similar functions.
}
\item \strong{Usage Pattern:}
\itemize{
\item Call the module multiple times with different dataset names to filter multiple datasets independently.
\item Each call manages its own filter state and expression.
\item Users can build complex filters per dataset and apply or combine them as needed.
}
}
}
\examples{

app <- teal::init(
  data = teal.data::teal_data(IRIS = iris),
  modules = teal::modules(teal::example_module(
    transformators = list(or_filtering_transformator("IRIS"))
  ))
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}
}
