% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pb_plot.R
\name{plot.pb_regression}
\alias{plot.pb_regression}
\alias{autoplot.pb_regression}
\title{Plot method for pb_regression objects}
\usage{
\method{plot}{pb_regression}(
  x,
  type = c("scatter", "residuals", "cusum"),
  show_ci = TRUE,
  show_identity = TRUE,
  residual_type = c("fitted", "rank"),
  point_alpha = 0.6,
  point_size = 2,
  line_colors = NULL,
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  ...
)

\method{autoplot}{pb_regression}(
  object,
  type = c("scatter", "residuals", "cusum"),
  show_ci = TRUE,
  show_identity = TRUE,
  residual_type = c("fitted", "rank"),
  point_alpha = 0.6,
  point_size = 2,
  line_colors = NULL,
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class \code{pb_regression}.}

\item{type}{Character; type of plot to create:
\itemize{
\item \code{"scatter"} (default): Scatter plot with regression line, CI band,
and identity line
\item \code{"residuals"}: Residuals vs. fitted values or rank
\item \code{"cusum"}: CUSUM plot for linearity assessment
}}

\item{show_ci}{Logical; if \code{TRUE} (default), displays confidence band for
the regression line (only for \code{type = "scatter"}).}

\item{show_identity}{Logical; if \code{TRUE} (default), displays the identity
line (y = x) for reference.}

\item{residual_type}{Character; for \code{type = "residuals"}, plot residuals
against \code{"fitted"} (default) or \code{"rank"} (ordered by x).}

\item{point_alpha}{Numeric; transparency of points (0-1, default: 0.6).}

\item{point_size}{Numeric; size of points (default: 2).}

\item{line_colors}{Named character vector with colors for \code{"regression"},
\code{"identity"}, and \code{"ci"}. Defaults to a clean color scheme.}

\item{title}{Character; plot title. If \code{NULL} (default), generates an
automatic title.}

\item{xlab, ylab}{Character; axis labels. If \code{NULL}, auto-generates based
on variable names.}

\item{...}{Additional arguments (currently ignored).}

\item{object}{An object of class \code{pb_regression}.}
}
\value{
A \code{ggplot} object that can be further customized.
}
\description{
Creates publication-ready plots for Passing-Bablok regression results.
Multiple plot types are available: scatter plot with regression line,
residual plot, and CUSUM plot for linearity assessment.
}
\details{
\strong{Scatter plot} (\code{type = "scatter"}):
Displays the raw data with the fitted Passing-Bablok regression line and
optional confidence band. The identity line (y = x) is shown for reference.
If the regression line overlaps substantially with the identity line, the
methods are in good agreement.

\strong{Residual plot} (\code{type = "residuals"}):
Displays perpendicular residuals. Look for:
\itemize{
\item Random scatter around zero (good)
\item Patterns or trends (suggests non-linearity)
\item Funnel shape (suggests heteroscedasticity)
}

\strong{CUSUM plot} (\code{type = "cusum"}):
Displays the cumulative sum of residual signs, used to assess linearity.
The CUSUM should stay within the critical bounds if the linearity assumption
holds.
}
\examples{
set.seed(42)
method_a <- rnorm(50, mean = 100, sd = 15)
method_b <- 1.05 * method_a + 3 + rnorm(50, sd = 5)
pb <- pb_regression(method_a, method_b)

# Scatter plot with regression line
plot(pb)

# Without identity line
plot(pb, show_identity = FALSE)

# Residual plot
plot(pb, type = "residuals")

# Residuals by rank
plot(pb, type = "residuals", residual_type = "rank")

# CUSUM plot
plot(pb, type = "cusum")

# Customized appearance
plot(pb, point_size = 3, title = "Glucose: POC vs Reference")

}
\seealso{
\code{\link[=pb_regression]{pb_regression()}} for performing the analysis,
\code{\link[=summary.pb_regression]{summary.pb_regression()}} for detailed results
}
