% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki.R
\name{wt_data}
\alias{wt_data}
\alias{wt_data_id}
\title{Wikidata taxonomy data}
\usage{
wt_data(x, property = NULL, ...)

wt_data_id(x, language = "en", limit = 10, ...)
}
\arguments{
\item{x}{(character) a taxonomic name}

\item{property}{(character) a property id, e.g., P486}

\item{...}{curl options passed on to \code{httr::GET()}}

\item{language}{(character) two letter language code}

\item{limit}{(integer) records to return. Default: 10}
}
\value{
\code{wt_data} searches Wikidata, and returns a list with elements:
\itemize{
\item labels - data.frame with columns: language, value
\item descriptions - data.frame with columns: language, value
\item aliases - data.frame with columns: language, value
\item sitelinks - data.frame with columns: site, title
\item claims - data.frame with columns: claims, property_value,
property_description, value (comma separated values in string)
}

\code{wt_data_id} gets the Wikidata ID for the searched term, and
returns the ID as character
}
\description{
Wikidata taxonomy data
}
\details{
Note that \code{wt_data} can take a while to run since when fetching
claims it has to do so one at a time for each claim

You can search things other than taxonomic names with \code{wt_data} if you
like
}
\examples{
\dontrun{
# search by taxon name
wt_data("Mimulus alsinoides")

# choose which properties to return
wt_data(x="Mimulus foliatus", property = c("P846", "P815"))

# get a taxonomic identifier
wt_data_id("Mimulus foliatus")

# the id can be passed directly to wt_data()
wt_data(wt_data_id("Mimulus foliatus"))
}
}
