; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+zfh -verify-machineinstrs < %s \
; RUN:   -target-abi=ilp32f | FileCheck -check-prefixes=CHECKIZFH,RV32IZFH %s
; RUN: llc -mtriple=riscv64 -mattr=+zfh -verify-machineinstrs < %s \
; RUN:   -target-abi=lp64f | FileCheck -check-prefixes=CHECKIZFH,RV64IZFH %s
; RUN: llc -mtriple=riscv32 -mattr=+zhinx -verify-machineinstrs < %s \
; RUN:   -target-abi=ilp32 | FileCheck -check-prefixes=CHECKIZHINX,RV32IZHINX %s
; RUN: llc -mtriple=riscv64 -mattr=+zhinx -verify-machineinstrs < %s \
; RUN:   -target-abi=lp64 | FileCheck -check-prefixes=CHECKIZHINX,RV64IZHINX %s
; RUN: llc -mtriple=riscv32 -mattr=+zfhmin -verify-machineinstrs < %s \
; RUN:   -target-abi=ilp32f | FileCheck -check-prefixes=CHECKIZFHMIN,RV32IZFHMIN %s
; RUN: llc -mtriple=riscv64 -mattr=+zfhmin -verify-machineinstrs < %s \
; RUN:   -target-abi=lp64f | FileCheck -check-prefixes=CHECKIZFHMIN,RV64IZFHMIN %s
; RUN: llc -mtriple=riscv32 -mattr=+zhinxmin -verify-machineinstrs < %s \
; RUN:   -target-abi=ilp32 | FileCheck -check-prefixes=CHECKIZHINXMIN,RV32IZHINXMIN %s
; RUN: llc -mtriple=riscv64 -mattr=+zhinxmin -verify-machineinstrs < %s \
; RUN:   -target-abi=lp64 | FileCheck -check-prefixes=CHECKIZHINXMIN,RV64IZHINXMIN %s

define signext i8 @test_floor_si8(half %x) {
; RV32IZFH-LABEL: test_floor_si8:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rdn
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_floor_si8:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rdn
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_floor_si8:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    li a1, 25
; RV32IZHINX-NEXT:    slli a1, a1, 10
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB0_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rdn
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rdn
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB0_2:
; RV32IZHINX-NEXT:    fcvt.w.h a0, a0, rtz
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_floor_si8:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    li a1, 25
; RV64IZHINX-NEXT:    slli a1, a1, 10
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB0_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rdn
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rdn
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB0_2:
; RV64IZHINX-NEXT:    fcvt.l.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_floor_si8:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB0_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rdn
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rdn
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB0_2:
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_floor_si8:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB0_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rdn
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rdn
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB0_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.l.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_floor_si8:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB0_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rdn
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rdn
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB0_2:
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_floor_si8:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB0_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rdn
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rdn
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB0_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.l.s a0, a0, rtz
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.floor.f16(half %x)
  %b = fptosi half %a to i8
  ret i8 %b
}

define signext i16 @test_floor_si16(half %x) {
; RV32IZFH-LABEL: test_floor_si16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rdn
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_floor_si16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rdn
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_floor_si16:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    li a1, 25
; RV32IZHINX-NEXT:    slli a1, a1, 10
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB1_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rdn
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rdn
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB1_2:
; RV32IZHINX-NEXT:    fcvt.w.h a0, a0, rtz
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_floor_si16:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    li a1, 25
; RV64IZHINX-NEXT:    slli a1, a1, 10
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB1_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rdn
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rdn
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB1_2:
; RV64IZHINX-NEXT:    fcvt.l.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_floor_si16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB1_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rdn
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rdn
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB1_2:
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_floor_si16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB1_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rdn
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rdn
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB1_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.l.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_floor_si16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB1_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rdn
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rdn
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB1_2:
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_floor_si16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB1_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rdn
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rdn
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB1_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.l.s a0, a0, rtz
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.floor.f16(half %x)
  %b = fptosi half %a to i16
  ret i16 %b
}

define signext i32 @test_floor_si32(half %x) {
; CHECKIZFH-LABEL: test_floor_si32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.w.h a0, fa0, rdn
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: test_floor_si32:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    li a1, 25
; CHECKIZHINX-NEXT:    slli a1, a1, 10
; CHECKIZHINX-NEXT:    fabs.h a2, a0
; CHECKIZHINX-NEXT:    flt.h a1, a2, a1
; CHECKIZHINX-NEXT:    beqz a1, .LBB2_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rdn
; CHECKIZHINX-NEXT:    fcvt.h.w a1, a1, rdn
; CHECKIZHINX-NEXT:    fsgnj.h a0, a1, a0
; CHECKIZHINX-NEXT:  .LBB2_2:
; CHECKIZHINX-NEXT:    fcvt.w.h a0, a0, rtz
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: test_floor_si32:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    lui a0, 307200
; CHECKIZFHMIN-NEXT:    fmv.w.x fa4, a0
; CHECKIZFHMIN-NEXT:    fabs.s fa3, fa5
; CHECKIZFHMIN-NEXT:    flt.s a0, fa3, fa4
; CHECKIZFHMIN-NEXT:    beqz a0, .LBB2_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rdn
; CHECKIZFHMIN-NEXT:    fcvt.s.w fa4, a0, rdn
; CHECKIZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:  .LBB2_2:
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: test_floor_si32:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    lui a1, 307200
; CHECKIZHINXMIN-NEXT:    fabs.s a2, a0
; CHECKIZHINXMIN-NEXT:    flt.s a1, a2, a1
; CHECKIZHINXMIN-NEXT:    beqz a1, .LBB2_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rdn
; CHECKIZHINXMIN-NEXT:    fcvt.s.w a1, a1, rdn
; CHECKIZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:  .LBB2_2:
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; CHECKIZHINXMIN-NEXT:    ret
  %a = call half @llvm.floor.f16(half %x)
  %b = fptosi half %a to i32
  ret i32 %b
}

define i64 @test_floor_si64(half %x) {
; RV32IZFH-LABEL: test_floor_si64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    lui a0, %hi(.LCPI3_0)
; RV32IZFH-NEXT:    flh fa5, %lo(.LCPI3_0)(a0)
; RV32IZFH-NEXT:    fabs.h fa4, fa0
; RV32IZFH-NEXT:    flt.h a0, fa4, fa5
; RV32IZFH-NEXT:    beqz a0, .LBB3_2
; RV32IZFH-NEXT:  # %bb.1:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rdn
; RV32IZFH-NEXT:    fcvt.h.w fa5, a0, rdn
; RV32IZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; RV32IZFH-NEXT:  .LBB3_2:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    .cfi_offset ra, -4
; RV32IZFH-NEXT:    call __fixhfdi
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    .cfi_restore ra
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_floor_si64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rdn
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_floor_si64:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    li a1, 25
; RV32IZHINX-NEXT:    slli a1, a1, 10
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB3_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rdn
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rdn
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB3_2:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    .cfi_def_cfa_offset 16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    .cfi_offset ra, -4
; RV32IZHINX-NEXT:    call __fixhfdi
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    .cfi_restore ra
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    .cfi_def_cfa_offset 0
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_floor_si64:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    li a1, 25
; RV64IZHINX-NEXT:    slli a1, a1, 10
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB3_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rdn
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rdn
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB3_2:
; RV64IZHINX-NEXT:    fcvt.l.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_floor_si64:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB3_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rdn
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rdn
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB3_2:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    .cfi_offset ra, -4
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; RV32IZFHMIN-NEXT:    call __fixhfdi
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    .cfi_restore ra
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_floor_si64:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB3_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rdn
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rdn
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB3_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.l.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_floor_si64:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB3_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rdn
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rdn
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB3_2:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    .cfi_def_cfa_offset 16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    .cfi_offset ra, -4
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    call __fixhfdi
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    .cfi_restore ra
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    .cfi_def_cfa_offset 0
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_floor_si64:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB3_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rdn
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rdn
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB3_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.l.s a0, a0, rtz
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.floor.f16(half %x)
  %b = fptosi half %a to i64
  ret i64 %b
}

define zeroext i8 @test_floor_ui8(half %x) {
; RV32IZFH-LABEL: test_floor_ui8:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.wu.h a0, fa0, rdn
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_floor_ui8:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rdn
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_floor_ui8:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    li a1, 25
; RV32IZHINX-NEXT:    slli a1, a1, 10
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB4_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rdn
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rdn
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB4_2:
; RV32IZHINX-NEXT:    fcvt.wu.h a0, a0, rtz
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_floor_ui8:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    li a1, 25
; RV64IZHINX-NEXT:    slli a1, a1, 10
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB4_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rdn
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rdn
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB4_2:
; RV64IZHINX-NEXT:    fcvt.lu.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_floor_ui8:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB4_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rdn
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rdn
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB4_2:
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_floor_ui8:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB4_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rdn
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rdn
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB4_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.lu.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_floor_ui8:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB4_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rdn
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rdn
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB4_2:
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_floor_ui8:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB4_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rdn
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rdn
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB4_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.lu.s a0, a0, rtz
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.floor.f16(half %x)
  %b = fptoui half %a to i8
  ret i8 %b
}

define zeroext i16 @test_floor_ui16(half %x) {
; RV32IZFH-LABEL: test_floor_ui16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.wu.h a0, fa0, rdn
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_floor_ui16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rdn
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_floor_ui16:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    li a1, 25
; RV32IZHINX-NEXT:    slli a1, a1, 10
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB5_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rdn
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rdn
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB5_2:
; RV32IZHINX-NEXT:    fcvt.wu.h a0, a0, rtz
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_floor_ui16:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    li a1, 25
; RV64IZHINX-NEXT:    slli a1, a1, 10
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB5_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rdn
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rdn
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB5_2:
; RV64IZHINX-NEXT:    fcvt.lu.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_floor_ui16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB5_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rdn
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rdn
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB5_2:
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_floor_ui16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB5_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rdn
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rdn
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB5_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.lu.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_floor_ui16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB5_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rdn
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rdn
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB5_2:
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_floor_ui16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB5_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rdn
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rdn
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB5_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.lu.s a0, a0, rtz
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.floor.f16(half %x)
  %b = fptoui half %a to i16
  ret i16 %b
}

define signext i32 @test_floor_ui32(half %x) {
; CHECKIZFH-LABEL: test_floor_ui32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.wu.h a0, fa0, rdn
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: test_floor_ui32:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    li a1, 25
; CHECKIZHINX-NEXT:    slli a1, a1, 10
; CHECKIZHINX-NEXT:    fabs.h a2, a0
; CHECKIZHINX-NEXT:    flt.h a1, a2, a1
; CHECKIZHINX-NEXT:    beqz a1, .LBB6_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rdn
; CHECKIZHINX-NEXT:    fcvt.h.w a1, a1, rdn
; CHECKIZHINX-NEXT:    fsgnj.h a0, a1, a0
; CHECKIZHINX-NEXT:  .LBB6_2:
; CHECKIZHINX-NEXT:    fcvt.wu.h a0, a0, rtz
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: test_floor_ui32:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    lui a0, 307200
; CHECKIZFHMIN-NEXT:    fmv.w.x fa4, a0
; CHECKIZFHMIN-NEXT:    fabs.s fa3, fa5
; CHECKIZFHMIN-NEXT:    flt.s a0, fa3, fa4
; CHECKIZFHMIN-NEXT:    beqz a0, .LBB6_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rdn
; CHECKIZFHMIN-NEXT:    fcvt.s.w fa4, a0, rdn
; CHECKIZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:  .LBB6_2:
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.wu.s a0, fa5, rtz
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: test_floor_ui32:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    lui a1, 307200
; CHECKIZHINXMIN-NEXT:    fabs.s a2, a0
; CHECKIZHINXMIN-NEXT:    flt.s a1, a2, a1
; CHECKIZHINXMIN-NEXT:    beqz a1, .LBB6_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rdn
; CHECKIZHINXMIN-NEXT:    fcvt.s.w a1, a1, rdn
; CHECKIZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:  .LBB6_2:
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.wu.s a0, a0, rtz
; CHECKIZHINXMIN-NEXT:    ret
  %a = call half @llvm.floor.f16(half %x)
  %b = fptoui half %a to i32
  ret i32 %b
}

define i64 @test_floor_ui64(half %x) {
; RV32IZFH-LABEL: test_floor_ui64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    lui a0, %hi(.LCPI7_0)
; RV32IZFH-NEXT:    flh fa5, %lo(.LCPI7_0)(a0)
; RV32IZFH-NEXT:    fabs.h fa4, fa0
; RV32IZFH-NEXT:    flt.h a0, fa4, fa5
; RV32IZFH-NEXT:    beqz a0, .LBB7_2
; RV32IZFH-NEXT:  # %bb.1:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rdn
; RV32IZFH-NEXT:    fcvt.h.w fa5, a0, rdn
; RV32IZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; RV32IZFH-NEXT:  .LBB7_2:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    .cfi_offset ra, -4
; RV32IZFH-NEXT:    call __fixunshfdi
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    .cfi_restore ra
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_floor_ui64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rdn
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_floor_ui64:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    li a1, 25
; RV32IZHINX-NEXT:    slli a1, a1, 10
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB7_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rdn
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rdn
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB7_2:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    .cfi_def_cfa_offset 16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    .cfi_offset ra, -4
; RV32IZHINX-NEXT:    call __fixunshfdi
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    .cfi_restore ra
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    .cfi_def_cfa_offset 0
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_floor_ui64:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    li a1, 25
; RV64IZHINX-NEXT:    slli a1, a1, 10
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB7_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rdn
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rdn
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB7_2:
; RV64IZHINX-NEXT:    fcvt.lu.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_floor_ui64:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB7_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rdn
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rdn
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB7_2:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    .cfi_offset ra, -4
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; RV32IZFHMIN-NEXT:    call __fixunshfdi
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    .cfi_restore ra
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_floor_ui64:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB7_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rdn
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rdn
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB7_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.lu.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_floor_ui64:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB7_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rdn
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rdn
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB7_2:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    .cfi_def_cfa_offset 16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    .cfi_offset ra, -4
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    call __fixunshfdi
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    .cfi_restore ra
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    .cfi_def_cfa_offset 0
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_floor_ui64:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB7_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rdn
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rdn
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB7_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.lu.s a0, a0, rtz
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.floor.f16(half %x)
  %b = fptoui half %a to i64
  ret i64 %b
}

define signext i8 @test_ceil_si8(half %x) {
; RV32IZFH-LABEL: test_ceil_si8:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rup
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_ceil_si8:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rup
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_ceil_si8:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    li a1, 25
; RV32IZHINX-NEXT:    slli a1, a1, 10
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB8_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rup
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rup
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB8_2:
; RV32IZHINX-NEXT:    fcvt.w.h a0, a0, rtz
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_ceil_si8:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    li a1, 25
; RV64IZHINX-NEXT:    slli a1, a1, 10
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB8_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rup
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rup
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB8_2:
; RV64IZHINX-NEXT:    fcvt.l.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_ceil_si8:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB8_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rup
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rup
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB8_2:
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_ceil_si8:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB8_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rup
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rup
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB8_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.l.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_ceil_si8:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB8_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rup
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rup
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB8_2:
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_ceil_si8:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB8_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rup
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rup
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB8_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.l.s a0, a0, rtz
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.ceil.f16(half %x)
  %b = fptosi half %a to i8
  ret i8 %b
}

define signext i16 @test_ceil_si16(half %x) {
; RV32IZFH-LABEL: test_ceil_si16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rup
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_ceil_si16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rup
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_ceil_si16:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    li a1, 25
; RV32IZHINX-NEXT:    slli a1, a1, 10
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB9_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rup
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rup
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB9_2:
; RV32IZHINX-NEXT:    fcvt.w.h a0, a0, rtz
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_ceil_si16:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    li a1, 25
; RV64IZHINX-NEXT:    slli a1, a1, 10
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB9_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rup
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rup
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB9_2:
; RV64IZHINX-NEXT:    fcvt.l.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_ceil_si16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB9_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rup
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rup
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB9_2:
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_ceil_si16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB9_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rup
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rup
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB9_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.l.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_ceil_si16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB9_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rup
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rup
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB9_2:
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_ceil_si16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB9_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rup
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rup
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB9_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.l.s a0, a0, rtz
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.ceil.f16(half %x)
  %b = fptosi half %a to i16
  ret i16 %b
}

define signext i32 @test_ceil_si32(half %x) {
; CHECKIZFH-LABEL: test_ceil_si32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.w.h a0, fa0, rup
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: test_ceil_si32:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    li a1, 25
; CHECKIZHINX-NEXT:    slli a1, a1, 10
; CHECKIZHINX-NEXT:    fabs.h a2, a0
; CHECKIZHINX-NEXT:    flt.h a1, a2, a1
; CHECKIZHINX-NEXT:    beqz a1, .LBB10_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rup
; CHECKIZHINX-NEXT:    fcvt.h.w a1, a1, rup
; CHECKIZHINX-NEXT:    fsgnj.h a0, a1, a0
; CHECKIZHINX-NEXT:  .LBB10_2:
; CHECKIZHINX-NEXT:    fcvt.w.h a0, a0, rtz
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: test_ceil_si32:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    lui a0, 307200
; CHECKIZFHMIN-NEXT:    fmv.w.x fa4, a0
; CHECKIZFHMIN-NEXT:    fabs.s fa3, fa5
; CHECKIZFHMIN-NEXT:    flt.s a0, fa3, fa4
; CHECKIZFHMIN-NEXT:    beqz a0, .LBB10_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rup
; CHECKIZFHMIN-NEXT:    fcvt.s.w fa4, a0, rup
; CHECKIZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:  .LBB10_2:
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: test_ceil_si32:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    lui a1, 307200
; CHECKIZHINXMIN-NEXT:    fabs.s a2, a0
; CHECKIZHINXMIN-NEXT:    flt.s a1, a2, a1
; CHECKIZHINXMIN-NEXT:    beqz a1, .LBB10_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rup
; CHECKIZHINXMIN-NEXT:    fcvt.s.w a1, a1, rup
; CHECKIZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:  .LBB10_2:
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; CHECKIZHINXMIN-NEXT:    ret
  %a = call half @llvm.ceil.f16(half %x)
  %b = fptosi half %a to i32
  ret i32 %b
}

define i64 @test_ceil_si64(half %x) {
; RV32IZFH-LABEL: test_ceil_si64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    lui a0, %hi(.LCPI11_0)
; RV32IZFH-NEXT:    flh fa5, %lo(.LCPI11_0)(a0)
; RV32IZFH-NEXT:    fabs.h fa4, fa0
; RV32IZFH-NEXT:    flt.h a0, fa4, fa5
; RV32IZFH-NEXT:    beqz a0, .LBB11_2
; RV32IZFH-NEXT:  # %bb.1:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rup
; RV32IZFH-NEXT:    fcvt.h.w fa5, a0, rup
; RV32IZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; RV32IZFH-NEXT:  .LBB11_2:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    .cfi_offset ra, -4
; RV32IZFH-NEXT:    call __fixhfdi
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    .cfi_restore ra
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_ceil_si64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rup
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_ceil_si64:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    li a1, 25
; RV32IZHINX-NEXT:    slli a1, a1, 10
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB11_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rup
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rup
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB11_2:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    .cfi_def_cfa_offset 16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    .cfi_offset ra, -4
; RV32IZHINX-NEXT:    call __fixhfdi
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    .cfi_restore ra
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    .cfi_def_cfa_offset 0
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_ceil_si64:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    li a1, 25
; RV64IZHINX-NEXT:    slli a1, a1, 10
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB11_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rup
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rup
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB11_2:
; RV64IZHINX-NEXT:    fcvt.l.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_ceil_si64:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB11_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rup
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rup
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB11_2:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    .cfi_offset ra, -4
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; RV32IZFHMIN-NEXT:    call __fixhfdi
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    .cfi_restore ra
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_ceil_si64:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB11_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rup
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rup
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB11_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.l.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_ceil_si64:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB11_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rup
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rup
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB11_2:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    .cfi_def_cfa_offset 16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    .cfi_offset ra, -4
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    call __fixhfdi
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    .cfi_restore ra
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    .cfi_def_cfa_offset 0
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_ceil_si64:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB11_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rup
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rup
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB11_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.l.s a0, a0, rtz
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.ceil.f16(half %x)
  %b = fptosi half %a to i64
  ret i64 %b
}

define zeroext i8 @test_ceil_ui8(half %x) {
; RV32IZFH-LABEL: test_ceil_ui8:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.wu.h a0, fa0, rup
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_ceil_ui8:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rup
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_ceil_ui8:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    li a1, 25
; RV32IZHINX-NEXT:    slli a1, a1, 10
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB12_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rup
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rup
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB12_2:
; RV32IZHINX-NEXT:    fcvt.wu.h a0, a0, rtz
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_ceil_ui8:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    li a1, 25
; RV64IZHINX-NEXT:    slli a1, a1, 10
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB12_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rup
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rup
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB12_2:
; RV64IZHINX-NEXT:    fcvt.lu.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_ceil_ui8:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB12_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rup
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rup
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB12_2:
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_ceil_ui8:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB12_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rup
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rup
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB12_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.lu.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_ceil_ui8:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB12_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rup
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rup
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB12_2:
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_ceil_ui8:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB12_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rup
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rup
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB12_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.lu.s a0, a0, rtz
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.ceil.f16(half %x)
  %b = fptoui half %a to i8
  ret i8 %b
}

define zeroext i16 @test_ceil_ui16(half %x) {
; RV32IZFH-LABEL: test_ceil_ui16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.wu.h a0, fa0, rup
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_ceil_ui16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rup
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_ceil_ui16:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    li a1, 25
; RV32IZHINX-NEXT:    slli a1, a1, 10
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB13_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rup
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rup
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB13_2:
; RV32IZHINX-NEXT:    fcvt.wu.h a0, a0, rtz
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_ceil_ui16:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    li a1, 25
; RV64IZHINX-NEXT:    slli a1, a1, 10
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB13_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rup
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rup
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB13_2:
; RV64IZHINX-NEXT:    fcvt.lu.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_ceil_ui16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB13_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rup
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rup
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB13_2:
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_ceil_ui16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB13_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rup
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rup
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB13_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.lu.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_ceil_ui16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB13_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rup
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rup
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB13_2:
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_ceil_ui16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB13_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rup
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rup
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB13_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.lu.s a0, a0, rtz
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.ceil.f16(half %x)
  %b = fptoui half %a to i16
  ret i16 %b
}

define signext i32 @test_ceil_ui32(half %x) {
; CHECKIZFH-LABEL: test_ceil_ui32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.wu.h a0, fa0, rup
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: test_ceil_ui32:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    li a1, 25
; CHECKIZHINX-NEXT:    slli a1, a1, 10
; CHECKIZHINX-NEXT:    fabs.h a2, a0
; CHECKIZHINX-NEXT:    flt.h a1, a2, a1
; CHECKIZHINX-NEXT:    beqz a1, .LBB14_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rup
; CHECKIZHINX-NEXT:    fcvt.h.w a1, a1, rup
; CHECKIZHINX-NEXT:    fsgnj.h a0, a1, a0
; CHECKIZHINX-NEXT:  .LBB14_2:
; CHECKIZHINX-NEXT:    fcvt.wu.h a0, a0, rtz
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: test_ceil_ui32:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    lui a0, 307200
; CHECKIZFHMIN-NEXT:    fmv.w.x fa4, a0
; CHECKIZFHMIN-NEXT:    fabs.s fa3, fa5
; CHECKIZFHMIN-NEXT:    flt.s a0, fa3, fa4
; CHECKIZFHMIN-NEXT:    beqz a0, .LBB14_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rup
; CHECKIZFHMIN-NEXT:    fcvt.s.w fa4, a0, rup
; CHECKIZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:  .LBB14_2:
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.wu.s a0, fa5, rtz
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: test_ceil_ui32:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    lui a1, 307200
; CHECKIZHINXMIN-NEXT:    fabs.s a2, a0
; CHECKIZHINXMIN-NEXT:    flt.s a1, a2, a1
; CHECKIZHINXMIN-NEXT:    beqz a1, .LBB14_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rup
; CHECKIZHINXMIN-NEXT:    fcvt.s.w a1, a1, rup
; CHECKIZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:  .LBB14_2:
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.wu.s a0, a0, rtz
; CHECKIZHINXMIN-NEXT:    ret
  %a = call half @llvm.ceil.f16(half %x)
  %b = fptoui half %a to i32
  ret i32 %b
}

define i64 @test_ceil_ui64(half %x) {
; RV32IZFH-LABEL: test_ceil_ui64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    lui a0, %hi(.LCPI15_0)
; RV32IZFH-NEXT:    flh fa5, %lo(.LCPI15_0)(a0)
; RV32IZFH-NEXT:    fabs.h fa4, fa0
; RV32IZFH-NEXT:    flt.h a0, fa4, fa5
; RV32IZFH-NEXT:    beqz a0, .LBB15_2
; RV32IZFH-NEXT:  # %bb.1:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rup
; RV32IZFH-NEXT:    fcvt.h.w fa5, a0, rup
; RV32IZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; RV32IZFH-NEXT:  .LBB15_2:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    .cfi_offset ra, -4
; RV32IZFH-NEXT:    call __fixunshfdi
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    .cfi_restore ra
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_ceil_ui64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rup
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_ceil_ui64:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    li a1, 25
; RV32IZHINX-NEXT:    slli a1, a1, 10
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB15_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rup
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rup
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB15_2:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    .cfi_def_cfa_offset 16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    .cfi_offset ra, -4
; RV32IZHINX-NEXT:    call __fixunshfdi
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    .cfi_restore ra
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    .cfi_def_cfa_offset 0
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_ceil_ui64:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    li a1, 25
; RV64IZHINX-NEXT:    slli a1, a1, 10
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB15_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rup
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rup
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB15_2:
; RV64IZHINX-NEXT:    fcvt.lu.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_ceil_ui64:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB15_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rup
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rup
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB15_2:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    .cfi_offset ra, -4
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; RV32IZFHMIN-NEXT:    call __fixunshfdi
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    .cfi_restore ra
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_ceil_ui64:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB15_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rup
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rup
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB15_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.lu.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_ceil_ui64:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB15_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rup
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rup
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB15_2:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    .cfi_def_cfa_offset 16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    .cfi_offset ra, -4
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    call __fixunshfdi
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    .cfi_restore ra
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    .cfi_def_cfa_offset 0
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_ceil_ui64:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB15_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rup
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rup
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB15_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.lu.s a0, a0, rtz
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.ceil.f16(half %x)
  %b = fptoui half %a to i64
  ret i64 %b
}

define signext i8 @test_trunc_si8(half %x) {
; RV32IZFH-LABEL: test_trunc_si8:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rtz
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_trunc_si8:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rtz
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_trunc_si8:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    li a1, 25
; RV32IZHINX-NEXT:    slli a1, a1, 10
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB16_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rtz
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rtz
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB16_2:
; RV32IZHINX-NEXT:    fcvt.w.h a0, a0, rtz
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_trunc_si8:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    li a1, 25
; RV64IZHINX-NEXT:    slli a1, a1, 10
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB16_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rtz
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rtz
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB16_2:
; RV64IZHINX-NEXT:    fcvt.l.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_trunc_si8:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB16_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rtz
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB16_2:
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_trunc_si8:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB16_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rtz
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB16_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.l.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_trunc_si8:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB16_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rtz
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rtz
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB16_2:
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_trunc_si8:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB16_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rtz
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rtz
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB16_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.l.s a0, a0, rtz
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.trunc.f16(half %x)
  %b = fptosi half %a to i8
  ret i8 %b
}

define signext i16 @test_trunc_si16(half %x) {
; RV32IZFH-LABEL: test_trunc_si16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rtz
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_trunc_si16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rtz
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_trunc_si16:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    li a1, 25
; RV32IZHINX-NEXT:    slli a1, a1, 10
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB17_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rtz
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rtz
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB17_2:
; RV32IZHINX-NEXT:    fcvt.w.h a0, a0, rtz
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_trunc_si16:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    li a1, 25
; RV64IZHINX-NEXT:    slli a1, a1, 10
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB17_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rtz
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rtz
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB17_2:
; RV64IZHINX-NEXT:    fcvt.l.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_trunc_si16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB17_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rtz
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB17_2:
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_trunc_si16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB17_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rtz
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB17_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.l.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_trunc_si16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB17_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rtz
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rtz
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB17_2:
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_trunc_si16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB17_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rtz
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rtz
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB17_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.l.s a0, a0, rtz
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.trunc.f16(half %x)
  %b = fptosi half %a to i16
  ret i16 %b
}

define signext i32 @test_trunc_si32(half %x) {
; CHECKIZFH-LABEL: test_trunc_si32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.w.h a0, fa0, rtz
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: test_trunc_si32:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    li a1, 25
; CHECKIZHINX-NEXT:    slli a1, a1, 10
; CHECKIZHINX-NEXT:    fabs.h a2, a0
; CHECKIZHINX-NEXT:    flt.h a1, a2, a1
; CHECKIZHINX-NEXT:    beqz a1, .LBB18_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rtz
; CHECKIZHINX-NEXT:    fcvt.h.w a1, a1, rtz
; CHECKIZHINX-NEXT:    fsgnj.h a0, a1, a0
; CHECKIZHINX-NEXT:  .LBB18_2:
; CHECKIZHINX-NEXT:    fcvt.w.h a0, a0, rtz
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: test_trunc_si32:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    lui a0, 307200
; CHECKIZFHMIN-NEXT:    fmv.w.x fa4, a0
; CHECKIZFHMIN-NEXT:    fabs.s fa3, fa5
; CHECKIZFHMIN-NEXT:    flt.s a0, fa3, fa4
; CHECKIZFHMIN-NEXT:    beqz a0, .LBB18_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; CHECKIZFHMIN-NEXT:    fcvt.s.w fa4, a0, rtz
; CHECKIZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:  .LBB18_2:
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: test_trunc_si32:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    lui a1, 307200
; CHECKIZHINXMIN-NEXT:    fabs.s a2, a0
; CHECKIZHINXMIN-NEXT:    flt.s a1, a2, a1
; CHECKIZHINXMIN-NEXT:    beqz a1, .LBB18_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rtz
; CHECKIZHINXMIN-NEXT:    fcvt.s.w a1, a1, rtz
; CHECKIZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:  .LBB18_2:
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; CHECKIZHINXMIN-NEXT:    ret
  %a = call half @llvm.trunc.f16(half %x)
  %b = fptosi half %a to i32
  ret i32 %b
}

define i64 @test_trunc_si64(half %x) {
; RV32IZFH-LABEL: test_trunc_si64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    lui a0, %hi(.LCPI19_0)
; RV32IZFH-NEXT:    flh fa5, %lo(.LCPI19_0)(a0)
; RV32IZFH-NEXT:    fabs.h fa4, fa0
; RV32IZFH-NEXT:    flt.h a0, fa4, fa5
; RV32IZFH-NEXT:    beqz a0, .LBB19_2
; RV32IZFH-NEXT:  # %bb.1:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rtz
; RV32IZFH-NEXT:    fcvt.h.w fa5, a0, rtz
; RV32IZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; RV32IZFH-NEXT:  .LBB19_2:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    .cfi_offset ra, -4
; RV32IZFH-NEXT:    call __fixhfdi
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    .cfi_restore ra
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_trunc_si64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rtz
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_trunc_si64:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    li a1, 25
; RV32IZHINX-NEXT:    slli a1, a1, 10
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB19_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rtz
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rtz
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB19_2:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    .cfi_def_cfa_offset 16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    .cfi_offset ra, -4
; RV32IZHINX-NEXT:    call __fixhfdi
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    .cfi_restore ra
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    .cfi_def_cfa_offset 0
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_trunc_si64:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    li a1, 25
; RV64IZHINX-NEXT:    slli a1, a1, 10
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB19_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rtz
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rtz
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB19_2:
; RV64IZHINX-NEXT:    fcvt.l.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_trunc_si64:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB19_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rtz
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB19_2:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    .cfi_offset ra, -4
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; RV32IZFHMIN-NEXT:    call __fixhfdi
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    .cfi_restore ra
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_trunc_si64:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB19_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rtz
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB19_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.l.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_trunc_si64:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB19_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rtz
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rtz
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB19_2:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    .cfi_def_cfa_offset 16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    .cfi_offset ra, -4
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    call __fixhfdi
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    .cfi_restore ra
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    .cfi_def_cfa_offset 0
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_trunc_si64:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB19_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rtz
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rtz
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB19_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.l.s a0, a0, rtz
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.trunc.f16(half %x)
  %b = fptosi half %a to i64
  ret i64 %b
}

define zeroext i8 @test_trunc_ui8(half %x) {
; RV32IZFH-LABEL: test_trunc_ui8:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.wu.h a0, fa0, rtz
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_trunc_ui8:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rtz
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_trunc_ui8:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    li a1, 25
; RV32IZHINX-NEXT:    slli a1, a1, 10
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB20_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rtz
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rtz
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB20_2:
; RV32IZHINX-NEXT:    fcvt.wu.h a0, a0, rtz
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_trunc_ui8:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    li a1, 25
; RV64IZHINX-NEXT:    slli a1, a1, 10
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB20_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rtz
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rtz
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB20_2:
; RV64IZHINX-NEXT:    fcvt.lu.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_trunc_ui8:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB20_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rtz
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB20_2:
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_trunc_ui8:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB20_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rtz
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB20_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.lu.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_trunc_ui8:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB20_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rtz
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rtz
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB20_2:
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_trunc_ui8:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB20_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rtz
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rtz
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB20_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.lu.s a0, a0, rtz
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.trunc.f16(half %x)
  %b = fptoui half %a to i8
  ret i8 %b
}

define zeroext i16 @test_trunc_ui16(half %x) {
; RV32IZFH-LABEL: test_trunc_ui16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.wu.h a0, fa0, rtz
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_trunc_ui16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rtz
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_trunc_ui16:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    li a1, 25
; RV32IZHINX-NEXT:    slli a1, a1, 10
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB21_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rtz
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rtz
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB21_2:
; RV32IZHINX-NEXT:    fcvt.wu.h a0, a0, rtz
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_trunc_ui16:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    li a1, 25
; RV64IZHINX-NEXT:    slli a1, a1, 10
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB21_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rtz
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rtz
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB21_2:
; RV64IZHINX-NEXT:    fcvt.lu.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_trunc_ui16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB21_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rtz
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB21_2:
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_trunc_ui16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB21_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rtz
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB21_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.lu.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_trunc_ui16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB21_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rtz
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rtz
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB21_2:
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_trunc_ui16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB21_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rtz
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rtz
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB21_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.lu.s a0, a0, rtz
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.trunc.f16(half %x)
  %b = fptoui half %a to i16
  ret i16 %b
}

define signext i32 @test_trunc_ui32(half %x) {
; CHECKIZFH-LABEL: test_trunc_ui32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.wu.h a0, fa0, rtz
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: test_trunc_ui32:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    li a1, 25
; CHECKIZHINX-NEXT:    slli a1, a1, 10
; CHECKIZHINX-NEXT:    fabs.h a2, a0
; CHECKIZHINX-NEXT:    flt.h a1, a2, a1
; CHECKIZHINX-NEXT:    beqz a1, .LBB22_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rtz
; CHECKIZHINX-NEXT:    fcvt.h.w a1, a1, rtz
; CHECKIZHINX-NEXT:    fsgnj.h a0, a1, a0
; CHECKIZHINX-NEXT:  .LBB22_2:
; CHECKIZHINX-NEXT:    fcvt.wu.h a0, a0, rtz
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: test_trunc_ui32:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    lui a0, 307200
; CHECKIZFHMIN-NEXT:    fmv.w.x fa4, a0
; CHECKIZFHMIN-NEXT:    fabs.s fa3, fa5
; CHECKIZFHMIN-NEXT:    flt.s a0, fa3, fa4
; CHECKIZFHMIN-NEXT:    beqz a0, .LBB22_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; CHECKIZFHMIN-NEXT:    fcvt.s.w fa4, a0, rtz
; CHECKIZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:  .LBB22_2:
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.wu.s a0, fa5, rtz
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: test_trunc_ui32:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    lui a1, 307200
; CHECKIZHINXMIN-NEXT:    fabs.s a2, a0
; CHECKIZHINXMIN-NEXT:    flt.s a1, a2, a1
; CHECKIZHINXMIN-NEXT:    beqz a1, .LBB22_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rtz
; CHECKIZHINXMIN-NEXT:    fcvt.s.w a1, a1, rtz
; CHECKIZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:  .LBB22_2:
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.wu.s a0, a0, rtz
; CHECKIZHINXMIN-NEXT:    ret
  %a = call half @llvm.trunc.f16(half %x)
  %b = fptoui half %a to i32
  ret i32 %b
}

define i64 @test_trunc_ui64(half %x) {
; RV32IZFH-LABEL: test_trunc_ui64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    lui a0, %hi(.LCPI23_0)
; RV32IZFH-NEXT:    flh fa5, %lo(.LCPI23_0)(a0)
; RV32IZFH-NEXT:    fabs.h fa4, fa0
; RV32IZFH-NEXT:    flt.h a0, fa4, fa5
; RV32IZFH-NEXT:    beqz a0, .LBB23_2
; RV32IZFH-NEXT:  # %bb.1:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rtz
; RV32IZFH-NEXT:    fcvt.h.w fa5, a0, rtz
; RV32IZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; RV32IZFH-NEXT:  .LBB23_2:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    .cfi_offset ra, -4
; RV32IZFH-NEXT:    call __fixunshfdi
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    .cfi_restore ra
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_trunc_ui64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rtz
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_trunc_ui64:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    li a1, 25
; RV32IZHINX-NEXT:    slli a1, a1, 10
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB23_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rtz
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rtz
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB23_2:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    .cfi_def_cfa_offset 16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    .cfi_offset ra, -4
; RV32IZHINX-NEXT:    call __fixunshfdi
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    .cfi_restore ra
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    .cfi_def_cfa_offset 0
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_trunc_ui64:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    li a1, 25
; RV64IZHINX-NEXT:    slli a1, a1, 10
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB23_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rtz
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rtz
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB23_2:
; RV64IZHINX-NEXT:    fcvt.lu.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_trunc_ui64:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB23_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rtz
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB23_2:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    .cfi_offset ra, -4
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; RV32IZFHMIN-NEXT:    call __fixunshfdi
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    .cfi_restore ra
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_trunc_ui64:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB23_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rtz
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB23_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.lu.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_trunc_ui64:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB23_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rtz
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rtz
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB23_2:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    .cfi_def_cfa_offset 16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    .cfi_offset ra, -4
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    call __fixunshfdi
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    .cfi_restore ra
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    .cfi_def_cfa_offset 0
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_trunc_ui64:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB23_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rtz
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rtz
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB23_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.lu.s a0, a0, rtz
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.trunc.f16(half %x)
  %b = fptoui half %a to i64
  ret i64 %b
}

define signext i8 @test_round_si8(half %x) {
; RV32IZFH-LABEL: test_round_si8:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rmm
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_round_si8:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rmm
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_round_si8:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    li a1, 25
; RV32IZHINX-NEXT:    slli a1, a1, 10
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB24_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rmm
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rmm
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB24_2:
; RV32IZHINX-NEXT:    fcvt.w.h a0, a0, rtz
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_round_si8:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    li a1, 25
; RV64IZHINX-NEXT:    slli a1, a1, 10
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB24_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rmm
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rmm
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB24_2:
; RV64IZHINX-NEXT:    fcvt.l.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_round_si8:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB24_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rmm
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rmm
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB24_2:
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_round_si8:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB24_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rmm
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rmm
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB24_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.l.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_round_si8:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB24_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rmm
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rmm
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB24_2:
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_round_si8:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB24_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rmm
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rmm
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB24_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.l.s a0, a0, rtz
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.round.f16(half %x)
  %b = fptosi half %a to i8
  ret i8 %b
}

define signext i16 @test_round_si16(half %x) {
; RV32IZFH-LABEL: test_round_si16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rmm
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_round_si16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rmm
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_round_si16:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    li a1, 25
; RV32IZHINX-NEXT:    slli a1, a1, 10
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB25_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rmm
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rmm
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB25_2:
; RV32IZHINX-NEXT:    fcvt.w.h a0, a0, rtz
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_round_si16:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    li a1, 25
; RV64IZHINX-NEXT:    slli a1, a1, 10
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB25_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rmm
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rmm
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB25_2:
; RV64IZHINX-NEXT:    fcvt.l.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_round_si16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB25_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rmm
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rmm
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB25_2:
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_round_si16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB25_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rmm
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rmm
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB25_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.l.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_round_si16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB25_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rmm
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rmm
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB25_2:
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_round_si16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB25_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rmm
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rmm
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB25_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.l.s a0, a0, rtz
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.round.f16(half %x)
  %b = fptosi half %a to i16
  ret i16 %b
}

define signext i32 @test_round_si32(half %x) {
; CHECKIZFH-LABEL: test_round_si32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.w.h a0, fa0, rmm
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: test_round_si32:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    li a1, 25
; CHECKIZHINX-NEXT:    slli a1, a1, 10
; CHECKIZHINX-NEXT:    fabs.h a2, a0
; CHECKIZHINX-NEXT:    flt.h a1, a2, a1
; CHECKIZHINX-NEXT:    beqz a1, .LBB26_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rmm
; CHECKIZHINX-NEXT:    fcvt.h.w a1, a1, rmm
; CHECKIZHINX-NEXT:    fsgnj.h a0, a1, a0
; CHECKIZHINX-NEXT:  .LBB26_2:
; CHECKIZHINX-NEXT:    fcvt.w.h a0, a0, rtz
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: test_round_si32:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    lui a0, 307200
; CHECKIZFHMIN-NEXT:    fmv.w.x fa4, a0
; CHECKIZFHMIN-NEXT:    fabs.s fa3, fa5
; CHECKIZFHMIN-NEXT:    flt.s a0, fa3, fa4
; CHECKIZFHMIN-NEXT:    beqz a0, .LBB26_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rmm
; CHECKIZFHMIN-NEXT:    fcvt.s.w fa4, a0, rmm
; CHECKIZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:  .LBB26_2:
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: test_round_si32:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    lui a1, 307200
; CHECKIZHINXMIN-NEXT:    fabs.s a2, a0
; CHECKIZHINXMIN-NEXT:    flt.s a1, a2, a1
; CHECKIZHINXMIN-NEXT:    beqz a1, .LBB26_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rmm
; CHECKIZHINXMIN-NEXT:    fcvt.s.w a1, a1, rmm
; CHECKIZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:  .LBB26_2:
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; CHECKIZHINXMIN-NEXT:    ret
  %a = call half @llvm.round.f16(half %x)
  %b = fptosi half %a to i32
  ret i32 %b
}

define i64 @test_round_si64(half %x) {
; RV32IZFH-LABEL: test_round_si64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    lui a0, %hi(.LCPI27_0)
; RV32IZFH-NEXT:    flh fa5, %lo(.LCPI27_0)(a0)
; RV32IZFH-NEXT:    fabs.h fa4, fa0
; RV32IZFH-NEXT:    flt.h a0, fa4, fa5
; RV32IZFH-NEXT:    beqz a0, .LBB27_2
; RV32IZFH-NEXT:  # %bb.1:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rmm
; RV32IZFH-NEXT:    fcvt.h.w fa5, a0, rmm
; RV32IZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; RV32IZFH-NEXT:  .LBB27_2:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    .cfi_offset ra, -4
; RV32IZFH-NEXT:    call __fixhfdi
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    .cfi_restore ra
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_round_si64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rmm
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_round_si64:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    li a1, 25
; RV32IZHINX-NEXT:    slli a1, a1, 10
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB27_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rmm
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rmm
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB27_2:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    .cfi_def_cfa_offset 16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    .cfi_offset ra, -4
; RV32IZHINX-NEXT:    call __fixhfdi
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    .cfi_restore ra
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    .cfi_def_cfa_offset 0
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_round_si64:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    li a1, 25
; RV64IZHINX-NEXT:    slli a1, a1, 10
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB27_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rmm
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rmm
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB27_2:
; RV64IZHINX-NEXT:    fcvt.l.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_round_si64:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB27_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rmm
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rmm
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB27_2:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    .cfi_offset ra, -4
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; RV32IZFHMIN-NEXT:    call __fixhfdi
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    .cfi_restore ra
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_round_si64:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB27_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rmm
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rmm
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB27_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.l.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_round_si64:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB27_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rmm
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rmm
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB27_2:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    .cfi_def_cfa_offset 16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    .cfi_offset ra, -4
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    call __fixhfdi
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    .cfi_restore ra
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    .cfi_def_cfa_offset 0
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_round_si64:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB27_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rmm
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rmm
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB27_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.l.s a0, a0, rtz
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.round.f16(half %x)
  %b = fptosi half %a to i64
  ret i64 %b
}

define zeroext i8 @test_round_ui8(half %x) {
; RV32IZFH-LABEL: test_round_ui8:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.wu.h a0, fa0, rmm
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_round_ui8:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rmm
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_round_ui8:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    li a1, 25
; RV32IZHINX-NEXT:    slli a1, a1, 10
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB28_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rmm
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rmm
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB28_2:
; RV32IZHINX-NEXT:    fcvt.wu.h a0, a0, rtz
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_round_ui8:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    li a1, 25
; RV64IZHINX-NEXT:    slli a1, a1, 10
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB28_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rmm
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rmm
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB28_2:
; RV64IZHINX-NEXT:    fcvt.lu.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_round_ui8:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB28_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rmm
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rmm
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB28_2:
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_round_ui8:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB28_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rmm
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rmm
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB28_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.lu.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_round_ui8:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB28_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rmm
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rmm
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB28_2:
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_round_ui8:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB28_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rmm
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rmm
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB28_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.lu.s a0, a0, rtz
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.round.f16(half %x)
  %b = fptoui half %a to i8
  ret i8 %b
}

define zeroext i16 @test_round_ui16(half %x) {
; RV32IZFH-LABEL: test_round_ui16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.wu.h a0, fa0, rmm
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_round_ui16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rmm
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_round_ui16:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    li a1, 25
; RV32IZHINX-NEXT:    slli a1, a1, 10
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB29_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rmm
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rmm
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB29_2:
; RV32IZHINX-NEXT:    fcvt.wu.h a0, a0, rtz
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_round_ui16:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    li a1, 25
; RV64IZHINX-NEXT:    slli a1, a1, 10
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB29_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rmm
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rmm
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB29_2:
; RV64IZHINX-NEXT:    fcvt.lu.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_round_ui16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB29_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rmm
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rmm
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB29_2:
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_round_ui16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB29_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rmm
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rmm
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB29_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.lu.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_round_ui16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB29_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rmm
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rmm
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB29_2:
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_round_ui16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB29_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rmm
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rmm
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB29_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.lu.s a0, a0, rtz
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.round.f16(half %x)
  %b = fptoui half %a to i16
  ret i16 %b
}

define signext i32 @test_round_ui32(half %x) {
; CHECKIZFH-LABEL: test_round_ui32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.wu.h a0, fa0, rmm
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: test_round_ui32:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    li a1, 25
; CHECKIZHINX-NEXT:    slli a1, a1, 10
; CHECKIZHINX-NEXT:    fabs.h a2, a0
; CHECKIZHINX-NEXT:    flt.h a1, a2, a1
; CHECKIZHINX-NEXT:    beqz a1, .LBB30_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rmm
; CHECKIZHINX-NEXT:    fcvt.h.w a1, a1, rmm
; CHECKIZHINX-NEXT:    fsgnj.h a0, a1, a0
; CHECKIZHINX-NEXT:  .LBB30_2:
; CHECKIZHINX-NEXT:    fcvt.wu.h a0, a0, rtz
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: test_round_ui32:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    lui a0, 307200
; CHECKIZFHMIN-NEXT:    fmv.w.x fa4, a0
; CHECKIZFHMIN-NEXT:    fabs.s fa3, fa5
; CHECKIZFHMIN-NEXT:    flt.s a0, fa3, fa4
; CHECKIZFHMIN-NEXT:    beqz a0, .LBB30_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rmm
; CHECKIZFHMIN-NEXT:    fcvt.s.w fa4, a0, rmm
; CHECKIZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:  .LBB30_2:
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.wu.s a0, fa5, rtz
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: test_round_ui32:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    lui a1, 307200
; CHECKIZHINXMIN-NEXT:    fabs.s a2, a0
; CHECKIZHINXMIN-NEXT:    flt.s a1, a2, a1
; CHECKIZHINXMIN-NEXT:    beqz a1, .LBB30_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rmm
; CHECKIZHINXMIN-NEXT:    fcvt.s.w a1, a1, rmm
; CHECKIZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:  .LBB30_2:
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.wu.s a0, a0, rtz
; CHECKIZHINXMIN-NEXT:    ret
  %a = call half @llvm.round.f16(half %x)
  %b = fptoui half %a to i32
  ret i32 %b
}

define i64 @test_round_ui64(half %x) {
; RV32IZFH-LABEL: test_round_ui64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    lui a0, %hi(.LCPI31_0)
; RV32IZFH-NEXT:    flh fa5, %lo(.LCPI31_0)(a0)
; RV32IZFH-NEXT:    fabs.h fa4, fa0
; RV32IZFH-NEXT:    flt.h a0, fa4, fa5
; RV32IZFH-NEXT:    beqz a0, .LBB31_2
; RV32IZFH-NEXT:  # %bb.1:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rmm
; RV32IZFH-NEXT:    fcvt.h.w fa5, a0, rmm
; RV32IZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; RV32IZFH-NEXT:  .LBB31_2:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    .cfi_offset ra, -4
; RV32IZFH-NEXT:    call __fixunshfdi
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    .cfi_restore ra
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_round_ui64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rmm
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_round_ui64:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    li a1, 25
; RV32IZHINX-NEXT:    slli a1, a1, 10
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB31_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rmm
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rmm
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB31_2:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    .cfi_def_cfa_offset 16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    .cfi_offset ra, -4
; RV32IZHINX-NEXT:    call __fixunshfdi
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    .cfi_restore ra
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    .cfi_def_cfa_offset 0
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_round_ui64:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    li a1, 25
; RV64IZHINX-NEXT:    slli a1, a1, 10
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB31_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rmm
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rmm
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB31_2:
; RV64IZHINX-NEXT:    fcvt.lu.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_round_ui64:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB31_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rmm
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rmm
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB31_2:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    .cfi_offset ra, -4
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; RV32IZFHMIN-NEXT:    call __fixunshfdi
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    .cfi_restore ra
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_round_ui64:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB31_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rmm
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rmm
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB31_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.lu.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_round_ui64:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB31_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rmm
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rmm
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB31_2:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    .cfi_def_cfa_offset 16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    .cfi_offset ra, -4
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    call __fixunshfdi
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    .cfi_restore ra
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    .cfi_def_cfa_offset 0
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_round_ui64:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB31_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rmm
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rmm
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB31_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.lu.s a0, a0, rtz
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.round.f16(half %x)
  %b = fptoui half %a to i64
  ret i64 %b
}

define signext i8 @test_roundeven_si8(half %x) {
; RV32IZFH-LABEL: test_roundeven_si8:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rne
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_roundeven_si8:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rne
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_roundeven_si8:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    li a1, 25
; RV32IZHINX-NEXT:    slli a1, a1, 10
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB32_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rne
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rne
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB32_2:
; RV32IZHINX-NEXT:    fcvt.w.h a0, a0, rtz
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_roundeven_si8:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    li a1, 25
; RV64IZHINX-NEXT:    slli a1, a1, 10
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB32_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rne
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rne
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB32_2:
; RV64IZHINX-NEXT:    fcvt.l.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_roundeven_si8:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB32_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rne
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rne
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB32_2:
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_roundeven_si8:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB32_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rne
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rne
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB32_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.l.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_roundeven_si8:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB32_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rne
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rne
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB32_2:
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_roundeven_si8:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB32_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rne
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rne
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB32_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.l.s a0, a0, rtz
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.roundeven.f16(half %x)
  %b = fptosi half %a to i8
  ret i8 %b
}

define signext i16 @test_roundeven_si16(half %x) {
; RV32IZFH-LABEL: test_roundeven_si16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rne
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_roundeven_si16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rne
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_roundeven_si16:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    li a1, 25
; RV32IZHINX-NEXT:    slli a1, a1, 10
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB33_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rne
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rne
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB33_2:
; RV32IZHINX-NEXT:    fcvt.w.h a0, a0, rtz
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_roundeven_si16:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    li a1, 25
; RV64IZHINX-NEXT:    slli a1, a1, 10
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB33_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rne
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rne
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB33_2:
; RV64IZHINX-NEXT:    fcvt.l.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_roundeven_si16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB33_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rne
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rne
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB33_2:
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_roundeven_si16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB33_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rne
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rne
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB33_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.l.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_roundeven_si16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB33_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rne
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rne
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB33_2:
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_roundeven_si16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB33_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rne
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rne
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB33_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.l.s a0, a0, rtz
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.roundeven.f16(half %x)
  %b = fptosi half %a to i16
  ret i16 %b
}

define signext i32 @test_roundeven_si32(half %x) {
; CHECKIZFH-LABEL: test_roundeven_si32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.w.h a0, fa0, rne
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: test_roundeven_si32:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    li a1, 25
; CHECKIZHINX-NEXT:    slli a1, a1, 10
; CHECKIZHINX-NEXT:    fabs.h a2, a0
; CHECKIZHINX-NEXT:    flt.h a1, a2, a1
; CHECKIZHINX-NEXT:    beqz a1, .LBB34_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rne
; CHECKIZHINX-NEXT:    fcvt.h.w a1, a1, rne
; CHECKIZHINX-NEXT:    fsgnj.h a0, a1, a0
; CHECKIZHINX-NEXT:  .LBB34_2:
; CHECKIZHINX-NEXT:    fcvt.w.h a0, a0, rtz
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: test_roundeven_si32:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    lui a0, 307200
; CHECKIZFHMIN-NEXT:    fmv.w.x fa4, a0
; CHECKIZFHMIN-NEXT:    fabs.s fa3, fa5
; CHECKIZFHMIN-NEXT:    flt.s a0, fa3, fa4
; CHECKIZFHMIN-NEXT:    beqz a0, .LBB34_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rne
; CHECKIZFHMIN-NEXT:    fcvt.s.w fa4, a0, rne
; CHECKIZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:  .LBB34_2:
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: test_roundeven_si32:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    lui a1, 307200
; CHECKIZHINXMIN-NEXT:    fabs.s a2, a0
; CHECKIZHINXMIN-NEXT:    flt.s a1, a2, a1
; CHECKIZHINXMIN-NEXT:    beqz a1, .LBB34_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rne
; CHECKIZHINXMIN-NEXT:    fcvt.s.w a1, a1, rne
; CHECKIZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:  .LBB34_2:
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; CHECKIZHINXMIN-NEXT:    ret
  %a = call half @llvm.roundeven.f16(half %x)
  %b = fptosi half %a to i32
  ret i32 %b
}

define i64 @test_roundeven_si64(half %x) {
; RV32IZFH-LABEL: test_roundeven_si64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    lui a0, %hi(.LCPI35_0)
; RV32IZFH-NEXT:    flh fa5, %lo(.LCPI35_0)(a0)
; RV32IZFH-NEXT:    fabs.h fa4, fa0
; RV32IZFH-NEXT:    flt.h a0, fa4, fa5
; RV32IZFH-NEXT:    beqz a0, .LBB35_2
; RV32IZFH-NEXT:  # %bb.1:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rne
; RV32IZFH-NEXT:    fcvt.h.w fa5, a0, rne
; RV32IZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; RV32IZFH-NEXT:  .LBB35_2:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    .cfi_offset ra, -4
; RV32IZFH-NEXT:    call __fixhfdi
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    .cfi_restore ra
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_roundeven_si64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rne
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_roundeven_si64:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    li a1, 25
; RV32IZHINX-NEXT:    slli a1, a1, 10
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB35_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rne
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rne
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB35_2:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    .cfi_def_cfa_offset 16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    .cfi_offset ra, -4
; RV32IZHINX-NEXT:    call __fixhfdi
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    .cfi_restore ra
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    .cfi_def_cfa_offset 0
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_roundeven_si64:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    li a1, 25
; RV64IZHINX-NEXT:    slli a1, a1, 10
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB35_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rne
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rne
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB35_2:
; RV64IZHINX-NEXT:    fcvt.l.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_roundeven_si64:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB35_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rne
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rne
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB35_2:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    .cfi_offset ra, -4
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; RV32IZFHMIN-NEXT:    call __fixhfdi
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    .cfi_restore ra
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_roundeven_si64:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB35_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rne
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rne
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB35_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.l.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_roundeven_si64:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB35_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rne
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rne
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB35_2:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    .cfi_def_cfa_offset 16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    .cfi_offset ra, -4
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    call __fixhfdi
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    .cfi_restore ra
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    .cfi_def_cfa_offset 0
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_roundeven_si64:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB35_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rne
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rne
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB35_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.l.s a0, a0, rtz
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.roundeven.f16(half %x)
  %b = fptosi half %a to i64
  ret i64 %b
}

define zeroext i8 @test_roundeven_ui8(half %x) {
; RV32IZFH-LABEL: test_roundeven_ui8:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.wu.h a0, fa0, rne
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_roundeven_ui8:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rne
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_roundeven_ui8:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    li a1, 25
; RV32IZHINX-NEXT:    slli a1, a1, 10
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB36_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rne
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rne
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB36_2:
; RV32IZHINX-NEXT:    fcvt.wu.h a0, a0, rtz
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_roundeven_ui8:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    li a1, 25
; RV64IZHINX-NEXT:    slli a1, a1, 10
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB36_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rne
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rne
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB36_2:
; RV64IZHINX-NEXT:    fcvt.lu.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_roundeven_ui8:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB36_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rne
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rne
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB36_2:
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_roundeven_ui8:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB36_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rne
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rne
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB36_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.lu.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_roundeven_ui8:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB36_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rne
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rne
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB36_2:
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_roundeven_ui8:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB36_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rne
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rne
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB36_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.lu.s a0, a0, rtz
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.roundeven.f16(half %x)
  %b = fptoui half %a to i8
  ret i8 %b
}

define zeroext i16 @test_roundeven_ui16(half %x) {
; RV32IZFH-LABEL: test_roundeven_ui16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.wu.h a0, fa0, rne
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_roundeven_ui16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rne
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_roundeven_ui16:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    li a1, 25
; RV32IZHINX-NEXT:    slli a1, a1, 10
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB37_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rne
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rne
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB37_2:
; RV32IZHINX-NEXT:    fcvt.wu.h a0, a0, rtz
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_roundeven_ui16:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    li a1, 25
; RV64IZHINX-NEXT:    slli a1, a1, 10
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB37_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rne
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rne
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB37_2:
; RV64IZHINX-NEXT:    fcvt.lu.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_roundeven_ui16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB37_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rne
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rne
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB37_2:
; RV32IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_roundeven_ui16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB37_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rne
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rne
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB37_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.lu.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_roundeven_ui16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB37_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rne
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rne
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB37_2:
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_roundeven_ui16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB37_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rne
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rne
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB37_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.lu.s a0, a0, rtz
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.roundeven.f16(half %x)
  %b = fptoui half %a to i16
  ret i16 %b
}

define signext i32 @test_roundeven_ui32(half %x) {
; CHECKIZFH-LABEL: test_roundeven_ui32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.wu.h a0, fa0, rne
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: test_roundeven_ui32:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    li a1, 25
; CHECKIZHINX-NEXT:    slli a1, a1, 10
; CHECKIZHINX-NEXT:    fabs.h a2, a0
; CHECKIZHINX-NEXT:    flt.h a1, a2, a1
; CHECKIZHINX-NEXT:    beqz a1, .LBB38_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rne
; CHECKIZHINX-NEXT:    fcvt.h.w a1, a1, rne
; CHECKIZHINX-NEXT:    fsgnj.h a0, a1, a0
; CHECKIZHINX-NEXT:  .LBB38_2:
; CHECKIZHINX-NEXT:    fcvt.wu.h a0, a0, rtz
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: test_roundeven_ui32:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    lui a0, 307200
; CHECKIZFHMIN-NEXT:    fmv.w.x fa4, a0
; CHECKIZFHMIN-NEXT:    fabs.s fa3, fa5
; CHECKIZFHMIN-NEXT:    flt.s a0, fa3, fa4
; CHECKIZFHMIN-NEXT:    beqz a0, .LBB38_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rne
; CHECKIZFHMIN-NEXT:    fcvt.s.w fa4, a0, rne
; CHECKIZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:  .LBB38_2:
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; CHECKIZFHMIN-NEXT:    fcvt.wu.s a0, fa5, rtz
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: test_roundeven_ui32:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    lui a1, 307200
; CHECKIZHINXMIN-NEXT:    fabs.s a2, a0
; CHECKIZHINXMIN-NEXT:    flt.s a1, a2, a1
; CHECKIZHINXMIN-NEXT:    beqz a1, .LBB38_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rne
; CHECKIZHINXMIN-NEXT:    fcvt.s.w a1, a1, rne
; CHECKIZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:  .LBB38_2:
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.wu.s a0, a0, rtz
; CHECKIZHINXMIN-NEXT:    ret
  %a = call half @llvm.roundeven.f16(half %x)
  %b = fptoui half %a to i32
  ret i32 %b
}

define i64 @test_roundeven_ui64(half %x) {
; RV32IZFH-LABEL: test_roundeven_ui64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    lui a0, %hi(.LCPI39_0)
; RV32IZFH-NEXT:    flh fa5, %lo(.LCPI39_0)(a0)
; RV32IZFH-NEXT:    fabs.h fa4, fa0
; RV32IZFH-NEXT:    flt.h a0, fa4, fa5
; RV32IZFH-NEXT:    beqz a0, .LBB39_2
; RV32IZFH-NEXT:  # %bb.1:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rne
; RV32IZFH-NEXT:    fcvt.h.w fa5, a0, rne
; RV32IZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; RV32IZFH-NEXT:  .LBB39_2:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    .cfi_offset ra, -4
; RV32IZFH-NEXT:    call __fixunshfdi
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    .cfi_restore ra
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_roundeven_ui64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rne
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: test_roundeven_ui64:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    li a1, 25
; RV32IZHINX-NEXT:    slli a1, a1, 10
; RV32IZHINX-NEXT:    fabs.h a2, a0
; RV32IZHINX-NEXT:    flt.h a1, a2, a1
; RV32IZHINX-NEXT:    beqz a1, .LBB39_2
; RV32IZHINX-NEXT:  # %bb.1:
; RV32IZHINX-NEXT:    fcvt.w.h a1, a0, rne
; RV32IZHINX-NEXT:    fcvt.h.w a1, a1, rne
; RV32IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV32IZHINX-NEXT:  .LBB39_2:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    .cfi_def_cfa_offset 16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    .cfi_offset ra, -4
; RV32IZHINX-NEXT:    call __fixunshfdi
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    .cfi_restore ra
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    .cfi_def_cfa_offset 0
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: test_roundeven_ui64:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    li a1, 25
; RV64IZHINX-NEXT:    slli a1, a1, 10
; RV64IZHINX-NEXT:    fabs.h a2, a0
; RV64IZHINX-NEXT:    flt.h a1, a2, a1
; RV64IZHINX-NEXT:    beqz a1, .LBB39_2
; RV64IZHINX-NEXT:  # %bb.1:
; RV64IZHINX-NEXT:    fcvt.w.h a1, a0, rne
; RV64IZHINX-NEXT:    fcvt.h.w a1, a1, rne
; RV64IZHINX-NEXT:    fsgnj.h a0, a1, a0
; RV64IZHINX-NEXT:  .LBB39_2:
; RV64IZHINX-NEXT:    fcvt.lu.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IZFHMIN-LABEL: test_roundeven_ui64:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    lui a0, 307200
; RV32IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV32IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV32IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV32IZFHMIN-NEXT:    beqz a0, .LBB39_2
; RV32IZFHMIN-NEXT:  # %bb.1:
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rne
; RV32IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rne
; RV32IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV32IZFHMIN-NEXT:  .LBB39_2:
; RV32IZFHMIN-NEXT:    addi sp, sp, -16
; RV32IZFHMIN-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFHMIN-NEXT:    .cfi_offset ra, -4
; RV32IZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; RV32IZFHMIN-NEXT:    call __fixunshfdi
; RV32IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFHMIN-NEXT:    .cfi_restore ra
; RV32IZFHMIN-NEXT:    addi sp, sp, 16
; RV32IZFHMIN-NEXT:    .cfi_def_cfa_offset 0
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: test_roundeven_ui64:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    lui a0, 307200
; RV64IZFHMIN-NEXT:    fmv.w.x fa4, a0
; RV64IZFHMIN-NEXT:    fabs.s fa3, fa5
; RV64IZFHMIN-NEXT:    flt.s a0, fa3, fa4
; RV64IZFHMIN-NEXT:    beqz a0, .LBB39_2
; RV64IZFHMIN-NEXT:  # %bb.1:
; RV64IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rne
; RV64IZFHMIN-NEXT:    fcvt.s.w fa4, a0, rne
; RV64IZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; RV64IZFHMIN-NEXT:  .LBB39_2:
; RV64IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa5
; RV64IZFHMIN-NEXT:    fcvt.lu.s a0, fa5, rtz
; RV64IZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: test_roundeven_ui64:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    lui a1, 307200
; RV32IZHINXMIN-NEXT:    fabs.s a2, a0
; RV32IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV32IZHINXMIN-NEXT:    beqz a1, .LBB39_2
; RV32IZHINXMIN-NEXT:  # %bb.1:
; RV32IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rne
; RV32IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rne
; RV32IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV32IZHINXMIN-NEXT:  .LBB39_2:
; RV32IZHINXMIN-NEXT:    addi sp, sp, -16
; RV32IZHINXMIN-NEXT:    .cfi_def_cfa_offset 16
; RV32IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINXMIN-NEXT:    .cfi_offset ra, -4
; RV32IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV32IZHINXMIN-NEXT:    call __fixunshfdi
; RV32IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINXMIN-NEXT:    .cfi_restore ra
; RV32IZHINXMIN-NEXT:    addi sp, sp, 16
; RV32IZHINXMIN-NEXT:    .cfi_def_cfa_offset 0
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: test_roundeven_ui64:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    lui a1, 307200
; RV64IZHINXMIN-NEXT:    fabs.s a2, a0
; RV64IZHINXMIN-NEXT:    flt.s a1, a2, a1
; RV64IZHINXMIN-NEXT:    beqz a1, .LBB39_2
; RV64IZHINXMIN-NEXT:  # %bb.1:
; RV64IZHINXMIN-NEXT:    fcvt.w.s a1, a0, rne
; RV64IZHINXMIN-NEXT:    fcvt.s.w a1, a1, rne
; RV64IZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; RV64IZHINXMIN-NEXT:  .LBB39_2:
; RV64IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.lu.s a0, a0, rtz
; RV64IZHINXMIN-NEXT:    ret
  %a = call half @llvm.roundeven.f16(half %x)
  %b = fptoui half %a to i64
  ret i64 %b
}

define half @test_floor_half(half %x) {
; RV32IFD-LABEL: test_floor_half:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    .cfi_def_cfa_offset 16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    .cfi_offset ra, -4
; RV32IFD-NEXT:    call floor@plt
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_floor_half:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    .cfi_def_cfa_offset 16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    .cfi_offset ra, -8
; RV64IFD-NEXT:    call floor@plt
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
; CHECKIZFH-LABEL: test_floor_half:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    lui a0, %hi(.LCPI40_0)
; CHECKIZFH-NEXT:    flh fa5, %lo(.LCPI40_0)(a0)
; CHECKIZFH-NEXT:    fabs.h fa4, fa0
; CHECKIZFH-NEXT:    flt.h a0, fa4, fa5
; CHECKIZFH-NEXT:    beqz a0, .LBB40_2
; CHECKIZFH-NEXT:  # %bb.1:
; CHECKIZFH-NEXT:    fcvt.w.h a0, fa0, rdn
; CHECKIZFH-NEXT:    fcvt.h.w fa5, a0, rdn
; CHECKIZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; CHECKIZFH-NEXT:  .LBB40_2:
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: test_floor_half:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    li a1, 25
; CHECKIZHINX-NEXT:    slli a1, a1, 10
; CHECKIZHINX-NEXT:    fabs.h a2, a0
; CHECKIZHINX-NEXT:    flt.h a1, a2, a1
; CHECKIZHINX-NEXT:    beqz a1, .LBB40_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rdn
; CHECKIZHINX-NEXT:    fcvt.h.w a1, a1, rdn
; CHECKIZHINX-NEXT:    fsgnj.h a0, a1, a0
; CHECKIZHINX-NEXT:  .LBB40_2:
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: test_floor_half:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    lui a0, 307200
; CHECKIZFHMIN-NEXT:    fmv.w.x fa4, a0
; CHECKIZFHMIN-NEXT:    fabs.s fa3, fa5
; CHECKIZFHMIN-NEXT:    flt.s a0, fa3, fa4
; CHECKIZFHMIN-NEXT:    beqz a0, .LBB40_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rdn
; CHECKIZFHMIN-NEXT:    fcvt.s.w fa4, a0, rdn
; CHECKIZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:  .LBB40_2:
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: test_floor_half:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    lui a1, 307200
; CHECKIZHINXMIN-NEXT:    fabs.s a2, a0
; CHECKIZHINXMIN-NEXT:    flt.s a1, a2, a1
; CHECKIZHINXMIN-NEXT:    beqz a1, .LBB40_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rdn
; CHECKIZHINXMIN-NEXT:    fcvt.s.w a1, a1, rdn
; CHECKIZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:  .LBB40_2:
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
  %a = call half @llvm.floor.f16(half %x)
  ret half %a
}

define half @test_ceil_half(half %x) {
; RV32IFD-LABEL: test_ceil_half:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    .cfi_def_cfa_offset 16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    .cfi_offset ra, -4
; RV32IFD-NEXT:    call ceil@plt
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_ceil_half:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    .cfi_def_cfa_offset 16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    .cfi_offset ra, -8
; RV64IFD-NEXT:    call ceil@plt
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
; CHECKIZFH-LABEL: test_ceil_half:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    lui a0, %hi(.LCPI41_0)
; CHECKIZFH-NEXT:    flh fa5, %lo(.LCPI41_0)(a0)
; CHECKIZFH-NEXT:    fabs.h fa4, fa0
; CHECKIZFH-NEXT:    flt.h a0, fa4, fa5
; CHECKIZFH-NEXT:    beqz a0, .LBB41_2
; CHECKIZFH-NEXT:  # %bb.1:
; CHECKIZFH-NEXT:    fcvt.w.h a0, fa0, rup
; CHECKIZFH-NEXT:    fcvt.h.w fa5, a0, rup
; CHECKIZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; CHECKIZFH-NEXT:  .LBB41_2:
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: test_ceil_half:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    li a1, 25
; CHECKIZHINX-NEXT:    slli a1, a1, 10
; CHECKIZHINX-NEXT:    fabs.h a2, a0
; CHECKIZHINX-NEXT:    flt.h a1, a2, a1
; CHECKIZHINX-NEXT:    beqz a1, .LBB41_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rup
; CHECKIZHINX-NEXT:    fcvt.h.w a1, a1, rup
; CHECKIZHINX-NEXT:    fsgnj.h a0, a1, a0
; CHECKIZHINX-NEXT:  .LBB41_2:
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: test_ceil_half:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    lui a0, 307200
; CHECKIZFHMIN-NEXT:    fmv.w.x fa4, a0
; CHECKIZFHMIN-NEXT:    fabs.s fa3, fa5
; CHECKIZFHMIN-NEXT:    flt.s a0, fa3, fa4
; CHECKIZFHMIN-NEXT:    beqz a0, .LBB41_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rup
; CHECKIZFHMIN-NEXT:    fcvt.s.w fa4, a0, rup
; CHECKIZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:  .LBB41_2:
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: test_ceil_half:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    lui a1, 307200
; CHECKIZHINXMIN-NEXT:    fabs.s a2, a0
; CHECKIZHINXMIN-NEXT:    flt.s a1, a2, a1
; CHECKIZHINXMIN-NEXT:    beqz a1, .LBB41_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rup
; CHECKIZHINXMIN-NEXT:    fcvt.s.w a1, a1, rup
; CHECKIZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:  .LBB41_2:
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
  %a = call half @llvm.ceil.f16(half %x)
  ret half %a
}

define half @test_trunc_half(half %x) {
; RV32IFD-LABEL: test_trunc_half:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    .cfi_def_cfa_offset 16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    .cfi_offset ra, -4
; RV32IFD-NEXT:    call trunc@plt
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_trunc_half:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    .cfi_def_cfa_offset 16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    .cfi_offset ra, -8
; RV64IFD-NEXT:    call trunc@plt
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
; CHECKIZFH-LABEL: test_trunc_half:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    lui a0, %hi(.LCPI42_0)
; CHECKIZFH-NEXT:    flh fa5, %lo(.LCPI42_0)(a0)
; CHECKIZFH-NEXT:    fabs.h fa4, fa0
; CHECKIZFH-NEXT:    flt.h a0, fa4, fa5
; CHECKIZFH-NEXT:    beqz a0, .LBB42_2
; CHECKIZFH-NEXT:  # %bb.1:
; CHECKIZFH-NEXT:    fcvt.w.h a0, fa0, rtz
; CHECKIZFH-NEXT:    fcvt.h.w fa5, a0, rtz
; CHECKIZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; CHECKIZFH-NEXT:  .LBB42_2:
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: test_trunc_half:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    li a1, 25
; CHECKIZHINX-NEXT:    slli a1, a1, 10
; CHECKIZHINX-NEXT:    fabs.h a2, a0
; CHECKIZHINX-NEXT:    flt.h a1, a2, a1
; CHECKIZHINX-NEXT:    beqz a1, .LBB42_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rtz
; CHECKIZHINX-NEXT:    fcvt.h.w a1, a1, rtz
; CHECKIZHINX-NEXT:    fsgnj.h a0, a1, a0
; CHECKIZHINX-NEXT:  .LBB42_2:
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: test_trunc_half:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    lui a0, 307200
; CHECKIZFHMIN-NEXT:    fmv.w.x fa4, a0
; CHECKIZFHMIN-NEXT:    fabs.s fa3, fa5
; CHECKIZFHMIN-NEXT:    flt.s a0, fa3, fa4
; CHECKIZFHMIN-NEXT:    beqz a0, .LBB42_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; CHECKIZFHMIN-NEXT:    fcvt.s.w fa4, a0, rtz
; CHECKIZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:  .LBB42_2:
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: test_trunc_half:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    lui a1, 307200
; CHECKIZHINXMIN-NEXT:    fabs.s a2, a0
; CHECKIZHINXMIN-NEXT:    flt.s a1, a2, a1
; CHECKIZHINXMIN-NEXT:    beqz a1, .LBB42_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rtz
; CHECKIZHINXMIN-NEXT:    fcvt.s.w a1, a1, rtz
; CHECKIZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:  .LBB42_2:
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
  %a = call half @llvm.trunc.f16(half %x)
  ret half %a
}

define half @test_round_half(half %x) {
; RV32IFD-LABEL: test_round_half:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    .cfi_def_cfa_offset 16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    .cfi_offset ra, -4
; RV32IFD-NEXT:    call round@plt
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_round_half:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    .cfi_def_cfa_offset 16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    .cfi_offset ra, -8
; RV64IFD-NEXT:    call round@plt
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
; CHECKIZFH-LABEL: test_round_half:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    lui a0, %hi(.LCPI43_0)
; CHECKIZFH-NEXT:    flh fa5, %lo(.LCPI43_0)(a0)
; CHECKIZFH-NEXT:    fabs.h fa4, fa0
; CHECKIZFH-NEXT:    flt.h a0, fa4, fa5
; CHECKIZFH-NEXT:    beqz a0, .LBB43_2
; CHECKIZFH-NEXT:  # %bb.1:
; CHECKIZFH-NEXT:    fcvt.w.h a0, fa0, rmm
; CHECKIZFH-NEXT:    fcvt.h.w fa5, a0, rmm
; CHECKIZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; CHECKIZFH-NEXT:  .LBB43_2:
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: test_round_half:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    li a1, 25
; CHECKIZHINX-NEXT:    slli a1, a1, 10
; CHECKIZHINX-NEXT:    fabs.h a2, a0
; CHECKIZHINX-NEXT:    flt.h a1, a2, a1
; CHECKIZHINX-NEXT:    beqz a1, .LBB43_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rmm
; CHECKIZHINX-NEXT:    fcvt.h.w a1, a1, rmm
; CHECKIZHINX-NEXT:    fsgnj.h a0, a1, a0
; CHECKIZHINX-NEXT:  .LBB43_2:
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: test_round_half:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    lui a0, 307200
; CHECKIZFHMIN-NEXT:    fmv.w.x fa4, a0
; CHECKIZFHMIN-NEXT:    fabs.s fa3, fa5
; CHECKIZFHMIN-NEXT:    flt.s a0, fa3, fa4
; CHECKIZFHMIN-NEXT:    beqz a0, .LBB43_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rmm
; CHECKIZFHMIN-NEXT:    fcvt.s.w fa4, a0, rmm
; CHECKIZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:  .LBB43_2:
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: test_round_half:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    lui a1, 307200
; CHECKIZHINXMIN-NEXT:    fabs.s a2, a0
; CHECKIZHINXMIN-NEXT:    flt.s a1, a2, a1
; CHECKIZHINXMIN-NEXT:    beqz a1, .LBB43_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rmm
; CHECKIZHINXMIN-NEXT:    fcvt.s.w a1, a1, rmm
; CHECKIZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:  .LBB43_2:
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
  %a = call half @llvm.round.f16(half %x)
  ret half %a
}

define half @test_roundeven_half(half %x) {
; RV32IFD-LABEL: test_roundeven_half:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    .cfi_def_cfa_offset 16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    .cfi_offset ra, -4
; RV32IFD-NEXT:    call roundeven@plt
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_roundeven_half:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    .cfi_def_cfa_offset 16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    .cfi_offset ra, -8
; RV64IFD-NEXT:    call roundeven@plt
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
; CHECKIZFH-LABEL: test_roundeven_half:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    lui a0, %hi(.LCPI44_0)
; CHECKIZFH-NEXT:    flh fa5, %lo(.LCPI44_0)(a0)
; CHECKIZFH-NEXT:    fabs.h fa4, fa0
; CHECKIZFH-NEXT:    flt.h a0, fa4, fa5
; CHECKIZFH-NEXT:    beqz a0, .LBB44_2
; CHECKIZFH-NEXT:  # %bb.1:
; CHECKIZFH-NEXT:    fcvt.w.h a0, fa0, rne
; CHECKIZFH-NEXT:    fcvt.h.w fa5, a0, rne
; CHECKIZFH-NEXT:    fsgnj.h fa0, fa5, fa0
; CHECKIZFH-NEXT:  .LBB44_2:
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: test_roundeven_half:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    li a1, 25
; CHECKIZHINX-NEXT:    slli a1, a1, 10
; CHECKIZHINX-NEXT:    fabs.h a2, a0
; CHECKIZHINX-NEXT:    flt.h a1, a2, a1
; CHECKIZHINX-NEXT:    beqz a1, .LBB44_2
; CHECKIZHINX-NEXT:  # %bb.1:
; CHECKIZHINX-NEXT:    fcvt.w.h a1, a0, rne
; CHECKIZHINX-NEXT:    fcvt.h.w a1, a1, rne
; CHECKIZHINX-NEXT:    fsgnj.h a0, a1, a0
; CHECKIZHINX-NEXT:  .LBB44_2:
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: test_roundeven_half:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECKIZFHMIN-NEXT:    lui a0, 307200
; CHECKIZFHMIN-NEXT:    fmv.w.x fa4, a0
; CHECKIZFHMIN-NEXT:    fabs.s fa3, fa5
; CHECKIZFHMIN-NEXT:    flt.s a0, fa3, fa4
; CHECKIZFHMIN-NEXT:    beqz a0, .LBB44_2
; CHECKIZFHMIN-NEXT:  # %bb.1:
; CHECKIZFHMIN-NEXT:    fcvt.w.s a0, fa5, rne
; CHECKIZFHMIN-NEXT:    fcvt.s.w fa4, a0, rne
; CHECKIZFHMIN-NEXT:    fsgnj.s fa5, fa4, fa5
; CHECKIZFHMIN-NEXT:  .LBB44_2:
; CHECKIZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: test_roundeven_half:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    lui a1, 307200
; CHECKIZHINXMIN-NEXT:    fabs.s a2, a0
; CHECKIZHINXMIN-NEXT:    flt.s a1, a2, a1
; CHECKIZHINXMIN-NEXT:    beqz a1, .LBB44_2
; CHECKIZHINXMIN-NEXT:  # %bb.1:
; CHECKIZHINXMIN-NEXT:    fcvt.w.s a1, a0, rne
; CHECKIZHINXMIN-NEXT:    fcvt.s.w a1, a1, rne
; CHECKIZHINXMIN-NEXT:    fsgnj.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:  .LBB44_2:
; CHECKIZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINXMIN-NEXT:    ret
  %a = call half @llvm.roundeven.f16(half %x)
  ret half %a
}

declare half @llvm.floor.f16(half)
declare half @llvm.ceil.f16(half)
declare half @llvm.trunc.f16(half)
declare half @llvm.round.f16(half)
declare half @llvm.roundeven.f16(half)
