/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipException;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.builder.standalone.ClusteringConfig;
import org.eclipse.xtext.builder.standalone.IIssueHandler;
import org.eclipse.xtext.builder.standalone.LanguageAccess;
import org.eclipse.xtext.builder.standalone.compiler.IJavaCompiler;
import org.eclipse.xtext.common.types.access.impl.ClasspathTypeProvider;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;
import org.eclipse.xtext.generator.AbstractFileSystemAccess;
import org.eclipse.xtext.generator.GeneratorContext;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IFileSystemAccessExtension3;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.mwe.NameBasedFilter;
import org.eclipse.xtext.mwe.PathTraverser;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.clustering.DisabledClusteringPolicy;
import org.eclipse.xtext.resource.clustering.DynamicResourceClusteringPolicy;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.resource.persistence.IResourceStorageFacade;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.UriUtil;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class StandaloneBuilder {
    private static final Logger LOG = Logger.getLogger(StandaloneBuilder.class);
    private Map<String, LanguageAccess> languages;
    private String baseDir;
    private Iterable<String> sourceDirs;
    private Iterable<String> javaSourceDirs = new ArrayList<String>();
    private Iterable<String> classPathEntries;
    private File tempDir = null;
    private String encoding;
    private String classPathLookUpFilter;
    private boolean failOnValidationError = true;
    private boolean debugLog;
    private boolean writeStorageResources;
    private ClusteringConfig clusteringConfig = null;
    @Inject
    private IndexedJvmTypeAccess jvmTypeAccess;
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    private AbstractFileSystemAccess commonFileAccess;
    @Inject
    protected IIssueHandler issueHandler;
    @Inject
    private IEncodingProvider.Runtime encodingProvider;
    @Inject
    private IJavaCompiler compiler;
    private Map<LanguageAccess, JavaIoFileSystemAccess> configuredFsas = new HashMap<LanguageAccess, JavaIoFileSystemAccess>();

    public StandaloneBuilder() {
        try {
            this.tempDir = Files.createTempDirectory("StandaloneBuilder", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setTempDir(String pathAsString) {
        if (pathAsString != null) {
            this.tempDir = new File(pathAsString);
        }
    }

    public boolean launch() {
        boolean needsJava = IterableExtensions.exists(this.languages.values(), l -> l.isLinksAgainstJava());
        if (this.baseDir == null) {
            this.baseDir = System.getProperty("user.dir");
            LOG.warn((Object)("Property baseDir not set. Using '" + this.baseDir + "'"));
        }
        if (needsJava) {
            LOG.info((Object)"Using common types.");
        }
        XtextResourceSet resourceSet = (XtextResourceSet)this.resourceSetProvider.get();
        if (this.encoding != null) {
            this.forceDebugLog("Setting encoding.");
            this.fileEncodingSetup(this.languages.values(), this.encoding);
        }
        LOG.info((Object)"Collecting source models.");
        long startedAt = System.currentTimeMillis();
        Iterable rootsToTravers = this.classPathEntries;
        if (this.classPathLookUpFilter != null) {
            LOG.info((Object)"Class path look up filter is active.");
            Pattern cpLookUpFilter = Pattern.compile(this.classPathLookUpFilter);
            rootsToTravers = Iterables.filter(this.classPathEntries, root -> cpLookUpFilter.matcher((CharSequence)root).matches());
            LOG.info((Object)("Investigating " + Iterables.size((Iterable)rootsToTravers) + " of " + Iterables.size(this.classPathEntries) + " class path entries."));
        }
        List<URI> sourceResourceURIs = this.collectResources(this.sourceDirs, (ResourceSet)resourceSet);
        Iterable allResourcesURIs = Iterables.concat(sourceResourceURIs, this.collectResources(rootsToTravers, (ResourceSet)resourceSet));
        this.forceDebugLog("Finished collecting source models. Took: " + (System.currentTimeMillis() - startedAt) + " ms.");
        Iterable allClassPathEntries = Iterables.concat(this.sourceDirs, this.classPathEntries);
        if (needsJava) {
            LOG.info((Object)"Installing type provider.");
            this.installTypeProvider(allClassPathEntries, resourceSet, null);
        }
        DisabledClusteringPolicy strategy = null;
        if (this.clusteringConfig != null) {
            LOG.info((Object)"Clustering configured.");
            DynamicResourceClusteringPolicy dynamicResourceClusteringPolicy = new DynamicResourceClusteringPolicy();
            dynamicResourceClusteringPolicy.setMinimumFreeMemory(this.clusteringConfig.getMinimumFreeMemory() * 1024L * 1024L);
            dynamicResourceClusteringPolicy.setMinimumClusterSize(this.clusteringConfig.getMinimumClusterSize());
            dynamicResourceClusteringPolicy.setMinimumPercentFreeMemory(this.clusteringConfig.getMinimumPercentFreeMemory());
            strategy = dynamicResourceClusteringPolicy;
        } else {
            strategy = new DisabledClusteringPolicy();
        }
        ResourceDescriptionsData index = new ResourceDescriptionsData(new ArrayList());
        Iterator allResourceIterator = allResourcesURIs.iterator();
        while (allResourceIterator.hasNext()) {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            int clusterIndex = 0;
            boolean canContinue = true;
            while (allResourceIterator.hasNext() && canContinue) {
                URI uri = (URI)allResourceIterator.next();
                Resource resource = resourceSet.getResource(uri, true);
                resources.add(resource);
                this.fillIndex(uri, resource, index);
                if (strategy.continueProcessing((ResourceSet)resourceSet, null, ++clusterIndex)) continue;
                canContinue = false;
            }
            if (canContinue) continue;
            this.clearResourceSet((ResourceSet)resourceSet);
        }
        this.installIndex(resourceSet, index);
        if (needsJava) {
            String stubsClasses = this.compileStubs(this.generateStubs(index, sourceResourceURIs));
            LOG.info((Object)"Installing type provider for stubs.");
            this.installTypeProvider(Iterables.concat((Iterable)allClassPathEntries, (Iterable)Lists.newArrayList((Object[])new String[]{stubsClasses})), resourceSet, this.jvmTypeAccess);
        }
        LOG.info((Object)"Validate and generate.");
        Iterator<URI> sourceResourceIterator = sourceResourceURIs.iterator();
        boolean hasValidationErrors = false;
        while (sourceResourceIterator.hasNext()) {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            int clusterIndex = 0;
            boolean canContinue = true;
            while (sourceResourceIterator.hasNext() && canContinue) {
                URI uri = sourceResourceIterator.next();
                Resource resource = resourceSet.getResource(uri, true);
                resources.add(resource);
                resource.getContents();
                EcoreUtil2.resolveLazyCrossReferences((Resource)resource, (CancelIndicator)CancelIndicator.NullImpl);
                boolean bl = hasValidationErrors = !this.validate(resource) || hasValidationErrors;
                if (strategy.continueProcessing((ResourceSet)resourceSet, null, ++clusterIndex)) continue;
                canContinue = false;
            }
            if (this.failOnValidationError && hasValidationErrors) {
                return !hasValidationErrors;
            }
            this.generate(resources);
            if (canContinue) continue;
            this.clearResourceSet((ResourceSet)resourceSet);
        }
        return !hasValidationErrors;
    }

    public void fillIndex(URI uri, Resource resource, ResourceDescriptionsData index) {
        IResourceDescription description = this.languageAccess(uri).getResourceDescriptionManager().getResourceDescription(resource);
        index.addDescription(uri, description);
    }

    public void fileEncodingSetup(Collection<LanguageAccess> langs, String encoding) {
        for (LanguageAccess lang : langs) {
            IEncodingProvider provider = lang.getEncodingProvider();
            if (provider instanceof IEncodingProvider.Runtime) {
                ((IEncodingProvider.Runtime)provider).setDefaultEncoding(encoding);
                continue;
            }
            this.forceDebugLog("Couldn't set encoding '" + encoding + "' for provider '" + provider + "'. Only subclasses of IEncodingProvider.Runtime are supported.");
        }
    }

    protected void installIndex(XtextResourceSet resourceSet, ResourceDescriptionsData index) {
        ResourceDescriptionsData.ResourceSetAdapter.installResourceDescriptionsData((ResourceSet)resourceSet, (ResourceDescriptionsData)index);
    }

    protected String compileStubs(File stubsDir) {
        File stubsClasses = this.createTempDir("classes");
        this.compiler.setClassPath(this.classPathEntries);
        LOG.info((Object)("Compiling stubs located in " + stubsDir.getAbsolutePath()));
        Set<String> sourcesToCompile = this.uniqueEntries(Iterables.concat(this.javaSourceDirs, this.sourceDirs, (Iterable)Lists.newArrayList((Object[])new String[]{stubsDir.getAbsolutePath()})));
        this.forceDebugLog("Compiler source roots: " + Joiner.on((String)",").join(sourcesToCompile));
        IJavaCompiler.CompilationResult result = this.compiler.compile(sourcesToCompile, stubsClasses);
        if (result != null) {
            switch (result) {
                case SKIPPED: {
                    LOG.info((Object)"Nothing to compile. Stubs compilation was skipped.");
                    break;
                }
                case FAILED: {
                    this.forceDebugLog("Stubs compilation finished with errors.");
                    break;
                }
                case SUCCEEDED: {
                    this.forceDebugLog("Stubs compilation successfully finished.");
                    break;
                }
            }
        }
        return stubsClasses.getAbsolutePath();
    }

    protected Set<String> uniqueEntries(Iterable<String> pathes) {
        return IterableExtensions.toSet((Iterable)Iterables.transform(pathes, it -> new File((String)it).getAbsolutePath()));
    }

    protected File generateStubs(ResourceDescriptionsData data, List<URI> sourceResourceURIs) {
        File stubsDir = this.createTempDir("stubs");
        LOG.info((Object)("Generating stubs into " + stubsDir.getAbsolutePath()));
        if (this.encoding != null) {
            this.encodingProvider.setDefaultEncoding(this.encoding);
        }
        this.commonFileAccess.setOutputPath("DEFAULT_OUTPUT", stubsDir.getAbsolutePath());
        Iterable generateStubs = Iterables.filter(sourceResourceURIs, it -> this.languageAccess((URI)it).isLinksAgainstJava());
        for (URI it2 : generateStubs) {
            this.languageAccess(it2).getStubGenerator().doGenerateStubs((IFileSystemAccess)this.commonFileAccess, data.getResourceDescription(it2));
        }
        return stubsDir;
    }

    protected boolean validate(Resource resource) {
        LOG.info((Object)("Starting validation for input: '" + resource.getURI().lastSegment() + "'"));
        IResourceValidator resourceValidator = this.languageAccess(resource.getURI()).getResourceValidator();
        List validationResult = resourceValidator.validate(resource, CheckMode.ALL, null);
        return this.issueHandler.handleIssue(validationResult);
    }

    protected void generate(List<Resource> sourceResources) {
        GeneratorContext context = new GeneratorContext();
        context.setCancelIndicator(CancelIndicator.NullImpl);
        for (Resource it : sourceResources) {
            IResourceStorageFacade resourceStorageFacade;
            LOG.info((Object)("Starting generator for input: '" + it.getURI().lastSegment() + "'"));
            this.registerCurrentSource(it.getURI());
            LanguageAccess access = this.languageAccess(it.getURI());
            JavaIoFileSystemAccess fileSystemAccess = this.getFileSystemAccess(access);
            if (this.isWriteStorageResources() && it instanceof StorageAwareResource && (resourceStorageFacade = ((StorageAwareResource)it).getResourceStorageFacade()) != null) {
                resourceStorageFacade.saveResource((StorageAwareResource)it, (IFileSystemAccessExtension3)fileSystemAccess);
            }
            access.getGenerator().generate(it, (IFileSystemAccess2)fileSystemAccess, (IGeneratorContext)context);
        }
    }

    protected void registerCurrentSource(URI uri) {
        JavaIoFileSystemAccess fsa = this.getFileSystemAccess(this.languageAccess(uri));
        Iterable folders = Iterables.transform(this.sourceDirs, it -> UriUtil.createFolderURI((File)new File((String)it)));
        URI absoluteSource = (URI)IterableExtensions.findFirst((Iterable)folders, it -> UriUtil.isPrefixOf((URI)it, (URI)uri));
        if (absoluteSource == null) {
            throw new IllegalStateException("Resource " + uri + " is not contained in any of the known source folders " + this.sourceDirs + ".");
        }
        URI projectBaseURI = UriUtil.createFolderURI((File)new File(this.baseDir));
        for (OutputConfiguration output : fsa.getOutputConfigurations().values()) {
            for (String sourceFolder : output.getSourceFolders()) {
                URI sourceFolderURI = URI.createURI((String)(sourceFolder + "/"));
                if (sourceFolderURI.isRelative()) {
                    sourceFolderURI = sourceFolderURI.resolve(projectBaseURI);
                }
                if (!Objects.equal((Object)absoluteSource, (Object)sourceFolderURI)) continue;
                fsa.setCurrentSource(sourceFolder);
            }
        }
    }

    private JavaIoFileSystemAccess getFileSystemAccess(LanguageAccess language) {
        JavaIoFileSystemAccess fsa = this.configuredFsas.get(language);
        if (fsa == null) {
            fsa = language.createFileSystemAccess(new File(this.baseDir));
            fsa = this.configureFileSystemAccess(fsa, language);
            this.configuredFsas.put(language, fsa);
        }
        return fsa;
    }

    protected JavaIoFileSystemAccess configureFileSystemAccess(JavaIoFileSystemAccess fsa, LanguageAccess language) {
        return fsa;
    }

    private LanguageAccess languageAccess(URI uri) {
        return this.languages.get(uri.fileExtension());
    }

    protected File createTempDir(String subDir) {
        try {
            File file = new File(this.tempDir, subDir);
            if (!file.mkdirs() && !file.exists()) {
                throw new IOException("Failed to create directory '" + file.getAbsolutePath() + "'");
            }
            return file;
        }
        catch (Throwable e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }

    protected void installTypeProvider(Iterable<String> classPathRoots, XtextResourceSet resSet, IndexedJvmTypeAccess typeAccess) {
        URLClassLoader classLoader = this.createURLClassLoader(classPathRoots);
        new ClasspathTypeProvider((ClassLoader)classLoader, (ResourceSet)resSet, typeAccess, null);
        resSet.setClasspathURIContext((Object)classLoader);
    }

    private URLClassLoader createURLClassLoader(Iterable<String> classPathEntries) {
        URL[] classPathUrls = (URL[])FluentIterable.from(classPathEntries).transform(str -> {
            try {
                return new File((String)str).toURI().toURL();
            }
            catch (Throwable e) {
                throw Exceptions.sneakyThrow((Throwable)e);
            }
        }).toArray(URL.class);
        return new URLClassLoader(classPathUrls);
    }

    protected List<URI> collectResources(Iterable<String> roots, ResourceSet resourceSet) {
        String extensions = Joiner.on((String)"|").join(this.languages.keySet());
        NameBasedFilter nameBasedFilter = new NameBasedFilter();
        nameBasedFilter.setRegularExpression(".*\\.(?:(" + extensions + "))$");
        ArrayList<URI> resources = new ArrayList<URI>();
        Multimap modelsFound = new PathTraverser().resolvePathes(IterableExtensions.toList(roots), input -> {
            boolean matches = nameBasedFilter.matches(input);
            if (matches) {
                this.forceDebugLog("Adding file '" + input + "'");
                resources.add((URI)input);
            }
            return matches;
        });
        modelsFound.asMap().forEach((uri, resource) -> {
            File file = new File((String)uri);
            if (resource != null && !file.isDirectory() && file.getName().endsWith(".jar")) {
                this.registerBundle(file);
            }
        });
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerBundle(File file) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                return;
            }
            String name = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
            if (name != null) {
                int indexOf = name.indexOf(";");
                if (indexOf > 0) {
                    name = name.substring(0, indexOf);
                }
                if (EcorePlugin.getPlatformResourceMap().containsKey(name)) {
                    return;
                }
                String path = "archive:" + file.toURI() + "!/";
                URI uri = URI.createURI((String)path);
                EcorePlugin.getPlatformResourceMap().put(name, uri);
            }
        }
        catch (ZipException e) {
            this.forceDebugLog("Could not open Jar file " + file.getAbsolutePath() + ".");
        }
        catch (Exception e) {
            LOG.error((Object)file.getAbsolutePath(), (Throwable)e);
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)jarFile, (Throwable)e);
            }
        }
    }

    public IJavaCompiler getCompiler() {
        return this.compiler;
    }

    public void clearResourceSet(ResourceSet resourceSet) {
        boolean wasDeliver = resourceSet.eDeliver();
        try {
            resourceSet.eSetDeliver(false);
            resourceSet.getResources().clear();
        }
        finally {
            resourceSet.eSetDeliver(wasDeliver);
        }
    }

    protected void forceDebugLog(String logMessage) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)logMessage);
        } else if (this.debugLog) {
            LOG.info((Object)logMessage);
        }
    }

    public Map<String, LanguageAccess> getLanguages() {
        return this.languages;
    }

    public void setLanguages(Map<String, LanguageAccess> languages) {
        this.languages = languages;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public Iterable<String> getSourceDirs() {
        return this.sourceDirs;
    }

    public void setSourceDirs(Iterable<String> sourceDirs) {
        this.sourceDirs = sourceDirs;
    }

    public Iterable<String> getJavaSourceDirs() {
        return this.javaSourceDirs;
    }

    public void setJavaSourceDirs(Iterable<String> javaSourceDirs) {
        this.javaSourceDirs = javaSourceDirs;
    }

    public Iterable<String> getClassPathEntries() {
        return this.classPathEntries;
    }

    public void setClassPathEntries(Iterable<String> classPathEntries) {
        this.classPathEntries = classPathEntries;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(File tempDir) {
        this.tempDir = tempDir;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getClassPathLookUpFilter() {
        return this.classPathLookUpFilter;
    }

    public void setClassPathLookUpFilter(String classPathLookUpFilter) {
        this.classPathLookUpFilter = classPathLookUpFilter;
    }

    public boolean isFailOnValidationError() {
        return this.failOnValidationError;
    }

    public void setFailOnValidationError(boolean failOnValidationError) {
        this.failOnValidationError = failOnValidationError;
    }

    public boolean isDebugLog() {
        return this.debugLog;
    }

    public void setDebugLog(boolean debugLog) {
        this.debugLog = debugLog;
    }

    public boolean isWriteStorageResources() {
        return this.writeStorageResources;
    }

    public void setWriteStorageResources(boolean writeStorageResources) {
        this.writeStorageResources = writeStorageResources;
    }

    public ClusteringConfig getClusteringConfig() {
        return this.clusteringConfig;
    }

    public void setClusteringConfig(ClusteringConfig clusteringConfig) {
        this.clusteringConfig = clusteringConfig;
    }
}

