/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.importexport;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.p2.importexport.IUDetail;
import org.eclipse.equinox.internal.p2.importexport.P2ImportExport;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.p2.tests.metadata.repository.ServerBasedTestCase;
import org.junit.Ignore;
import org.osgi.util.tracker.ServiceTracker;

@Ignore
public class ImportExportRemoteTests
extends ServerBasedTestCase {
    private P2ImportExport importexportService;

    private URI getTestRepository() throws URISyntaxException {
        return new URI(String.valueOf(this.getBaseURL()) + "/importexport/");
    }

    public void setUp() throws Exception {
        super.setUp();
        ServiceTracker tracker = new ServiceTracker(TestActivator.getContext(), P2ImportExport.class, null);
        tracker.open();
        this.importexportService = (P2ImportExport)tracker.getService();
        ImportExportRemoteTests.assertNotNull((String)"Fail to get ImportExport service", (Object)this.importexportService);
        tracker.close();
    }

    public void tearDown() throws Exception {
        URI[] urls;
        super.tearDown();
        this.importexportService = null;
        IMetadataRepositoryManager repoMan = (IMetadataRepositoryManager)ImportExportRemoteTests.getAgent().getService(IMetadataRepositoryManager.class);
        URI[] uRIArray = urls = repoMan.getKnownRepositories(0);
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URI url = uRIArray[n2];
            repoMan.removeRepository(url);
            ++n2;
        }
    }

    public void testExportFeaturesFromRemoteRepository() throws URISyntaxException, IOException, ProvisionException, OperationCanceledException {
        File testFile = File.createTempFile("test", "p2f");
        URI uri = this.getTestRepository();
        try {
            IMetadataRepositoryManager metaManager = (IMetadataRepositoryManager)ImportExportRemoteTests.getAgent().getService(IMetadataRepositoryManager.class);
            IMetadataRepository repo = metaManager.loadRepository(uri, null);
            ImportExportRemoteTests.assertNotNull((String)"Fail to load remote repo", (Object)repo);
            IInstallableUnit iu = AbstractProvisioningTest.createIU((String)"A", (Version)Version.create((String)"1.0.0"));
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileOutputStream output = new FileOutputStream(testFile);){
                IStatus status = this.importexportService.exportP2F((OutputStream)output, new IInstallableUnit[]{iu}, false, null);
                ImportExportRemoteTests.assertTrue((String)"Not expected return result.", (boolean)status.isOK());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            throwable = null;
            var7_9 = null;
            try (FileInputStream input = new FileInputStream(testFile);){
                List ius = this.importexportService.importP2F((InputStream)input);
                ImportExportRemoteTests.assertEquals((String)"Exported the number of features is not expected.", (int)1, (int)ius.size());
                ImportExportRemoteTests.assertEquals((String)"Exported feature is not expected.", (Object)iu, (Object)((IUDetail)ius.get(0)).getIU());
                ImportExportRemoteTests.assertEquals((String)"Exported the number of referred repositories is not expected.", (int)1, (int)((IUDetail)ius.get(0)).getReferencedRepositories().size());
                ImportExportRemoteTests.assertEquals((String)"Exported referred repository is not expected.", (Object)uri, ((IUDetail)ius.get(0)).getReferencedRepositories().get(0));
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        finally {
            testFile.delete();
        }
    }

    protected File getTestData(String message, String entry) {
        URL base;
        if (entry == null) {
            ImportExportRemoteTests.fail((String)(String.valueOf(message) + " entry is null."));
        }
        if ((base = TestActivator.getContext().getBundle().getEntry(entry)) == null) {
            ImportExportRemoteTests.fail((String)(String.valueOf(message) + " entry not found in bundle: " + entry));
        }
        try {
            String osPath = new Path(FileLocator.toFileURL((URL)base).getPath()).toOSString();
            File result = new File(osPath);
            if (!result.getCanonicalPath().equals(result.getPath())) {
                ImportExportRemoteTests.fail((String)(String.valueOf(message) + " result path: " + result.getPath() + " does not match canonical path: " + result.getCanonicalFile().getPath()));
            }
            return result;
        }
        catch (IOException iOException) {
            ImportExportRemoteTests.fail((String)message);
            return null;
        }
    }

    public void testExportFeaturesFromBothRemoteRepositoryAndLocalRepository() throws URISyntaxException, IOException, ProvisionException, OperationCanceledException {
        File testFile = File.createTempFile("test", "p2f");
        URI uri = this.getTestRepository();
        try {
            IMetadataRepositoryManager metaManager = (IMetadataRepositoryManager)ImportExportRemoteTests.getAgent().getService(IMetadataRepositoryManager.class);
            File localRepoFile = this.getTestData("Error load data", "testData/importexport/repo1");
            IMetadataRepository localRepo = metaManager.loadRepository(localRepoFile.toURI(), null);
            ImportExportRemoteTests.assertNotNull((String)"Fail to load local repo", (Object)localRepo);
            IMetadataRepository repo = metaManager.loadRepository(uri, null);
            ImportExportRemoteTests.assertNotNull((String)"Fail to load remote repo", (Object)repo);
            IInstallableUnit iu = AbstractProvisioningTest.createIU((String)"A", (Version)Version.create((String)"1.0.0"));
            Throwable throwable = null;
            Object var9_11 = null;
            try (FileOutputStream output = new FileOutputStream(testFile);){
                IStatus status = this.importexportService.exportP2F((OutputStream)output, new IInstallableUnit[]{iu}, false, null);
                ImportExportRemoteTests.assertTrue((String)"Not expected return result.", (boolean)status.isOK());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            throwable = null;
            var9_11 = null;
            try (FileInputStream input = new FileInputStream(testFile);){
                List ius = this.importexportService.importP2F((InputStream)input);
                ImportExportRemoteTests.assertEquals((String)"Exported the number of features is not expected.", (int)1, (int)ius.size());
                ImportExportRemoteTests.assertEquals((String)"Exported feature is not expected.", (Object)iu, (Object)((IUDetail)ius.get(0)).getIU());
                ImportExportRemoteTests.assertEquals((String)"Exported the number of referred repositories is not expected.", (int)1, (int)((IUDetail)ius.get(0)).getReferencedRepositories().size());
                ImportExportRemoteTests.assertEquals((String)"Exported referred repository is not expected.", (Object)uri, ((IUDetail)ius.get(0)).getReferencedRepositories().get(0));
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        finally {
            testFile.delete();
        }
    }
}

