/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui;

import java.io.File;
import java.net.URI;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.ui.model.ProfileElement;
import org.eclipse.equinox.internal.p2.ui.sdk.SimpleLicenseManager;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.PhaseSetFactory;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.operations.ProfileModificationJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.p2.ui.LicenseManager;
import org.eclipse.equinox.p2.ui.Policy;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.osgi.framework.ServiceRegistration;

public abstract class AbstractProvisioningUITest
extends AbstractProvisioningTest {
    protected static final String TEST_REPO_PATH = "testRepos/updateSite/";
    protected static final String TESTPROFILE = "TestProfile";
    protected static final String TOPLEVELIU = "TopLevelIU";
    protected static final String TOPLEVELIU2 = "TopLevelIU2";
    protected static final String NESTEDIU = "NestedIU";
    protected static final String LOCKEDIU = "LockedIU";
    protected static final String UNINSTALLEDIU = "UninstalledIU";
    protected static final String CATEGORYIU = "CategoryIU";
    protected IMetadataRepositoryManager metaManager;
    protected IArtifactRepositoryManager artifactManager;
    protected URI testRepoLocation;
    protected IProfile profile;
    protected ProfileElement profileElement;
    protected IInstallableUnit top1;
    protected IInstallableUnit top2;
    protected IInstallableUnit nested;
    protected IInstallableUnit locked;
    protected IInstallableUnit upgrade;
    protected IInstallableUnit uninstalled;
    protected IInstallableUnit category;
    protected ProvisioningUI ui;
    protected ServiceRegistration<LicenseManager> regLicenseManager;

    protected void setUp() throws Exception {
        super.setUp();
        this.profile = this.createProfile(TESTPROFILE);
        this.ui = ProvisioningUI.getDefaultUI();
        this.ui = new ProvisioningUI(this.ui.getSession(), TESTPROFILE, this.ui.getPolicy());
        this.ui.getOperationRunner().suppressRestart(true);
        this.ui.getPolicy().setRepositoriesVisible(false);
        SimpleLicenseManager manager = new SimpleLicenseManager(TESTPROFILE);
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>(5);
        ((Dictionary)properties).put("service.ranking", 1);
        this.regLicenseManager = TestActivator.getContext().registerService(LicenseManager.class, (Object)manager, properties);
        this.profileElement = new ProfileElement(null, TESTPROFILE);
        this.top1 = AbstractProvisioningUITest.createIU((String)TOPLEVELIU, (Version)Version.create((String)"1.0.0"));
        this.install(this.top1, true, false);
        this.top2 = AbstractProvisioningUITest.createIU((String)TOPLEVELIU2);
        this.install(this.top2, true, false);
        this.nested = AbstractProvisioningUITest.createIU((String)NESTEDIU);
        this.install(this.nested, false, false);
        this.locked = AbstractProvisioningUITest.createIU((String)LOCKEDIU);
        this.install(this.locked, true, true);
        this.uninstalled = AbstractProvisioningUITest.createIU((String)UNINSTALLEDIU);
        IUpdateDescriptor update = MetadataFactory.createUpdateDescriptor((String)TOPLEVELIU, (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), (int)0, (String)"update description");
        this.upgrade = AbstractProvisioningUITest.createIU((String)TOPLEVELIU, (Version)Version.createOSGi((int)2, (int)0, (int)0), null, (IRequirement[])NO_REQUIRES, (IProvidedCapability[])NO_PROVIDES, (Map)NO_PROPERTIES, null, (ITouchpointData)NO_TP_DATA, (boolean)false, (IUpdateDescriptor)update, (IRequirement[])NO_REQUIRES);
        this.category = this.createNamedIU(CATEGORYIU, CATEGORYIU, Version.create((String)"1.0.0"), true);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.top1, this.top2, this.uninstalled, this.upgrade});
        this.metaManager = (IMetadataRepositoryManager)AbstractProvisioningUITest.getAgent().getService(IMetadataRepositoryManager.class);
        this.artifactManager = (IArtifactRepositoryManager)AbstractProvisioningUITest.getAgent().getService(IArtifactRepositoryManager.class);
        File site = new File(TestActivator.getTestDataFolder().toString(), TEST_REPO_PATH);
        this.testRepoLocation = site.toURI();
        this.metaManager.addRepository(this.testRepoLocation);
        this.artifactManager.addRepository(this.testRepoLocation);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.metaManager.removeRepository(this.testRepoLocation);
        this.artifactManager.removeRepository(this.testRepoLocation);
        this.regLicenseManager.unregister();
    }

    protected boolean managerContains(IRepositoryManager<?> manager, URI location) {
        URI[] locations;
        URI[] uRIArray = locations = manager.getKnownRepositories(0);
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            URI location1 = uRIArray[n2];
            if (location1.equals(location)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected ProvisioningSession getSession() {
        return this.ui.getSession();
    }

    protected ProvisioningUI getProvisioningUI() {
        return this.ui;
    }

    protected Policy getPolicy() {
        return this.ui.getPolicy();
    }

    protected IStatus install(IInstallableUnit iu, boolean root, boolean lock) {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.add(iu);
        if (root) {
            req.setInstallableUnitProfileProperty(iu, "org.eclipse.equinox.p2.type.root", Boolean.toString(true));
        }
        if (lock) {
            req.setInstallableUnitProfileProperty(iu, "org.eclipse.equinox.p2.type.lock", Integer.valueOf(3).toString());
        }
        ProvisioningContext context = new ProvisioningContext(AbstractProvisioningUITest.getAgent());
        context.setMetadataRepositories(new URI[0]);
        IProvisioningPlan plan = this.getPlanner(this.getSession().getProvisioningAgent()).getProvisioningPlan((IProfileChangeRequest)req, context, this.getMonitor());
        if (plan.getStatus().getSeverity() == 4 || plan.getStatus().getSeverity() == 8) {
            return plan.getStatus();
        }
        return this.getSession().performProvisioningPlan(plan, PhaseSetFactory.createDefaultPhaseSet(), new ProvisioningContext(AbstractProvisioningUITest.getAgent()), this.getMonitor());
    }

    protected IInstallableUnit createNamedIU(String id, String name, Version version, boolean isCategory) {
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setId(id);
        iu.setVersion(version);
        iu.setProperty("org.eclipse.equinox.p2.name", name);
        if (isCategory) {
            iu.setProperty("org.eclipse.equinox.p2.type.category", Boolean.toString(true));
        }
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu);
    }

    protected ProfileModificationJob getLongTestOperation() {
        return new ProfileModificationJob("Test Operation", this.getSession(), TESTPROFILE, null, null){

            public IStatus runModal(IProgressMonitor monitor) {
                while (!monitor.isCanceled()) {
                }
                return Status.CANCEL_STATUS;
            }
        };
    }
}

