/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui.actions;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.eclipse.equinox.internal.p2.ui.model.ElementUtils;
import org.eclipse.equinox.internal.p2.ui.model.MetadataRepositoryElement;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.ui.actions.ProfileModificationActionTest;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.junit.Assert;

public class ElementUtilsTest
extends ProfileModificationActionTest {
    public void testEmpty() {
        ElementUtilsTest.assertEquals((int)this.getEmptySelection().length, (int)ElementUtils.elementsToIUs((Object[])this.getEmptySelection()).size());
    }

    public void testInvalid() {
        ElementUtilsTest.assertTrue((boolean)ElementUtils.elementsToIUs((Object[])this.getInvalidSelection()).isEmpty());
    }

    public void testIUs() {
        ElementUtilsTest.assertEquals((int)this.getTopLevelIUs().length, (int)ElementUtils.elementsToIUs((Object[])this.getTopLevelIUs()).size());
    }

    public void testElements() {
        ElementUtilsTest.assertEquals((int)this.getTopLevelIUElements().length, (int)ElementUtils.elementsToIUs((Object[])this.getTopLevelIUElements()).size());
    }

    public void testMixedIUsAndNonIUs() {
        Assert.assertNotEquals((long)this.getMixedIUsAndNonIUs().length, (long)ElementUtils.elementsToIUs((Object[])this.getMixedIUsAndNonIUs()).size());
    }

    public void testMixedIUsAndElements() {
        ElementUtilsTest.assertEquals((int)this.getMixedIUsAndElements().length, (int)ElementUtils.elementsToIUs((Object[])this.getMixedIUsAndElements()).size());
    }

    public void testUpdateUsingElements() throws URISyntaxException {
        URI known1 = new URI("https://example.com/known1");
        URI known2 = new URI("https://example.com/known2");
        IMetadataRepositoryManager manager = ElementUtilsTest.getMetadataRepositoryManager();
        manager.addRepository(known1);
        URI uri = new URI("https://example.com/1");
        URI uri2 = new URI("https://example.com/2");
        manager.addRepository(uri);
        manager.setRepositoryProperty(uri, "p2.system", Boolean.toString(true));
        manager.addRepository(uri2);
        ElementUtilsTest.getArtifactRepositoryManager().addRepository(uri2);
        manager.setRepositoryProperty(uri2, "p2.system", Boolean.toString(true));
        manager.setEnabled(uri2, false);
        ElementUtilsTest.getArtifactRepositoryManager().setEnabled(uri2, false);
        ArrayList<MetadataRepositoryElement> children = new ArrayList<MetadataRepositoryElement>();
        children.add(new MetadataRepositoryElement(null, known1, true));
        children.add(new MetadataRepositoryElement(null, known2, true));
        MetadataRepositoryElement[] elements = children.toArray(new MetadataRepositoryElement[children.size()]);
        URI uri3 = new URI("https://example.com/3");
        manager.addRepository(uri3);
        ElementUtils.updateRepositoryUsingElements((ProvisioningUI)this.getProvisioningUI(), (MetadataRepositoryElement[])elements);
        URI[] enabled = ElementUtilsTest.getMetadataRepositoryManager().getKnownRepositories(0);
        URI[] disabled = ElementUtilsTest.getMetadataRepositoryManager().getKnownRepositories(8);
        boolean foundKnown1 = false;
        boolean foundKnown2 = false;
        boolean found1 = false;
        boolean found2 = false;
        boolean found3 = false;
        URI[] uRIArray = enabled;
        int n = enabled.length;
        int n2 = 0;
        while (n2 < n) {
            URI enabled1 = uRIArray[n2];
            if (enabled1.equals(known1)) {
                foundKnown1 = true;
            }
            if (enabled1.equals(known2)) {
                foundKnown2 = true;
            }
            if (enabled1.equals(uri)) {
                found1 = true;
            }
            if (enabled1.equals(uri2)) {
                found2 = true;
            }
            if (enabled1.equals(uri3)) {
                found3 = true;
            }
            ++n2;
        }
        uRIArray = disabled;
        n = disabled.length;
        n2 = 0;
        while (n2 < n) {
            URI disabled1 = uRIArray[n2];
            if (disabled1.equals(known1)) {
                foundKnown1 = true;
            }
            if (disabled1.equals(known2)) {
                foundKnown2 = true;
            }
            if (disabled1.equals(uri)) {
                found1 = true;
            }
            if (disabled1.equals(uri2)) {
                found2 = true;
            }
            if (disabled1.equals(uri3)) {
                found3 = true;
            }
            ++n2;
        }
        ElementUtilsTest.assertTrue((String)"1.0", (boolean)found1);
        ElementUtilsTest.assertTrue((String)"1.1", (boolean)found2);
        ElementUtilsTest.assertFalse((String)"1.2", (boolean)found3);
        ElementUtilsTest.assertTrue((String)"1.3", (boolean)foundKnown1);
        ElementUtilsTest.assertTrue((String)"1.4", (boolean)foundKnown2);
        manager.removeRepository(known1);
        manager.removeRepository(known2);
        manager.removeRepository(uri);
        manager.removeRepository(uri2);
        ElementUtilsTest.getArtifactRepositoryManager().removeRepository(uri2);
        manager.removeRepository(uri3);
    }
}

