/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui.dialogs;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.metadata.ProvidedCapability;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.dialogs.IResolutionErrorReportingPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.PreselectedIUInstallWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningWizardDialog;
import org.eclipse.equinox.internal.p2.ui.dialogs.RemediationPage;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.tests.ui.dialogs.WizardTest;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.BlockJUnit4ClassRunner;

@RunWith(value=BlockJUnit4ClassRunner.class)
public class EECompatibilityTest
extends WizardTest {
    private static final int latestKnownJavaVersion = 14;
    private boolean previewCheckJREValue = false;
    private IInstallableUnit iuRequiringTooRecentEE;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.addAJREJavaSEUnit(this.getProfile("TestProfile"));
        this.previewCheckJREValue = this.getPolicy().getCheckAgainstCurrentExecutionEnvironment();
        this.getPolicy().setCheckAgainstCurrentExecutionEnvironment(true);
        this.iuRequiringTooRecentEE = EECompatibilityTest.iuRequiringTooRecentEE();
        Assume.assumeTrue((String)"Tests are skipped on latest known Java version", (Integer.parseInt(System.getProperty("java.version").split("\\.")[0].split("-")[0]) < 14 ? 1 : 0) != 0);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.getPolicy().setCheckAgainstCurrentExecutionEnvironment(this.previewCheckJREValue);
    }

    @Test
    public void testSingleIUPreventInstallation() {
        PreselectedIUInstallWizard wizard = new PreselectedIUInstallWizard(this.getProvisioningUI(), null, Collections.singletonList(this.iuRequiringTooRecentEE), null);
        wizard.setBypassLicensePage(true);
        ProvisioningWizardDialogExtension dialog = new ProvisioningWizardDialogExtension(ProvUI.getDefaultParentShell(), (ProvisioningOperationWizard)wizard);
        dialog.setBlockOnOpen(false);
        dialog.open();
        dialog.nextPressed();
        IResolutionErrorReportingPage page = (IResolutionErrorReportingPage)dialog.getCurrentPage();
        page.getMessage();
        EECompatibilityTest.assertFalse((boolean)wizard.canFinish());
    }

    @Test
    @Ignore(value="This test is not relevant as it doesn't build an interesting remediation. Feel free to improve!")
    public void testEEIssueSkipsRemediation() {
        IInstallableUnit unsatisfiableUnit = this.unsatisfiableUnit();
        IInstallableUnit unsatisfiedFeature = EECompatibilityTest.createFeature(unsatisfiableUnit);
        this.createTestMetdataRepository(new IInstallableUnit[]{unsatisfiableUnit, unsatisfiedFeature});
        IInstallableUnit[] units = new IInstallableUnit[]{this.iuRequiringTooRecentEE, EECompatibilityTest.createFeature(unsatisfiedFeature)};
        PreselectedIUInstallWizard wizard = new PreselectedIUInstallWizard(this.getProvisioningUI(), null, Arrays.asList(units), null);
        wizard.setBypassLicensePage(true);
        ProvisioningWizardDialogExtension dialog = new ProvisioningWizardDialogExtension(ProvUI.getDefaultParentShell(), (ProvisioningOperationWizard)wizard);
        dialog.setBlockOnOpen(false);
        dialog.open();
        dialog.nextPressed();
        EECompatibilityTest.assertTrue((boolean)(dialog.getCurrentPage() instanceof RemediationPage));
        EECompatibilityTest.assertFalse((boolean)wizard.canFinish());
        dialog.nextPressed();
        EECompatibilityTest.assertFalse((boolean)wizard.canFinish());
        dialog.close();
    }

    private IInstallableUnit unsatisfiableUnit() {
        MetadataFactory.InstallableUnitDescription desc = new MetadataFactory.InstallableUnitDescription();
        desc.setId("unsatisfiable-unit");
        desc.setVersion(Version.create((String)"0.0.1"));
        desc.addProvidedCapabilities(Collections.singletonList(new ProvidedCapability("org.eclipse.equinox.p2.iu", desc.getId(), desc.getVersion())));
        desc.addRequirements(Collections.singletonList(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"blah", (VersionRange)VersionRange.create((String)"1.0.0"), null, (boolean)false, (boolean)true)));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)desc);
    }

    private static IInstallableUnit iuRequiringTooRecentEE() {
        MetadataFactory.InstallableUnitDescription desc = new MetadataFactory.InstallableUnitDescription();
        desc.setId("dummyIU");
        desc.setVersion(Version.create((String)"0.0.1"));
        desc.addProvidedCapabilities(Collections.singletonList(new ProvidedCapability("org.eclipse.equinox.p2.iu", desc.getId(), desc.getVersion())));
        desc.addRequirements(Collections.singletonList(MetadataFactory.createRequirement((String)"osgi.ee", (String)"JavaSE", (VersionRange)VersionRange.create((String)"14.0.0"), null, (boolean)false, (boolean)true)));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)desc);
    }

    private static IInstallableUnit createFeature(IInstallableUnit ... included) {
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setId("dummyFeatureIncluding" + Stream.of(included).map(IVersionedId::getId).collect(Collectors.joining()) + ".feature.group");
        iu.setVersion(Version.create((String)"0.0.1"));
        iu.addProvidedCapabilities(Collections.singleton(MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)iu.getId(), (Version)iu.getVersion())));
        iu.addRequirements((Collection)Stream.of(included).map(unit -> MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)unit.getId(), (VersionRange)new VersionRange(unit.getVersion(), true, iu.getVersion(), true), null, (boolean)false, (boolean)false)).collect(Collectors.toList()));
        iu.setProperty("org.eclipse.equinox.p2.type.group", Boolean.TRUE.toString());
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu);
    }

    private void addAJREJavaSEUnit(IProfile profile) {
        InstallOperation installOperation = new InstallOperation(this.getSession(), Collections.singletonList(this.aJREJavaSE(14)));
        installOperation.setProfileId("TestProfile");
        installOperation.resolveModal((IProgressMonitor)new NullProgressMonitor());
        installOperation.getProvisioningJob((IProgressMonitor)new NullProgressMonitor()).run((IProgressMonitor)new NullProgressMonitor());
    }

    private IInstallableUnit aJREJavaSE(int javaSEVersion) {
        MetadataFactory.InstallableUnitDescription desc = new MetadataFactory.InstallableUnitDescription();
        desc.setId("a.jre.javase");
        desc.setVersion(Version.create((String)(String.valueOf(javaSEVersion) + ".0.0")));
        desc.addProvidedCapabilities(Arrays.asList(new ProvidedCapability("org.eclipse.equinox.p2.iu", desc.getId(), desc.getVersion()), new ProvidedCapability("osgi.ee", "JavaSE", desc.getVersion())));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)desc);
    }

    private final class ProvisioningWizardDialogExtension
    extends ProvisioningWizardDialog {
        private ProvisioningWizardDialogExtension(Shell parent, ProvisioningOperationWizard wizard) {
            super(parent, wizard);
        }

        public void nextPressed() {
            super.nextPressed();
        }
    }
}

