/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui.dialogs;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.tests.ui.AbstractProvisioningUITest;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.dialogs.PropertyDialog;

public class IUPropertyPagesTest
extends AbstractProvisioningUITest {
    private static final String GENERAL = "org.eclipse.equinox.p2.ui.sdk.IUGeneralInfoPropertyPage";
    private static final String COPYRIGHT = "org.eclipse.equinox.p2.ui.sdk.IUCopyrightPropertyPage";
    private static final String LICENSE = "org.eclipse.equinox.p2.ui.sdk.IULicensePropertyPage";
    private static boolean initialized;

    public static void init() {
        if (!initialized) {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            }
            catch (Exception e) {
                System.err.println("Bug 456940: First invocation of getActiveWorkbenchWindow() threw an Exception:");
                e.printStackTrace();
            }
            initialized = true;
        }
    }

    public void testGeneralPage() throws URISyntaxException {
        IUPropertyPagesTest.init();
        PropertyDialog dialog = PropertyDialog.createDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)GENERAL, (Object)this.getIU());
        dialog.setBlockOnOpen(false);
        dialog.open();
        dialog.close();
    }

    public void testCopyrightPage() throws URISyntaxException {
        IUPropertyPagesTest.init();
        PropertyDialog dialog = PropertyDialog.createDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)COPYRIGHT, (Object)this.getIU());
        dialog.setBlockOnOpen(false);
        dialog.open();
        dialog.close();
    }

    public void testLicensePage() throws URISyntaxException {
        IUPropertyPagesTest.init();
        PropertyDialog dialog = PropertyDialog.createDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)LICENSE, (Object)this.getIU());
        dialog.setBlockOnOpen(false);
        dialog.open();
        dialog.close();
    }

    private IInstallableUnit getIU() throws URISyntaxException {
        MetadataFactory.InstallableUnitDescription iuDescription = new MetadataFactory.InstallableUnitDescription();
        iuDescription.setId("TestIU");
        iuDescription.setVersion(Version.createOSGi((int)1, (int)0, (int)0));
        iuDescription.setProperty("org.eclipse.equinox.p2.provider", "Test Cases");
        iuDescription.setProperty("org.eclipse.equinox.p2.description", "A description");
        iuDescription.setProperty("org.eclipse.equinox.p2.name", "The Biggest Baddest Test IU");
        iuDescription.setLicenses(new ILicense[]{MetadataFactory.createLicense((URI)new URI("http://example.com"), (String)"This is an example license")});
        iuDescription.setCopyright(MetadataFactory.createCopyright((URI)new URI("http://example.com"), (String)"This is an example copyright"));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iuDescription);
    }
}

