/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui.dialogs;

import java.io.File;
import java.net.URI;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.dialogs.InstallWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningWizardDialog;
import org.eclipse.equinox.internal.p2.ui.dialogs.UpdateWizard;
import org.eclipse.equinox.internal.p2.ui.model.ProfileElement;
import org.eclipse.equinox.internal.p2.ui.sdk.SimpleLicenseManager;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.operations.Update;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.IUDescription;
import org.eclipse.equinox.p2.tests.IULoader;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.p2.tests.ui.dialogs.WizardTest;
import org.eclipse.equinox.p2.ui.LicenseManager;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.equinox.p2.ui.ProvisioningUI;

public class RemediationTest
extends WizardTest {
    public static final int INSTALLATION_SUCCEEDED = 1;
    public static final int INSTALLATION_REMEDIATED = 2;
    public static final int INSTALLATION_FAILED = 3;
    public static final int CHECK_FOR_UPDATES = 4;
    public static final int UPDATE_ONE_IU = 5;
    private String name = "PROFILE_";
    @IUDescription(content="package: jboss \nsingleton: true\nversion: 6 \ndepends: m2e = 2")
    public IInstallableUnit jboss60;
    @IUDescription(content="package: jboss \nsingleton: true\nversion: 5 \ndepends: m2e = 1")
    public IInstallableUnit jboss55;
    @IUDescription(content="package: m2e \nsingleton: true\nversion: 1 \n")
    public IInstallableUnit m2e11;
    @IUDescription(content="package: m2e \nsingleton: true\nversion: 2 \n")
    public IInstallableUnit m2e12;
    IInstallableUnit toInstall;

    public void visibleSetup(int type) throws Exception {
        URI[] repos;
        this.name = "PROFILE_" + type;
        URI[] uRIArray = repos = RemediationTest.getMetadataRepositoryManager().getKnownRepositories(0);
        int n = repos.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            RemediationTest.getMetadataRepositoryManager().removeRepository(uri);
            ++n2;
        }
        this.profile = this.createProfile(this.name);
        this.ui = ProvisioningUI.getDefaultUI();
        this.ui = new ProvisioningUI(this.ui.getSession(), this.name, this.ui.getPolicy());
        this.ui.getOperationRunner().suppressRestart(true);
        this.ui.getPolicy().setRepositoriesVisible(false);
        SimpleLicenseManager manager = new SimpleLicenseManager(this.name);
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>(5);
        ((Dictionary)properties).put("service.ranking", 1);
        this.regLicenseManager = TestActivator.getContext().registerService(LicenseManager.class, (Object)manager, properties);
        this.profileElement = new ProfileElement(null, this.name);
        IULoader.loadIUs((Object)((Object)this));
        ILicense[] licenses = new ILicense[]{MetadataFactory.createLicense((URI)URI.create("http://eclipse.org"), (String)"license text"), MetadataFactory.createLicense((URI)URI.create("http://apache.org"), (String)"license text2")};
        ((InstallableUnit)this.jboss60).setLicenses(licenses);
        switch (type) {
            case 1: {
                this.createTestMetdataRepository(new IInstallableUnit[]{this.jboss60, this.m2e11, this.m2e12});
                this.install(this.m2e12, true, false);
                this.toInstall = this.jboss60;
                break;
            }
            case 2: {
                this.createTestMetdataRepository(new IInstallableUnit[]{this.jboss60, this.m2e11, this.m2e12});
                this.install(this.m2e11, true, false);
                this.toInstall = this.jboss60;
                break;
            }
            case 3: {
                this.createTestMetdataRepository(new IInstallableUnit[]{this.jboss60, this.m2e11});
                this.install(this.m2e11, true, false);
                this.toInstall = this.jboss60;
                break;
            }
            case 4: {
                this.createTestMetdataRepository(new IInstallableUnit[]{this.jboss60, this.m2e11, this.m2e12});
                this.install(this.m2e11, true, false);
                break;
            }
            case 5: {
                this.createTestMetdataRepository(new IInstallableUnit[]{this.jboss55, this.jboss60, this.m2e11, this.m2e12});
                this.install(this.jboss55, true, false);
                this.install(this.m2e11, true, false);
                break;
            }
            default: {
                this.createTestMetdataRepository(new IInstallableUnit[]{this.jboss60, this.m2e11});
                this.install(this.m2e11, true, false);
            }
        }
        this.metaManager = (IMetadataRepositoryManager)RemediationTest.getAgent().getService(IMetadataRepositoryManager.class);
        this.artifactManager = (IArtifactRepositoryManager)RemediationTest.getAgent().getService(IArtifactRepositoryManager.class);
        File site = new File(TestActivator.getTestDataFolder().toString(), "testRepos/updateSite/");
        this.testRepoLocation = site.toURI();
        this.metaManager.addRepository(this.testRepoLocation);
        this.artifactManager.addRepository(this.testRepoLocation);
    }

    public void testInstallWizard() throws Exception {
        LoadMetadataRepositoryJob job = new LoadMetadataRepositoryJob(this.getProvisioningUI());
        this.getPolicy().setGroupByCategory(false);
        this.getPolicy().setShowLatestVersionsOnly(false);
        job.runModal(this.getMonitor());
        InstallWizard wizard = new InstallWizard(this.getProvisioningUI(), null, null, job);
        ProvisioningWizardDialog dialog = new ProvisioningWizardDialog(ProvUI.getDefaultParentShell(), (ProvisioningOperationWizard)wizard);
        dialog.create();
        dialog.setBlockOnOpen(false);
        dialog.open();
    }

    public void testUpdateWizard() throws Exception {
        LoadMetadataRepositoryJob job = new LoadMetadataRepositoryJob(this.getProvisioningUI());
        this.getPolicy().setGroupByCategory(false);
        this.getPolicy().setShowLatestVersionsOnly(false);
        job.runModal(this.getMonitor());
        UpdateOperation op = new UpdateOperation(this.getSession());
        op.setProfileId(this.name);
        op.resolveModal(this.getMonitor());
        UpdateWizard wizard = new UpdateWizard(this.getProvisioningUI(), op, (Object[])new Update[0], job);
        ProvisioningWizardDialog dialog = new ProvisioningWizardDialog(ProvUI.getDefaultParentShell(), (ProvisioningOperationWizard)wizard);
        dialog.create();
        dialog.setBlockOnOpen(false);
        dialog.open();
    }
}

