/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui.misc;

import java.net.URI;
import org.eclipse.equinox.internal.p2.ui.sdk.SimpleLicenseManager;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.tests.ui.AbstractProvisioningUITest;
import org.eclipse.equinox.p2.ui.LicenseManager;

public class LicenseManagerTest
extends AbstractProvisioningUITest {
    public void testLicenseAcceptAndReject() {
        LicenseManager manager = this.getProvisioningUI().getLicenseManager();
        SimpleLicense foo = new SimpleLicense("foo", "foo");
        SimpleLicense bar = new SimpleLicense("bar", "bar");
        manager.accept((ILicense)foo);
        manager.accept((ILicense)bar);
        LicenseManagerTest.assertTrue((String)"1.0", (boolean)manager.hasAcceptedLicenses());
        manager.reject((ILicense)foo);
        manager.reject((ILicense)bar);
        LicenseManagerTest.assertFalse((String)"1.1", (boolean)manager.hasAcceptedLicenses());
        manager.accept((ILicense)foo);
        manager.accept((ILicense)bar);
        LicenseManagerTest.assertTrue((String)"1.2", (boolean)manager.hasAcceptedLicenses());
    }

    public void testDifferentProfilesDifferentLicenses() {
        LicenseManager manager = this.getProvisioningUI().getLicenseManager();
        SimpleLicense foo = new SimpleLicense("foo", "foo");
        SimpleLicense bar = new SimpleLicense("bar", "bar");
        manager.accept((ILicense)foo);
        manager.accept((ILicense)bar);
        LicenseManagerTest.assertTrue((String)"1.0", (boolean)manager.hasAcceptedLicenses());
        SimpleLicenseManager manager2 = new SimpleLicenseManager("TestProfile");
        LicenseManagerTest.assertTrue((String)"1.1", (boolean)manager2.hasAcceptedLicenses());
        this.profile = this.createProfile("ANOTHER");
        manager2 = new SimpleLicenseManager("ANOTHER");
        LicenseManagerTest.assertFalse((String)"1.2", (boolean)manager2.hasAcceptedLicenses());
    }

    class SimpleLicense
    implements ILicense {
        String body;
        String id;

        SimpleLicense(String id, String body) {
            this.id = id;
            this.body = body;
        }

        public URI getLocation() {
            return null;
        }

        public String getBody() {
            return this.body;
        }

        public String getUUID() {
            return this.id;
        }
    }
}

