/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui.query;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.equinox.internal.p2.ui.model.CategoryElement;
import org.eclipse.equinox.internal.p2.ui.model.EmptyElementExplanation;
import org.eclipse.equinox.internal.p2.ui.query.CategoryElementWrapper;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.tests.MockQueryable;
import org.eclipse.equinox.p2.tests.ui.query.AbstractQueryTest;

public class CategoryElementWrapperTest
extends AbstractQueryTest {
    private CategoryElementWrapper createWrapper() {
        IInstallableUnit category = CategoryElementWrapperTest.createIU((String)"default category");
        return new CategoryElementWrapper((IQueryable)new MockQueryable((Object)category), null);
    }

    private IInstallableUnit createNamedCategory(String id, String name, Version version) {
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setId(id);
        iu.setVersion(version);
        iu.setProperty("org.eclipse.equinox.p2.name", name);
        iu.setProperty("org.eclipse.equinox.p2.type.category", Boolean.toString(true));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu);
    }

    public void testCollectObject() {
        CategoryElementWrapper wrapper = this.createWrapper();
        Collector collector = new Collector();
        collector.accept((Object)"AnObjectThatIsNotAnIU");
        Iterator results = wrapper.getElements(collector).iterator();
        while (results.hasNext()) {
            CategoryElementWrapperTest.assertTrue((String)"1.0", (boolean)(results.next() instanceof EmptyElementExplanation));
        }
    }

    public void testIsEmpty() {
        CategoryElementWrapper wrapper = this.createWrapper();
        Collector collector = new Collector();
        CategoryElementWrapperTest.assertTrue((String)"1.1", (boolean)collector.isEmpty());
        IInstallableUnit category1 = CategoryElementWrapperTest.createIU((String)"category1");
        collector.accept((Object)category1);
        Collection results = wrapper.getElements(collector);
        CategoryElementWrapperTest.assertTrue((String)"1.2", (!results.isEmpty() ? 1 : 0) != 0);
    }

    public void testSize() {
        CategoryElementWrapper wrapper = this.createWrapper();
        Collector collector = new Collector();
        CategoryElementWrapperTest.assertEquals((String)"1.1", (int)0, (int)collector.size());
        IInstallableUnit category1 = CategoryElementWrapperTest.createIU((String)"category1");
        collector.accept((Object)category1);
        Collection results = wrapper.getElements(collector);
        CategoryElementWrapperTest.assertEquals((String)"1.2", (int)1, (int)collector.size());
        CategoryElementWrapperTest.assertEquals((String)"1.3", (IInstallableUnit)category1, (IInstallableUnit)((CategoryElement)results.iterator().next()).getIU());
        collector.accept((Object)category1);
        results = wrapper.getElements(collector);
        CategoryElementWrapperTest.assertEquals((String)"1.6", (int)1, (int)results.size());
        IRequirement[] required = CategoryElementWrapperTest.createRequiredCapabilities((String)"org.eclipse.equinox.p2.iu", (String)"category1");
        IInstallableUnit nested = CategoryElementWrapperTest.createIU((String)"Nested", (IRequirement[])required);
        collector.accept((Object)nested);
        results = wrapper.getElements(collector);
        CategoryElementWrapperTest.assertEquals((String)"1.7", (int)1, (int)results.size());
    }

    public void testCategoryMerging() {
        CategoryElementWrapper wrapper = this.createWrapper();
        Collector collector = new Collector();
        CategoryElementWrapperTest.assertEquals((String)"1.1", (int)0, (int)collector.size());
        IInstallableUnit category1 = this.createNamedCategory("qualifier1.foo", "Foo", DEFAULT_VERSION);
        collector.accept((Object)category1);
        Collection results = wrapper.getElements(collector);
        CategoryElementWrapperTest.assertEquals((String)"1.2", (int)1, (int)collector.size());
        CategoryElementWrapperTest.assertEquals((String)"1.3", (IInstallableUnit)category1, (IInstallableUnit)((CategoryElement)results.iterator().next()).getIU());
        IInstallableUnit category2 = this.createNamedCategory("qualifier2.foo", "Foo", DEFAULT_VERSION);
        collector.accept((Object)category2);
        results = wrapper.getElements(collector);
        CategoryElementWrapperTest.assertEquals((String)"1.4", (int)1, (int)results.size());
    }
}

