/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui.query;

import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.ui.QueryableArtifactRepositoryManager;
import org.eclipse.equinox.internal.p2.ui.RepositoryLocationQuery;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.tests.ui.query.AbstractQueryTest;
import org.eclipse.equinox.p2.ui.ProvisioningUI;

public class QueryableArtifactRepositoryManagerTest
extends AbstractQueryTest {
    private static final String repositoryOne = "http://one.lan";
    private static final String repositoryTwo = "http://two.lan";
    private int repoCount = 0;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        IArtifactRepositoryManager repoManager = QueryableArtifactRepositoryManagerTest.getArtifactRepositoryManager();
        repoManager.addRepository(URIUtil.fromString((String)repositoryOne));
        repoManager.addRepository(URIUtil.fromString((String)repositoryTwo));
        this.repoCount = repoManager.getKnownRepositories(0).length;
    }

    @Override
    public void tearDown() throws Exception {
        IArtifactRepositoryManager repoManager = QueryableArtifactRepositoryManagerTest.getArtifactRepositoryManager();
        repoManager.removeRepository(URIUtil.fromString((String)repositoryOne));
        repoManager.removeRepository(URIUtil.fromString((String)repositoryTwo));
        super.tearDown();
    }

    public void testQuery() {
        QueryableArtifactRepositoryManager manager = this.getQueryableManager();
        IQueryResult result = manager.locationsQueriable().query((IQuery)new RepositoryLocationQuery(), this.getMonitor());
        QueryableArtifactRepositoryManagerTest.assertEquals((int)this.repoCount, (int)QueryableArtifactRepositoryManagerTest.queryResultSize((IQueryResult)result));
    }

    private QueryableArtifactRepositoryManager getQueryableManager() {
        return new QueryableArtifactRepositoryManager(ProvisioningUI.getDefaultUI(), false);
    }
}

