/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.TestExecutionContext;
import org.eclipse.test.ClassLoaderTools;
import org.eclipse.test.LegacyXmlResultFormatter;
import org.eclipse.ui.testing.dumps.TimeoutDumpTimer;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class EclipseTestRunner {
    public static final int SUCCESS = 0;
    public static final int FAILURES = 1;
    public static final int ERRORS = 2;

    public static void main(String[] args) throws IOException {
        System.exit(EclipseTestRunner.run(args));
    }

    public static int run(String[] args) throws IOException {
        String className = null;
        String classesNames = null;
        String testPluginName = null;
        String testPluginsNames = null;
        String resultPathString = null;
        String timeoutString = null;
        String junitReportOutput = null;
        Properties props = new Properties();
        int startArgs = 0;
        if (args.length > 0 && !args[0].startsWith("-")) {
            className = args[0];
            ++startArgs;
        }
        int i = startArgs;
        while (i < args.length) {
            block37: {
                Object formatterString;
                if (args[i].toLowerCase().equals("-classname")) {
                    if (i < args.length - 1) {
                        className = args[i + 1];
                    }
                    ++i;
                } else if (args[i].toLowerCase().equals("-classesnames")) {
                    if (i < args.length - 1) {
                        classesNames = args[i + 1];
                    }
                    ++i;
                } else if (args[i].toLowerCase().equals("-testpluginname")) {
                    if (i < args.length - 1) {
                        testPluginName = args[i + 1];
                    }
                    ++i;
                } else if (args[i].toLowerCase().equals("-testpluginsnames")) {
                    if (i < args.length - 1) {
                        testPluginsNames = args[i + 1];
                    }
                    ++i;
                } else if (args[i].equals("-junitReportOutput")) {
                    if (i < args.length - 1) {
                        junitReportOutput = args[i + 1];
                    }
                    ++i;
                } else if (args[i].startsWith("formatter=")) {
                    formatterString = args[i].substring(10);
                    int seperatorIndex22 = ((String)formatterString).indexOf(44);
                    resultPathString = seperatorIndex22 == -1 ? null : ((String)formatterString).substring(seperatorIndex22 + 1);
                } else {
                    if (args[i].startsWith("propsfile=")) {
                        formatterString = null;
                        Object seperatorIndex22 = null;
                        try (FileInputStream in = new FileInputStream(args[i].substring(10));){
                            props.load(in);
                            break block37;
                        }
                        catch (Throwable seperatorIndex22) {
                            if (formatterString == null) {
                                formatterString = seperatorIndex22;
                            } else if (formatterString != seperatorIndex22) {
                                ((Throwable)formatterString).addSuppressed(seperatorIndex22);
                            }
                            throw formatterString;
                        }
                    }
                    if (args[i].equals("-timeout")) {
                        if (i < args.length - 1) {
                            timeoutString = args[i + 1];
                        }
                        ++i;
                    }
                }
            }
            ++i;
        }
        props.putAll((Map<?, ?>)System.getProperties());
        if (timeoutString == null || timeoutString.isEmpty()) {
            System.err.println("INFO: optional timeout was not specified.");
        } else {
            String timeoutScreenOutputDir = null;
            timeoutScreenOutputDir = junitReportOutput == null || junitReportOutput.isEmpty() ? "timeoutScreens" : String.valueOf(junitReportOutput) + "/timeoutScreens";
            System.err.println("INFO: timeoutScreenOutputDir: " + timeoutScreenOutputDir);
            System.err.println("INFO: timeout: " + timeoutString);
            TimeoutDumpTimer.startTimeoutDumpTimer((String)timeoutString, (File)new File(timeoutScreenOutputDir));
        }
        if (testPluginsNames != null && classesNames != null) {
            String[] testPlugins = testPluginsNames.split(",");
            String[] suiteClasses = classesNames.split(",");
            int returnCode = 0;
            int j = 0;
            String[] stringArray = suiteClasses;
            int n = suiteClasses.length;
            int n2 = 0;
            while (n2 < n) {
                String oneClassName = stringArray[n2];
                int result = EclipseTestRunner.runTests(props, testPlugins[j], oneClassName, resultPathString, true);
                ++j;
                if (result != 0) {
                    returnCode = result;
                }
                ++n2;
            }
            return returnCode;
        }
        if (className == null) {
            throw new IllegalArgumentException("Test class name not specified");
        }
        return EclipseTestRunner.runTests(props, testPluginName, className, resultPathString, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int runTests(Properties props, String testPluginName, String testClassName, String resultPath, boolean multiTest) {
        AtomicBoolean executionFailed;
        block18: {
            Thread thisThread = Thread.currentThread();
            ClassLoader currentTCCL = thisThread.getContextClassLoader();
            Bundle testPlugin = ClassLoaderTools.getTestBundle(testPluginName, testClassName);
            LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass((String)testClassName)}).build();
            executionFailed = new AtomicBoolean(false);
            try {
                try {
                    Throwable throwable = null;
                    Object var11_13 = null;
                    try {
                        LegacyXmlResultFormatter formatter = new LegacyXmlResultFormatter();
                        try {
                            try (OutputStream out = EclipseTestRunner.getResultOutputStream(resultPath, testClassName, multiTest);){
                                ClassLoader jUnit5Classloader = ClassLoaderTools.getJUnit5Classloader(EclipseTestRunner.getPlatformEngines());
                                thisThread.setContextClassLoader(jUnit5Classloader);
                                Launcher launcher = LauncherFactory.create();
                                thisThread.setContextClassLoader(ClassLoaderTools.getPluginClassLoader(testPlugin, jUnit5Classloader));
                                formatter.setDestination(out);
                                formatter.setContext(EclipseTestRunner.createExecutionContext(props));
                                launcher.execute(request, new TestExecutionListener[]{formatter, EclipseTestRunner.createExecutionListener(executionFailed)});
                            }
                            if (formatter == null) break block18;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (formatter == null) throw throwable;
                            formatter.close();
                            throw throwable;
                        }
                        formatter.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    thisThread.setContextClassLoader(currentTCCL);
                    return 2;
                }
            }
            finally {
                thisThread.setContextClassLoader(currentTCCL);
            }
        }
        if (!executionFailed.get()) return 0;
        return 1;
    }

    private static OutputStream getResultOutputStream(String resultPathString, String testClassName, boolean multiTest) throws IOException {
        if (resultPathString == null || resultPathString.isEmpty()) {
            return System.out;
        }
        Path resultFile = Path.of(resultPathString, new String[0]);
        if (multiTest) {
            resultFile = resultFile.resolve("TEST-" + testClassName + ".xml");
        } else if (Files.isDirectory(resultFile, new LinkOption[0])) {
            resultFile = resultFile.resolve("TEST-" + testClassName + ".xml");
        }
        Files.createDirectories(resultFile.getParent(), new FileAttribute[0]);
        return Files.newOutputStream(resultFile, new OpenOption[0]);
    }

    private static List<Bundle> getPlatformEngines() {
        BundleContext context = FrameworkUtil.getBundle(EclipseTestRunner.class).getBundleContext();
        return Arrays.stream(context.getBundles()).filter(bundle -> {
            try {
                return bundle.getEntry("META-INF/services/org.junit.platform.engine.TestEngine") != null;
            }
            catch (Exception exception) {
                return false;
            }
        }).collect(Collectors.toList());
    }

    private static TestExecutionListener createExecutionListener(final AtomicBoolean executionFailed) {
        return new TestExecutionListener(){

            public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult executionResult) {
                if (executionResult.getStatus() == TestExecutionResult.Status.FAILED) {
                    executionFailed.set(true);
                }
            }
        };
    }

    private static TestExecutionContext createExecutionContext(final Properties props) {
        return new TestExecutionContext(){

            public Properties getProperties() {
                return props;
            }

            public Optional<Project> getProject() {
                return Optional.empty();
            }
        };
    }
}

