/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test;

import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.StringTokenizer;

public class RegressionTest {
    private final String oldFilename;
    private final String newFilename;
    private final String outFilename;

    public RegressionTest(String oldFilename, String newFilename, String outFilename) {
        this.oldFilename = oldFilename;
        this.newFilename = newFilename;
        this.outFilename = outFilename;
    }

    public static void main(String[] argv) {
        if (argv.length < 3) {
            System.err.println("Error: too few arguments");
            System.err.println("Usage: (progname) oldfile newfile outfile");
        } else {
            RegressionTest rt = new RegressionTest(argv[0], argv[1], argv[2]);
            rt.testRegressions();
        }
    }

    public void testRegressions() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (PrintStream output = new PrintStream(this.outFilename);){
                String oldPass = Files.readString(Path.of(this.oldFilename, new String[0]));
                String newPass = Files.readString(Path.of(this.newFilename, new String[0]));
                this.parse(oldPass, newPass, output);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            System.err.println("Error opening file");
            System.err.println(e.getMessage());
            System.exit(-1);
        }
    }

    private void parse(String oldPass, String newPass, PrintStream output) {
        StringTokenizer oldst = new StringTokenizer(oldPass);
        StringTokenizer newst = new StringTokenizer(newPass);
        String[] oldTest = RegressionTest.nextTest(oldst);
        String[] newTest = RegressionTest.nextTest(newst);
        boolean nothingChanged = true;
        while (oldTest != null && newTest != null) {
            int compareName = oldTest[0].compareTo(newTest[0]);
            if (compareName == 0) {
                int compareStatus = oldTest[1].compareTo(newTest[1]);
                if (compareStatus != 0) {
                    nothingChanged = false;
                    output.println(RegressionTest.testChanged(newTest));
                }
                oldTest = RegressionTest.nextTest(oldst);
                newTest = RegressionTest.nextTest(newst);
                continue;
            }
            if (compareName < 0) {
                output.println(RegressionTest.testNotRun(oldTest));
                oldTest = RegressionTest.nextTest(oldst);
                nothingChanged = false;
                continue;
            }
            output.println(RegressionTest.testAdded(newTest));
            newTest = RegressionTest.nextTest(newst);
            nothingChanged = false;
        }
        while (oldTest != null) {
            output.println(RegressionTest.testNotRun(oldTest));
            oldTest = RegressionTest.nextTest(oldst);
            nothingChanged = false;
        }
        while (newTest != null) {
            output.println(RegressionTest.testAdded(newTest));
            newTest = RegressionTest.nextTest(newst);
            nothingChanged = false;
        }
        if (nothingChanged) {
            output.println("All tests unchanged.");
        }
    }

    static String testNotRun(String[] test) {
        return "Not run: " + test[0];
    }

    static String testChanged(String[] test) {
        return "Changed: " + test[0] + ", " + test[1];
    }

    static String testAdded(String[] test) {
        return "New test: " + test[0] + ", Status: " + test[1];
    }

    static String[] nextTest(StringTokenizer st) {
        String[] test = new String[2];
        if (!st.hasMoreTokens()) {
            return null;
        }
        test[0] = st.nextToken();
        if (!st.hasMoreTokens()) {
            return null;
        }
        test[1] = st.nextToken();
        return test;
    }
}

