/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.signaturetest;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;

class PackageList {
    private static final char COMMENT_CHAR = '#';
    private File packageFile;
    private File sigFile;
    private String additionalPackageName;
    private Set<String> packageNames = new TreeSet<String>();

    public PackageList(String packageFileName) throws Exception {
        this.packageFile = new File(packageFileName);
        if (!this.packageFile.exists() || !this.packageFile.isFile()) {
            throw new FileNotFoundException(packageFileName);
        }
        this.extractExistingPackageNames();
    }

    public PackageList(String packageName, String sigFileName, String packageFileName) throws Exception {
        this.additionalPackageName = packageName;
        this.sigFile = new File(sigFileName);
        if (!this.sigFile.exists() || !this.sigFile.isFile()) {
            throw new FileNotFoundException(sigFileName);
        }
        this.packageFile = new File(packageFileName);
        if (this.packageFile.exists() && this.packageFile.isFile()) {
            this.extractExistingPackageNames();
            this.removeExistingPackage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractExistingPackageNames() throws Exception {
        BufferedReader in = new BufferedReader(new FileReader(this.packageFile));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                String trimLine = line.trim();
                if (this.isComment(trimLine) || "".equals(trimLine)) continue;
                this.packageNames.add(trimLine);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    private boolean isComment(String line) {
        if (line == null) {
            return false;
        }
        String theLine = line.trim();
        if (theLine.length() > 0) {
            return theLine.charAt(0) == '#';
        }
        return false;
    }

    private void removeExistingPackage() {
        String delPackage = this.additionalPackageName;
        ArrayList<String> delPkgs = new ArrayList<String>();
        for (String packageName : this.packageNames) {
            if (!packageName.startsWith(delPackage)) continue;
            delPkgs.add(packageName);
        }
        for (int i = 0; i < delPkgs.size(); ++i) {
            String packageName;
            packageName = (String)delPkgs.get(i);
            this.packageNames.remove(packageName);
            System.out.println("PackageList.removeExistingPackage() \"" + packageName + "\"");
        }
    }

    public String[] getSubPackages(String pkgName) {
        ArrayList<String> result = new ArrayList<String>();
        String subPackageName = pkgName + ".";
        for (String packageName : this.packageNames) {
            if (!packageName.startsWith(subPackageName)) continue;
            result.add(packageName);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getSubPackagesFormatted(String pkgName) {
        StringBuffer formattedResult = new StringBuffer();
        String[] result = this.getSubPackages(pkgName);
        for (int i = 0; i < result.length; ++i) {
            formattedResult.append(result[i]);
            if (i >= result.length - 1) continue;
            formattedResult.append("+");
        }
        return formattedResult.toString();
    }
}

