/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceFactory;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQEmbeddedService;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;

public class IMQEmbeddedServiceFactory
extends ServiceFactory {
    protected static final Logger logger = Globals.getLogger();
    protected BrokerConfig props = Globals.getConfig();
    protected int DEFAULT_DESTROY_TIMEOUT = 30;

    @Override
    public void checkFactoryHandlerName(String handlerName) throws IllegalAccessException {
        String myname = "mqdirect";
        if (!myname.equals(handlerName)) {
            throw new IllegalAccessException("Unexpected service Handler name " + handlerName + ", expected " + myname);
        }
    }

    @Override
    public void updateService(Service s) throws BrokerException {
        IMQService ss = (IMQService)s;
        String name = s.getName();
        int newmin = this.getThreadMin(name);
        int newmax = this.getThreadMax(name);
        try {
            ss.setMinMaxThreadpool(newmin, newmax);
        }
        catch (IllegalArgumentException e) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4115", String.valueOf(newmin), String.valueOf(newmax)), e);
        }
        Globals.getPortMapper().addService(name, "none", this.props.getProperty("imq." + name + ".servicetype"), 0, ss.getServiceProperties());
    }

    @Override
    public void startMonitoringService(Service s) throws BrokerException {
        String name = s.getName();
        String bstr = "imq." + name + ".min_threads";
        this.props.addListener(bstr, this);
        bstr = "imq." + name + ".max_threads";
        this.props.addListener(bstr, this);
    }

    @Override
    public void stopMonitoringService(Service s) throws BrokerException {
        String name = s.getName();
        String bstr = "imq." + name + ".min";
        this.props.removeListener(bstr, this);
        bstr = "imq." + name + ".max";
        this.props.removeListener(bstr, this);
    }

    @Override
    public void validate(String name, String value) throws PropertyUpdateException {
    }

    @Override
    public boolean update(String name, String value) {
        return true;
    }

    protected int getThreadMin(String instancename) {
        String bstr = "imq." + instancename + ".min_threads";
        return this.props.getIntProperty(bstr);
    }

    protected int getPoolTimeout(String instancename) {
        String bstr = "imq." + instancename + ".destroy_timeout";
        return this.props.getIntProperty(bstr, this.DEFAULT_DESTROY_TIMEOUT) * 1000;
    }

    protected int getThreadMax(String instancename) {
        String bstr = "imq." + instancename + ".max_threads";
        return this.props.getIntProperty(bstr);
    }

    @Override
    public Service createService(String instancename, int type) throws BrokerException {
        if (DEBUG) {
            logger.log(4, " Creating new Service(" + instancename + ": Embedded )");
        }
        IMQEmbeddedService svc = new IMQEmbeddedService(instancename, type, Globals.getPacketRouter(type), this.getThreadMin(instancename), this.getThreadMax(instancename));
        long timeout = this.getPoolTimeout(instancename);
        if (timeout > 0L) {
            ((IMQService)svc).setDestroyWaitTime(timeout);
        }
        return svc;
    }
}

