/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import org.jboss.jdeparser.AbstractJAssignableExpr;
import org.jboss.jdeparser.AbstractJType;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.Tokens$;

class StaticRefJExpr
extends AbstractJAssignableExpr {
    private final AbstractJType type;
    private final String refName;

    StaticRefJExpr(AbstractJType type, String refName) {
        super(1);
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (refName == null) {
            throw new IllegalArgumentException("refName is null");
        }
        this.type = type;
        this.refName = refName;
    }

    AbstractJType getType() {
        return this.type;
    }

    String getRefName() {
        return this.refName;
    }

    @Override
    public void write(SourceFileWriter writer) throws IOException {
        if (!writer.getClassFile().hasStaticImport(this.refName, this.type)) {
            this.type.writeDirect(writer);
            writer.write(Tokens$.PUNCT.DOT);
        }
        writer.writeEscapedWord(this.refName);
    }

    void writeForImport(SourceFileWriter writer) throws IOException {
        writer.processSpacing();
        writer.writeClass(this.type.qualifiedName());
        writer.write(Tokens$.PUNCT.DOT);
        writer.writeEscapedWord(this.refName);
    }

    String getName() {
        return this.refName;
    }
}

