/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.validation;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.lang.model.element.Element;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.validation.ValidationMessage;
import org.jboss.logging.processor.validation.ValidationMessageFactory;

public class IdLengthValidator {
    private final Map<String, Integer> lengths = new HashMap<String, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ValidationMessage> validate(MessageInterface messageInterface) {
        LinkedList<ValidationMessage> messages = new LinkedList<ValidationMessage>();
        String projectCode = messageInterface.projectCode();
        int idLength = messageInterface.getIdLength();
        if (idLength > 0 && idLength < 3 || idLength > 8) {
            messages.add(ValidationMessageFactory.createError((Element)messageInterface, "The length of the message id padding must be between 3 and 8. The value %d is invalid.", idLength));
        } else {
            IdLengthValidator idLengthValidator = this;
            synchronized (idLengthValidator) {
                if (this.lengths.containsKey(projectCode)) {
                    int len = this.lengths.get(projectCode);
                    if (len != idLength) {
                        messages.add(ValidationMessageFactory.createError((Element)messageInterface, "A length of %d was already used for project code '%s'.", len, projectCode));
                    }
                } else {
                    this.lengths.put(projectCode, idLength);
                }
            }
        }
        return messages;
    }
}

