/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ObserverMethod;
import jakarta.enterprise.inject.spi.ProcessObserverMethod;
import jakarta.enterprise.inject.spi.configurator.ObserverMethodConfigurator;
import java.lang.reflect.Type;
import org.jboss.weld.bootstrap.events.AbstractDefinitionContainerEvent;
import org.jboss.weld.bootstrap.events.configurator.ObserverMethodConfiguratorImpl;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.Preconditions;

public class ProcessObserverMethodImpl<T, X>
extends AbstractDefinitionContainerEvent
implements ProcessObserverMethod<T, X> {
    private final AnnotatedMethod<X> beanMethod;
    private final ObserverMethod<T> initialObserverMethod;
    private ObserverMethodConfiguratorImpl<T> configurator;
    protected ObserverMethod<T> observerMethod;
    protected boolean vetoed;
    private boolean observerMethodSet;

    public static <T, X> ObserverMethod<T> fire(BeanManagerImpl beanManager, AnnotatedMethod<X> beanMethod, ObserverMethod<T> observerMethod) {
        return ProcessObserverMethodImpl.fire(new ProcessObserverMethodImpl<T, X>(beanManager, beanMethod, observerMethod));
    }

    protected static <T, X> ObserverMethod<T> fire(ProcessObserverMethodImpl<T, X> event) {
        event.fire();
        if (event.vetoed) {
            return null;
        }
        return event.observerMethod;
    }

    ProcessObserverMethodImpl(BeanManagerImpl beanManager, AnnotatedMethod<X> beanMethod, ObserverMethod<T> observerMethod) {
        this(beanManager, beanMethod, observerMethod, ProcessObserverMethod.class);
    }

    ProcessObserverMethodImpl(BeanManagerImpl beanManager, AnnotatedMethod<X> beanMethod, ObserverMethod<T> observerMethod, Class<? extends ProcessObserverMethod> rawType) {
        super(beanManager, rawType, new Type[]{observerMethod.getObservedType(), observerMethod.getBeanClass()});
        this.beanMethod = beanMethod;
        this.initialObserverMethod = observerMethod;
        this.observerMethod = observerMethod;
    }

    @Override
    public AnnotatedMethod<X> getAnnotatedMethod() {
        this.checkWithinObserverNotification();
        return this.beanMethod;
    }

    @Override
    public ObserverMethod<T> getObserverMethod() {
        this.checkWithinObserverNotification();
        return this.observerMethod;
    }

    @Override
    public void setObserverMethod(ObserverMethod<T> observerMethod) {
        if (this.configurator != null) {
            throw BootstrapLogger.LOG.configuratorAndSetMethodBothCalled(ProcessObserverMethod.class.getSimpleName(), this.getReceiver());
        }
        Preconditions.checkArgumentNotNull(observerMethod, "observerMethod");
        this.checkWithinObserverNotification();
        this.replaceObserverMethod(observerMethod);
        this.observerMethodSet = true;
    }

    @Override
    public ObserverMethodConfigurator<T> configureObserverMethod() {
        if (this.observerMethodSet) {
            throw BootstrapLogger.LOG.configuratorAndSetMethodBothCalled(ProcessObserverMethod.class.getSimpleName(), this.getReceiver());
        }
        this.checkWithinObserverNotification();
        if (this.configurator == null) {
            this.configurator = new ObserverMethodConfiguratorImpl<T>(this.observerMethod, this.getReceiver());
        }
        BootstrapLogger.LOG.configureObserverMethodCalled(this.getReceiver(), this.observerMethod);
        return this.configurator;
    }

    @Override
    public void veto() {
        this.checkWithinObserverNotification();
        this.vetoed = true;
    }

    public boolean isDirty() {
        return this.observerMethod != this.initialObserverMethod;
    }

    @Override
    public void postNotify(Extension extension) {
        super.postNotify(extension);
        if (this.configurator != null) {
            this.replaceObserverMethod((ObserverMethod<T>)this.configurator.complete());
            this.configurator = null;
        }
        this.observerMethodSet = false;
    }

    private void replaceObserverMethod(ObserverMethod<T> observerMethod) {
        Observers.validateObserverMethod(observerMethod, this.getBeanManager(), this.initialObserverMethod);
        this.observerMethod = observerMethod;
    }
}

