/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.servermgmt.cli.MonitorTask;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.main.jdke.i18n.LocalStringsImpl;
import org.jvnet.hk2.annotations.Service;

@Service(name="monitor")
@PerLookup
public class MonitorCommand
extends CLICommand {
    @Param(optional=true, defaultValue="30")
    private int interval = 30;
    @Param
    private String type;
    @Param(optional=true)
    private String filter;
    @Param(optional=true)
    private File fileName;
    @Param(primary=true, optional=true)
    private String target;
    private static final LocalStringsImpl strings = new LocalStringsImpl(MonitorCommand.class);

    protected int executeCommand() throws CommandException, CommandValidationException {
        Timer timer = new Timer();
        try {
            MonitorTask monitorTask = new MonitorTask(timer, this.getRemoteArgs(), this.programOpts, this.env, this.type, this.filter, this.fileName);
            timer.scheduleAtFixedRate((TimerTask)monitorTask, 0L, (long)this.interval * 1000L);
            boolean done = false;
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset()));
            while (!done) {
                String str = "";
                if (monitorTask.allOK == null) {
                    str = "";
                } else if (!monitorTask.allOK.booleanValue()) {
                    str = "Q";
                } else if (System.in.available() > 0) {
                    str = in.readLine();
                }
                if (str == null || str.equals("q") || str.equals("Q")) {
                    timer.cancel();
                    done = true;
                    String exceptionMessage = monitorTask.getExceptionMessage();
                    if (exceptionMessage == null) continue;
                    throw new CommandException(exceptionMessage);
                }
                if (!str.equals("h") && !str.equals("H")) continue;
                monitorTask.displayDetails();
            }
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            timer.cancel();
            throw new CommandException(strings.get("monitorCommand.errorRemote", new Object[]{e.getMessage()}));
        }
        return 0;
    }

    private String[] getRemoteArgs() {
        ArrayList<String> list = new ArrayList<String>(5);
        list.add("monitor");
        if (MonitorCommand.ok((String)this.type)) {
            list.add("--type");
            list.add(this.type);
        }
        if (MonitorCommand.ok((String)this.filter)) {
            list.add("--filter");
            list.add(this.filter);
        }
        return list.toArray(new String[list.size()]);
    }
}

