/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.boot.embedded;

import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.Main;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.module.common_impl.AbstractFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;
import org.glassfish.embeddable.GlassFishVariable;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.DuplicatePostProcessor;
import org.glassfish.main.boot.embedded.AutoDisposableGlassFish;
import org.glassfish.main.boot.embedded.EmbeddedInhabitantsParser;
import org.glassfish.main.boot.embedded.JarUtil;
import org.glassfish.main.boot.log.LogFacade;
import org.glassfish.main.jdke.props.SystemProperties;

class EmbeddedGlassFishRuntime
extends GlassFishRuntime {
    private static final Logger LOG = LogFacade.BOOTSTRAP_LOGGER;
    private final Map<String, GlassFish> glassFishInstances = new ConcurrentHashMap<String, GlassFish>();
    private final Main main;

    EmbeddedGlassFishRuntime(Main main) {
        this.main = main;
    }

    public synchronized GlassFish newGlassFish(GlassFishProperties glassFishProperties) throws GlassFishException {
        try {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)glassFishProperties.getProperties());
            GlassFishProperties gfProps = new GlassFishProperties(properties);
            this.setEnv(gfProps);
            StartupContext startupContext = new StartupContext(gfProps.getProperties());
            ModulesRegistry modulesRegistry = AbstractFactory.getInstance().createModulesRegistry();
            ServiceLocator serviceLocator = this.main.createServiceLocator(modulesRegistry, startupContext, List.of(new EmbeddedInhabitantsParser(), new DuplicatePostProcessor()), null);
            ModuleStartup gfKernel = this.main.findStartupService(modulesRegistry, serviceLocator, null, startupContext);
            Consumer<GlassFish> onDispose = gf -> this.glassFishInstances.remove(gfProps.getInstanceRoot());
            AutoDisposableGlassFish glassFish = new AutoDisposableGlassFish(gfKernel, serviceLocator, gfProps, onDispose);
            this.glassFishInstances.put(gfProps.getInstanceRoot(), glassFish);
            return glassFish;
        }
        catch (GlassFishException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GlassFishException((Throwable)e);
        }
    }

    public synchronized void shutdown() throws GlassFishException {
        for (GlassFish glassFish : this.glassFishInstances.values()) {
            try {
                glassFish.dispose();
            }
            catch (IllegalStateException ex) {
                LOG.log(Level.FINER, "GlassFish dispose failed: " + ex.getMessage());
            }
        }
        this.glassFishInstances.clear();
        try {
            EmbeddedGlassFishRuntime.shutdownInternal();
        }
        catch (GlassFishException ex) {
            LOG.log(Level.WARNING, "NCLS-BOOTSTRAP-00039", ex.getMessage());
        }
    }

    private void setEnv(GlassFishProperties gfProps) throws Exception {
        String instanceRootValue = gfProps.getInstanceRoot();
        if (instanceRootValue == null) {
            instanceRootValue = this.createTempInstanceRoot(gfProps);
            gfProps.setInstanceRoot(instanceRootValue);
        }
        File instanceRoot = new File(instanceRootValue);
        SystemProperties.setProperty((String)GlassFishVariable.INSTANCE_ROOT.getSystemPropertyName(), (String)instanceRoot.getAbsolutePath(), (boolean)true);
        SystemProperties.setProperty((String)"com.sun.aas.instanceRootURI", (String)instanceRoot.toURI().toString(), (boolean)true);
        String installRootValue = System.getProperty("org.glassfish.embeddable.installRoot");
        if (installRootValue == null) {
            installRootValue = instanceRoot.getAbsolutePath();
            gfProps.setProperty("-type", "EMBEDDED");
            JarUtil.extractRars(installRootValue);
        }
        JarUtil.setEnv(installRootValue);
        File installRoot = new File(installRootValue);
        SystemProperties.setProperty((String)GlassFishVariable.INSTALL_ROOT.getSystemPropertyName(), (String)installRoot.getAbsolutePath(), (boolean)true);
        SystemProperties.setProperty((String)"com.sun.aas.installRootURI", (String)installRoot.toURI().toString(), (boolean)true);
        gfProps.setProperty(GlassFishVariable.INSTALL_ROOT.getPropertyName(), installRoot.getAbsolutePath());
        gfProps.setProperty("com.sun.aas.installRootURI", installRoot.toURI().toString());
    }

    private String createTempInstanceRoot(GlassFishProperties gfProps) throws Exception {
        String tmpDir = gfProps.getProperties().getProperty("glassfish.embedded.tmpdir");
        if (tmpDir == null) {
            tmpDir = System.getProperty("glassfish.embedded.tmpdir", System.getProperty("java.io.tmpdir"));
        } else {
            new File(tmpDir).mkdirs();
        }
        File instanceRoot = File.createTempFile("gfembed", "tmp", new File(tmpDir));
        if (!instanceRoot.delete() || !instanceRoot.mkdir()) {
            throw new Exception("cannot create directory: " + instanceRoot.getAbsolutePath());
        }
        try {
            String[] configFiles = new String[]{"config/keyfile", "config/server.policy", "config/login.conf", "config/admin-keyfile", "org/glassfish/web/embed/default-web.xml", "org/glassfish/embed/domain.xml"};
            File instanceConfigDir = new File(instanceRoot, "config");
            instanceConfigDir.mkdirs();
            new File(instanceRoot, "docroot").mkdirs();
            ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
            for (String configFile : configFiles) {
                EmbeddedGlassFishRuntime.copy(cl.getResource(configFile), new File(instanceConfigDir, configFile.substring(configFile.lastIndexOf(47) + 1)), false);
            }
            URI configFileURI = gfProps.getConfigFileURI();
            if (configFileURI != null) {
                EmbeddedGlassFishRuntime.copy(configFileURI.toURL(), new File(instanceConfigDir, "domain.xml"), true);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to create instanceRoot", ex);
        }
        String autoDelete = gfProps.getProperties().getProperty("org.glassfish.embeddable.autoDelete", "true");
        gfProps.setProperty("org.glassfish.embeddable.autoDelete", autoDelete);
        return instanceRoot.getAbsolutePath();
    }

    private static void copy(URL url, File destFile, boolean overwrite) {
        block14: {
            if (url == null || destFile == null) {
                return;
            }
            try {
                if (destFile.exists() && !overwrite || destFile.toURI().equals(url.toURI())) break block14;
                destFile.getParentFile().mkdirs();
                try (InputStream in = url.openStream();
                     FileOutputStream out = new FileOutputStream(destFile);){
                    ReadableByteChannel inChannel = Channels.newChannel(in);
                    FileChannel outChannel = out.getChannel();
                    outChannel.transferFrom(inChannel, 0L, in.available());
                }
                LOG.log(Level.FINER, () -> "Copied " + String.valueOf(url) + " to " + String.valueOf(destFile));
            }
            catch (Exception ex) {
                LOG.log(Level.FINER, ex, () -> "Failed to copy " + String.valueOf(url) + " to " + String.valueOf(destFile));
            }
        }
    }
}

