/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.coordination;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.persistence.exceptions.CommunicationException;
import org.eclipse.persistence.exceptions.RemoteCommandManagerException;
import org.eclipse.persistence.internal.sessions.coordination.RemoteConnection;
import org.eclipse.persistence.sessions.coordination.Command;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;

public class CommandPropagator
implements Runnable {
    protected RemoteCommandManager rcm;
    protected Command command;
    protected byte[] commandBytes;
    protected RemoteConnection connection;

    public CommandPropagator(RemoteCommandManager rcm, Command command, byte[] commandBytes) {
        this.rcm = rcm;
        this.command = command;
        this.commandBytes = commandBytes;
    }

    public CommandPropagator(RemoteCommandManager rcm, Command command, byte[] commandBytes, RemoteConnection connection) {
        this(rcm, command, commandBytes);
        this.connection = connection;
    }

    protected RemoteCommandManager getRemoteCommandManager() {
        return this.rcm;
    }

    protected Command getCommand() {
        return this.command;
    }

    public void synchronousPropagateCommand() {
        this.rcm.logDebug("sync_propagation", null);
        for (RemoteConnection this.connection : this.rcm.getTransportManager().getConnectionsToExternalServicesForCommandPropagation().values()) {
            this.propagateCommand(this.connection);
        }
    }

    public void asynchronousPropagateCommand() {
        this.rcm.logDebug("async_propagation", null);
        this.rcm.getServerPlatform().launchContainerRunnable(this);
    }

    public void propagateCommand(RemoteConnection connection) {
        Object[] arguments = new Object[]{this.command.getClass().getName(), connection.getServiceId()};
        this.rcm.logDebug("propagate_command_to", arguments);
        try {
            Object result = null;
            result = this.commandBytes != null ? connection.executeCommand(this.commandBytes) : connection.executeCommand(this.command);
            if (result != null) {
                this.handleExceptionFromRemoteExecution(connection, (String)result);
            }
        }
        catch (CommunicationException comEx) {
            this.handleCommunicationException(connection, comEx);
        }
    }

    public void handleExceptionFromRemoteExecution(RemoteConnection conn, String exString) {
        Object[] args = new Object[]{conn.getServiceId(), exString};
        this.rcm.logWarning("failed_command_propagation", args);
        RemoteCommandManagerException rcmException = RemoteCommandManagerException.unableToPropagateCommand(conn.toString(), new Exception(exString));
        this.rcm.handleException(rcmException);
    }

    public void handleCommunicationException(RemoteConnection conn, CommunicationException comEx) {
        block4: {
            if (this.rcm.getTransportManager().shouldRemoveConnectionOnError()) {
                Object[] args = new Object[]{conn.getServiceId(), comEx.getInternalException()};
                this.rcm.logWarning("drop_connection_on_error", args);
                this.rcm.getTransportManager().removeConnectionToExternalService(conn);
            } else {
                Object[] args = new Object[]{conn.getServiceId(), comEx};
                this.rcm.logWarning("failed_command_propagation", args);
                RemoteCommandManagerException rcmException = RemoteCommandManagerException.unableToPropagateCommand(conn.toString(), comEx.getInternalException());
                try {
                    this.rcm.handleException(rcmException);
                }
                catch (RuntimeException ex) {
                    if (this.connection != null) break block4;
                    throw ex;
                }
            }
        }
    }

    @Override
    public void run() {
        if (this.connection != null) {
            this.rcm.getCommandProcessor().startOperationProfile("Timer:CacheCoordination");
            try {
                this.propagateCommand(this.connection);
            }
            finally {
                this.rcm.getCommandProcessor().endOperationProfile("Timer:CacheCoordination");
            }
        } else {
            Map<String, RemoteConnection> mapConnections = this.rcm.getTransportManager().getConnectionsToExternalServicesForCommandPropagation();
            Iterator<RemoteConnection> iterator = mapConnections.values().iterator();
            if (mapConnections.size() == 1) {
                this.connection = iterator.next();
                this.propagateCommand(this.connection);
            } else {
                while (iterator.hasNext()) {
                    RemoteConnection remoteConnection = iterator.next();
                    CommandPropagator propagator = new CommandPropagator(this.rcm, this.command, this.commandBytes, remoteConnection);
                    this.rcm.getServerPlatform().launchContainerRunnable(propagator);
                }
            }
        }
    }
}

