/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.signedcontent;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.LambdaMetafactory;
import java.security.CodeSigner;
import java.security.Timestamp;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.jar.JarInputStream;
import java.util.zip.ZipFile;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.internal.signedcontent.BundleToJarInputStream;
import org.eclipse.osgi.internal.signedcontent.SignedBundleHook;
import org.eclipse.osgi.signedcontent.InvalidContentException;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentEntry;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.eclipse.osgi.storage.bundlefile.DirBundleFile;
import org.eclipse.osgi.storage.bundlefile.ZipBundleFile;

public class SignedContentFromBundleFile
implements SignedContent {
    private final List<CodeSignerInfo> signerInfos = new ArrayList<CodeSignerInfo>();
    private final Map<String, SignedContentEntry> signedEntries;

    public SignedContentFromBundleFile(BundleFile bundleFile) throws IOException {
        this.signedEntries = SignedContentFromBundleFile.getSignedEntries(() -> {
            try {
                return SignedContentFromBundleFile.getJarInputStream(bundleFile);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }, () -> bundleFile, this.signerInfos);
    }

    public SignedContentFromBundleFile(File bundleFile, Debug debug) throws IOException {
        DirBundleFile tmpDirBundleFile = null;
        if (bundleFile.isDirectory()) {
            try {
                tmpDirBundleFile = new DirBundleFile(bundleFile, false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        DirBundleFile dirBundleFile = tmpDirBundleFile;
        this.signedEntries = SignedContentFromBundleFile.getSignedEntries(() -> {
            try {
                if (dirBundleFile != null) {
                    return SignedContentFromBundleFile.getJarInputStream(dirBundleFile);
                }
                return new FileInputStream(bundleFile);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }, () -> {
            try {
                if (dirBundleFile != null) {
                    return dirBundleFile;
                }
                ZipFile temp = SignedBundleHook.secureAction.getZipFile(bundleFile, false);
                temp.close();
                return new ZipBundleFile(bundleFile, null, null, debug, false);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }, this.signerInfos);
    }

    /*
     * Unable to fully structure code
     */
    private static Map<String, SignedContentEntry> getSignedEntries(Supplier<InputStream> input, Supplier<BundleFile> bundleFile, List<CodeSignerInfo> signerInfos) throws IOException {
        block19: {
            codeSigners = new HashMap<CodeSigner, CodeSignerInfo>();
            signedEntries = new LinkedHashMap<String, SignedContentEntry>();
            try {
                var5_5 = null;
                var6_9 = null;
                try {
                    jarInput = new JarInputStream(input.get());
                    try {
                        entry = jarInput.getNextJarEntry();
                        while (entry != null) {
                            try {
                                drain = new byte[4096];
                                while (jarInput.read(drain, 0, drain.length) != -1) {
                                }
                                signers = entry.getCodeSigners();
                                if (signers != null) {
                                    entryInfos = new ArrayList<CodeSignerInfo>(signers.length);
                                    var14_21 = signers;
                                    var13_20 = signers.length;
                                    var12_19 = 0;
                                    while (var12_19 < var13_20) {
                                        codeSigner = var14_21[var12_19];
                                        info = codeSigners.computeIfAbsent(codeSigner, (Function<CodeSigner, CodeSignerInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(java.security.CodeSigner ), (Ljava/security/CodeSigner;)Lorg/eclipse/osgi/internal/signedcontent/SignedContentFromBundleFile$CodeSignerInfo;)());
                                        entryInfos.add(info);
                                        ++var12_19;
                                    }
                                    signedEntry = new CodeSignerEntry(entryInfos, entry.getName());
                                    signedEntries.put(entry.getName(), signedEntry);
                                }
                            }
                            catch (IOException | SecurityException e) {
                                signedEntries.put(entry.getName(), new CorruptEntry(new InvalidContentException(entry.getName(), e), entry.getName()));
                            }
                            entry = jarInput.getNextJarEntry();
                        }
                        break block19;
                    }
                    finally {
                        if (jarInput != null) {
                            jarInput.close();
                        }
                    }
                }
                catch (Throwable var6_10) {
                    if (var5_5 == null) {
                        var5_5 = var6_10;
                    } else if (var5_5 != var6_10) {
                        var5_5.addSuppressed(var6_10);
                    }
                    throw var5_5;
                }
            }
            catch (SecurityException e) {
                paths = bundleFile.get().getEntryPaths("", true);
                ** while (paths.hasMoreElements())
            }
lbl-1000:
            // 1 sources

            {
                path = paths.nextElement();
                if (path.endsWith("/") || signedEntries.containsKey(path)) continue;
                signedEntries.put(path, new CorruptEntry(new InvalidContentException(path, e), path));
                continue;
lbl57:
                // 1 sources

                break block19;
            }
            catch (UncheckedIOException e) {
                throw e.getCause();
            }
        }
        signerInfos.addAll(codeSigners.values());
        return signedEntries;
    }

    private static InputStream getJarInputStream(BundleFile bundleFile) throws IOException {
        File f = bundleFile.getBaseFile();
        if (f == null || f.isDirectory()) {
            return new BundleToJarInputStream(bundleFile);
        }
        return new FileInputStream(f);
    }

    @Override
    public SignedContentEntry[] getSignedEntries() {
        return this.signedEntries.values().toArray(new SignedContentEntry[0]);
    }

    @Override
    public SignedContentEntry getSignedEntry(String name) {
        return this.signedEntries.get(name);
    }

    @Override
    public SignerInfo[] getSignerInfos() {
        return this.signerInfos.toArray(new SignerInfo[0]);
    }

    @Override
    public boolean isSigned() {
        return !this.signerInfos.isEmpty();
    }

    @Override
    public Date getSigningTime(SignerInfo signerInfo) {
        TimestampSignerInfo tsInfo;
        if (signerInfo instanceof CodeSignerInfo && (tsInfo = ((CodeSignerInfo)signerInfo).getTSASignerInfo()) != null) {
            return tsInfo.getTimestamp();
        }
        return null;
    }

    @Override
    public SignerInfo getTSASignerInfo(SignerInfo signerInfo) {
        if (signerInfo instanceof CodeSignerInfo) {
            return ((CodeSignerInfo)signerInfo).getTSASignerInfo();
        }
        return null;
    }

    @Override
    public void checkValidity(SignerInfo signerInfo) throws CertificateExpiredException, CertificateNotYetValidException {
        Certificate[] certs;
        Date signingTime = this.getSigningTime(signerInfo);
        Certificate[] certificateArray = certs = signerInfo.getCertificateChain();
        int n = certs.length;
        int n2 = 0;
        while (n2 < n) {
            Certificate cert = certificateArray[n2];
            if (cert instanceof X509Certificate) {
                if (signingTime == null) {
                    ((X509Certificate)cert).checkValidity();
                } else {
                    ((X509Certificate)cert).checkValidity(signingTime);
                }
            }
            ++n2;
        }
    }

    static abstract class BaseSignerInfo
    implements SignerInfo {
        private volatile Certificate trustAnchor = null;

        BaseSignerInfo() {
        }

        @Override
        public Certificate getTrustAnchor() {
            return this.trustAnchor;
        }

        @Override
        public boolean isTrusted() {
            return this.trustAnchor != null;
        }

        @Override
        @Deprecated
        public String getMessageDigestAlgorithm() {
            return "unknown";
        }

        void setTrustAnchor(Certificate anchor) {
            this.trustAnchor = anchor;
        }
    }

    static class CodeSignerEntry
    implements SignedContentEntry {
        private final String name;
        private final List<CodeSignerInfo> signerInfos;

        public CodeSignerEntry(List<CodeSignerInfo> signerInfos, String name) {
            this.name = name;
            this.signerInfos = signerInfos;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public SignerInfo[] getSignerInfos() {
            return this.signerInfos.toArray(new SignerInfo[0]);
        }

        @Override
        public boolean isSigned() {
            return !this.signerInfos.isEmpty();
        }

        @Override
        public void verify() throws IOException, InvalidContentException {
        }
    }

    static class CodeSignerInfo
    extends BaseSignerInfo {
        private final CodeSigner codeSigner;
        private final TimestampSignerInfo timestamp;

        public CodeSignerInfo(CodeSigner codeSigner) {
            this.codeSigner = codeSigner;
            Timestamp ts = codeSigner.getTimestamp();
            this.timestamp = ts == null ? null : new TimestampSignerInfo(ts);
        }

        @Override
        public Certificate[] getCertificateChain() {
            return this.codeSigner.getSignerCertPath().getCertificates().toArray(new Certificate[0]);
        }

        TimestampSignerInfo getTSASignerInfo() {
            return this.timestamp;
        }
    }

    static class CorruptEntry
    implements SignedContentEntry {
        final InvalidContentException verifyError;
        final String name;

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public SignerInfo[] getSignerInfos() {
            return new SignerInfo[0];
        }

        @Override
        public boolean isSigned() {
            return false;
        }

        @Override
        public void verify() throws IOException, InvalidContentException {
            throw this.verifyError;
        }

        public CorruptEntry(InvalidContentException verifyError, String name) {
            this.verifyError = verifyError;
            this.name = name;
        }
    }

    static class TimestampSignerInfo
    extends BaseSignerInfo {
        private final Timestamp timestamp;

        public TimestampSignerInfo(Timestamp timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public Certificate[] getCertificateChain() {
            return this.timestamp.getSignerCertPath().getCertificates().toArray(new Certificate[0]);
        }

        Date getTimestamp() {
            return this.timestamp.getTimestamp();
        }
    }
}

