/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api.jcajce;

import java.io.InputStream;
import java.security.Provider;
import java.security.SecureRandom;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptorBuilderProvider;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptorFactory;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilderProvider;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.PGPKeyPairGeneratorProvider;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcaAEADSecretKeyEncryptorFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcaCFBSecretKeyEncryptorFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyPairGeneratorProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcePBEDataDecryptorFactoryBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JceSessionKeyDataDecryptorFactoryBuilder;

public class JcaOpenPGPImplementation
extends OpenPGPImplementation {
    private final Provider provider;
    private final SecureRandom secureRandom;

    public JcaOpenPGPImplementation() {
        this((Provider)new BouncyCastleProvider(), CryptoServicesRegistrar.getSecureRandom());
    }

    public JcaOpenPGPImplementation(Provider provider, SecureRandom secureRandom) {
        this.provider = provider;
        this.secureRandom = secureRandom;
    }

    @Override
    public PGPObjectFactory pgpObjectFactory(InputStream inputStream) {
        return new JcaPGPObjectFactory(inputStream).setThrowForUnknownCriticalPackets(true);
    }

    @Override
    public PGPContentVerifierBuilderProvider pgpContentVerifierBuilderProvider() {
        JcaPGPContentVerifierBuilderProvider jcaPGPContentVerifierBuilderProvider = new JcaPGPContentVerifierBuilderProvider();
        jcaPGPContentVerifierBuilderProvider.setProvider(this.provider);
        return jcaPGPContentVerifierBuilderProvider;
    }

    @Override
    public PBESecretKeyDecryptorBuilderProvider pbeSecretKeyDecryptorBuilderProvider() {
        JcaPGPDigestCalculatorProviderBuilder jcaPGPDigestCalculatorProviderBuilder = new JcaPGPDigestCalculatorProviderBuilder();
        jcaPGPDigestCalculatorProviderBuilder.setProvider(this.provider);
        JcePBESecretKeyDecryptorBuilderProvider jcePBESecretKeyDecryptorBuilderProvider = new JcePBESecretKeyDecryptorBuilderProvider(jcaPGPDigestCalculatorProviderBuilder).setProvider(this.provider);
        return jcePBESecretKeyDecryptorBuilderProvider;
    }

    @Override
    public PGPDataEncryptorBuilder pgpDataEncryptorBuilder(int n) {
        JcePGPDataEncryptorBuilder jcePGPDataEncryptorBuilder = new JcePGPDataEncryptorBuilder(n);
        jcePGPDataEncryptorBuilder.setProvider(this.provider);
        jcePGPDataEncryptorBuilder.setSecureRandom(this.secureRandom);
        return jcePGPDataEncryptorBuilder;
    }

    @Override
    public PublicKeyKeyEncryptionMethodGenerator publicKeyKeyEncryptionMethodGenerator(PGPPublicKey pGPPublicKey) {
        JcePublicKeyKeyEncryptionMethodGenerator jcePublicKeyKeyEncryptionMethodGenerator = new JcePublicKeyKeyEncryptionMethodGenerator(pGPPublicKey);
        jcePublicKeyKeyEncryptionMethodGenerator.setProvider(this.provider);
        jcePublicKeyKeyEncryptionMethodGenerator.setSecureRandom(this.secureRandom);
        return jcePublicKeyKeyEncryptionMethodGenerator;
    }

    @Override
    public PBEKeyEncryptionMethodGenerator pbeKeyEncryptionMethodGenerator(char[] cArray) {
        JcePBEKeyEncryptionMethodGenerator jcePBEKeyEncryptionMethodGenerator = new JcePBEKeyEncryptionMethodGenerator(cArray);
        jcePBEKeyEncryptionMethodGenerator.setProvider(this.provider);
        jcePBEKeyEncryptionMethodGenerator.setSecureRandom(this.secureRandom);
        return jcePBEKeyEncryptionMethodGenerator;
    }

    @Override
    public PBEKeyEncryptionMethodGenerator pbeKeyEncryptionMethodGenerator(char[] cArray, S2K.Argon2Params argon2Params) {
        JcePBEKeyEncryptionMethodGenerator jcePBEKeyEncryptionMethodGenerator = new JcePBEKeyEncryptionMethodGenerator(cArray, argon2Params);
        jcePBEKeyEncryptionMethodGenerator.setProvider(this.provider);
        jcePBEKeyEncryptionMethodGenerator.setSecureRandom(this.secureRandom);
        return jcePBEKeyEncryptionMethodGenerator;
    }

    @Override
    public PGPContentSignerBuilder pgpContentSignerBuilder(int n, int n2) {
        JcaPGPContentSignerBuilder jcaPGPContentSignerBuilder = new JcaPGPContentSignerBuilder(n, n2);
        jcaPGPContentSignerBuilder.setProvider(this.provider);
        jcaPGPContentSignerBuilder.setDigestProvider(this.provider);
        jcaPGPContentSignerBuilder.setSecureRandom(this.secureRandom);
        return jcaPGPContentSignerBuilder;
    }

    @Override
    public PBEDataDecryptorFactory pbeDataDecryptorFactory(char[] cArray) throws PGPException {
        return new JcePBEDataDecryptorFactoryBuilder(this.pgpDigestCalculatorProvider()).setProvider(this.provider).build(cArray);
    }

    @Override
    public SessionKeyDataDecryptorFactory sessionKeyDataDecryptorFactory(PGPSessionKey pGPSessionKey) {
        return new JceSessionKeyDataDecryptorFactoryBuilder().setProvider(this.provider).build(pGPSessionKey);
    }

    @Override
    public PublicKeyDataDecryptorFactory publicKeyDataDecryptorFactory(PGPPrivateKey pGPPrivateKey) {
        return new JcePublicKeyDataDecryptorFactoryBuilder().setProvider(this.provider).setContentProvider(this.provider).build(pGPPrivateKey);
    }

    @Override
    public PGPDigestCalculatorProvider pgpDigestCalculatorProvider() throws PGPException {
        return new JcaPGPDigestCalculatorProviderBuilder().setProvider(this.provider).build();
    }

    @Override
    public PGPKeyPairGeneratorProvider pgpKeyPairGeneratorProvider() {
        return new JcaPGPKeyPairGeneratorProvider().setProvider(this.provider).setSecureRandom(this.secureRandom);
    }

    @Override
    public PGPContentSignerBuilderProvider pgpContentSignerBuilderProvider(int n) {
        return new JcaPGPContentSignerBuilderProvider(n).setSecurityProvider(this.provider).setDigestProvider(this.provider).setSecureRandom(this.secureRandom);
    }

    @Override
    public KeyFingerPrintCalculator keyFingerPrintCalculator() {
        return new JcaKeyFingerprintCalculator().setProvider(this.provider);
    }

    @Override
    public PBESecretKeyEncryptorFactory pbeSecretKeyEncryptorFactory(boolean bl) throws PGPException {
        if (bl) {
            return new JcaAEADSecretKeyEncryptorFactory().setProvider(this.provider);
        }
        return new JcaCFBSecretKeyEncryptorFactory(7, 96).setProvider(this.provider);
    }

    @Override
    public PBESecretKeyEncryptorFactory pbeSecretKeyEncryptorFactory(boolean bl, int n, int n2) throws PGPException {
        if (bl) {
            return new JcaAEADSecretKeyEncryptorFactory().setProvider(this.provider);
        }
        return new JcaCFBSecretKeyEncryptorFactory(n, n2).setProvider(this.provider);
    }
}

