/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.frameworkadmin.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

public class Utils {
    private static final String FILE_SCHEME = "file";
    private static final String PATH_SEP = "/";

    public static Properties appendProperties(Properties to, Properties from) {
        if (from != null) {
            if (to == null) {
                to = new Properties();
            }
            Enumeration<Object> enumeration = from.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                to.setProperty(key, from.getProperty(key));
            }
        }
        return to;
    }

    /*
     * Loose catch block
     */
    private static Dictionary<String, String> basicLoadManifest(File bundleLocation) {
        Map manifest;
        ZipFile jarFile;
        InputStream manifestStream;
        block43: {
            block42: {
                manifestStream = null;
                jarFile = null;
                try {
                    if (bundleLocation.isFile()) {
                        jarFile = new ZipFile(bundleLocation, 1);
                        ZipEntry manifestEntry = jarFile.getEntry("META-INF/MANIFEST.MF");
                        if (manifestEntry != null) {
                            manifestStream = jarFile.getInputStream(manifestEntry);
                        }
                    } else {
                        File bundleManifestFile = new File(bundleLocation, "META-INF/MANIFEST.MF");
                        if (bundleManifestFile.exists()) {
                            manifestStream = new BufferedInputStream(new FileInputStream(new File(bundleLocation, "META-INF/MANIFEST.MF")));
                        }
                    }
                }
                catch (IOException bundleManifestFile) {
                    // empty catch block
                }
                if (manifestStream != null) break block42;
                {
                    catch (Throwable throwable) {
                        try {
                            if (manifestStream != null) {
                                manifestStream.close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            if (jarFile != null) {
                                jarFile.close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                try {
                    if (manifestStream != null) {
                        manifestStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
            manifest = ManifestElement.parseBundleManifest((InputStream)manifestStream, null);
            if (manifest.get("Bundle-SymbolicName") != null) break block43;
            try {
                if (manifestStream != null) {
                    manifestStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        Dictionary<String, String> dictionary = Utils.manifestToProperties(manifest);
        try {
            if (manifestStream != null) {
                manifestStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return dictionary;
        catch (IOException | BundleException ioe) {
            try {
                if (manifestStream != null) {
                    manifestStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
    }

    public static void checkAbsoluteDir(File file, String dirName) throws IllegalArgumentException {
        if (file == null) {
            throw new IllegalArgumentException(dirName + " is null");
        }
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException(dirName + " is not absolute path. file=" + file.getAbsolutePath());
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(dirName + " is not directory. file=" + file.getAbsolutePath());
        }
    }

    public static void checkAbsoluteFile(File file, String dirName) {
        if (file == null) {
            throw new IllegalArgumentException(dirName + " is null");
        }
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException(dirName + " is not absolute path. file=" + file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException(dirName + " is not file but directory");
        }
    }

    public static URL checkFullUrl(URL url, String urlName) throws IllegalArgumentException {
        if (url == null) {
            throw new IllegalArgumentException(urlName + " is null");
        }
        if (!url.getProtocol().endsWith(FILE_SCHEME)) {
            return url;
        }
        File file = new File(url.getFile());
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException(urlName + "(" + String.valueOf(url) + ") does not have absolute path");
        }
        if (file.getAbsolutePath().startsWith(PATH_SEP)) {
            return url;
        }
        try {
            return Utils.getUrl(FILE_SCHEME, null, PATH_SEP + file.getAbsolutePath());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(urlName + "(file:/" + file.getAbsolutePath() + ") is not fully quallified");
        }
    }

    public static boolean createParentDir(File file) {
        File parent = file.getParentFile();
        if (parent == null) {
            return false;
        }
        if (parent.exists()) {
            return true;
        }
        return parent.mkdirs();
    }

    public static BundleInfo[] getBundleInfosFromList(List<BundleInfo> list) {
        if (list == null) {
            return new BundleInfo[0];
        }
        BundleInfo[] ret = new BundleInfo[list.size()];
        list.toArray(ret);
        return ret;
    }

    public static String[] getClauses(String header) {
        StringTokenizer token = new StringTokenizer(header, ",");
        LinkedList<String> list = new LinkedList<String>();
        while (token.hasMoreTokens()) {
            list.add(token.nextToken());
        }
        String[] ret = new String[list.size()];
        list.toArray(ret);
        return ret;
    }

    public static String[] getClausesManifestMainAttributes(URI location, String name) {
        return Utils.getClauses(Utils.getManifestMainAttributes(location, name));
    }

    public static String getManifestMainAttributes(URI location, String name) {
        Dictionary<String, String> manifest = Utils.getOSGiManifest(location);
        if (manifest == null) {
            throw new RuntimeException("Unable to locate bundle manifest: " + String.valueOf(location));
        }
        return manifest.get(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Dictionary<String, String> getOSGiManifest(URI location) {
        if (location == null) {
            return null;
        }
        if (FILE_SCHEME.equals(location.getScheme())) {
            return Utils.basicLoadManifest(URIUtil.toFile((URI)location));
        }
        try {
            URL url = new URL("jar:" + location.toString() + "!/");
            JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
            try {
                Throwable throwable = null;
                Object var4_7 = null;
                try (JarFile jar = jarConnection.getJarFile();){
                    ZipEntry entry = ((ZipFile)jar).getEntry("META-INF/MANIFEST.MF");
                    if (entry == null) {
                        return null;
                    }
                    Map manifest = ManifestElement.parseBundleManifest((InputStream)((ZipFile)jar).getInputStream(entry), null);
                    if (manifest.get("Bundle-SymbolicName") != null) return Utils.manifestToProperties(manifest);
                    return null;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            catch (BundleException e) {
                return null;
            }
        }
        catch (IOException e) {
            if (System.getProperty("osgi.debug") == null) return null;
            System.err.println("location=" + String.valueOf(location));
            e.printStackTrace();
            return null;
        }
    }

    public static String getPathFromClause(String clause) {
        if (clause == null) {
            return null;
        }
        if (clause.indexOf(";") != -1) {
            clause = clause.substring(0, clause.indexOf(";"));
        }
        return clause.trim();
    }

    public static String getRelativePath(File target, File from) {
        String targetPath = Utils.replaceAll(target.getAbsolutePath(), File.separator, PATH_SEP);
        String fromPath = Utils.replaceAll(from.getAbsolutePath(), File.separator, PATH_SEP);
        String[] targetTokens = Utils.getTokens(targetPath, PATH_SEP);
        String[] fromTokens = Utils.getTokens(fromPath, PATH_SEP);
        int index = -1;
        int i = 0;
        while (i < fromTokens.length) {
            if (!fromTokens[i].equals(targetTokens[i])) break;
            index = i++;
        }
        StringBuilder sb = new StringBuilder();
        int i2 = index + 1;
        while (i2 < fromTokens.length) {
            sb.append("../");
            ++i2;
        }
        i2 = index + 1;
        while (i2 < targetTokens.length) {
            if (i2 != targetTokens.length - 1) {
                sb.append(targetTokens[i2] + PATH_SEP);
            } else {
                sb.append(targetTokens[i2]);
            }
            ++i2;
        }
        return sb.toString();
    }

    public static File getSimpleDataFormattedFile(File file) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String date = df.format(new Date());
        Object filename = file.getName();
        int index = ((String)filename).lastIndexOf(".");
        filename = index != -1 ? ((String)filename).substring(0, index) + "." + date + "." + ((String)filename).substring(index + 1) : (String)filename + "." + date;
        File dest = new File(file.getParentFile(), (String)filename);
        return dest;
    }

    public static String[] getTokens(String msg, String delim) {
        return Utils.getTokens(msg, delim, false);
    }

    public static String[] getTokens(String msg, String delim, boolean returnDelims) {
        StringTokenizer targetST = new StringTokenizer(msg, delim, returnDelims);
        String[] tokens = new String[targetST.countTokens()];
        ArrayList<String> list = new ArrayList<String>(targetST.countTokens());
        while (targetST.hasMoreTokens()) {
            list.add(targetST.nextToken());
        }
        list.toArray(tokens);
        return tokens;
    }

    public static URL getUrl(String protocol, String host, String file) throws MalformedURLException {
        file = Utils.replaceAll(file, File.separator, PATH_SEP);
        return new URL(protocol, host, file);
    }

    public static URL getUrlInFull(String path, URL from) throws MalformedURLException {
        Utils.checkFullUrl(from, "from");
        path = Utils.replaceAll(path, File.separator, PATH_SEP);
        String fromSt = Utils.removeLastCh(from.toExternalForm(), '/');
        if (path.startsWith(PATH_SEP)) {
            String fileSt = from.getFile();
            return new URL(fromSt.substring(0, fromSt.lastIndexOf(fileSt) - 1) + path);
        }
        return new URL(fromSt + PATH_SEP + path);
    }

    private static Dictionary<String, String> manifestToProperties(Map<String, String> d) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        for (String key : d.keySet()) {
            ((Dictionary)result).put(key, d.get(key));
        }
        return result;
    }

    public static void printoutProperties(PrintStream ps, String name, Properties props) {
        if (props == null || props.size() == 0) {
            ps.println("Props(" + name + ") is empty");
            return;
        }
        ps.println("Props(" + name + ")=");
        Enumeration<Object> enumeration = props.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            ps.print("\tkey=" + key);
            ps.println("\tvalue=" + props.getProperty(key));
        }
    }

    public static String removeLastCh(String target, char ch) {
        while (target.charAt(target.length() - 1) == ch) {
            target = target.substring(0, target.length() - 1);
        }
        return target;
    }

    public static String replaceAll(String st, String oldSt, String newSt) {
        if (oldSt.equals(newSt)) {
            return st;
        }
        int index = -1;
        while ((index = ((String)st).indexOf(oldSt)) != -1) {
            st = ((String)st).substring(0, index) + newSt + ((String)st).substring(index + oldSt.length());
        }
        return st;
    }

    public static BundleInfo[] sortBundleInfos(BundleInfo[] bInfos, int initialBSL) {
        TreeMap<Integer, LinkedList<BundleInfo>> bslToList = new TreeMap<Integer, LinkedList<BundleInfo>>();
        BundleInfo[] bundleInfoArray = bInfos;
        int n = bInfos.length;
        int n2 = 0;
        while (n2 < n) {
            LinkedList<BundleInfo> list;
            BundleInfo bInfo = bundleInfoArray[n2];
            Integer sL = bInfo.getStartLevel();
            if (sL == -1) {
                sL = initialBSL;
            }
            if ((list = (LinkedList<BundleInfo>)bslToList.get(sL)) == null) {
                list = new LinkedList<BundleInfo>();
                bslToList.put(sL, list);
            }
            list.add(bInfo);
            ++n2;
        }
        LinkedList<BundleInfo> bundleInfoList = new LinkedList<BundleInfo>();
        for (Integer sL : bslToList.keySet()) {
            List list = (List)bslToList.get(sL);
            for (BundleInfo bInfo : list) {
                bundleInfoList.add(bInfo);
            }
        }
        return Utils.getBundleInfosFromList(bundleInfoList);
    }

    public static String toStringProperties(String name, Properties props) {
        if (props == null || props.size() == 0) {
            return "Props(" + name + ") is empty\n";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Props(" + name + ") is \n");
        Enumeration<Object> enumeration = props.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            sb.append("\tkey=" + key + "\tvalue=" + props.getProperty(key) + "\n");
        }
        return sb.toString();
    }
}

