/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.repository;

import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.repository.ArtifactManager;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.spi.AgentServiceName;
import org.eclipse.equinox.p2.core.spi.IAgentServiceFactory;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.osgi.service.component.annotations.Component;

@Component(service={IAgentServiceFactory.class})
@AgentServiceName(value=ArtifactManager.class)
public class DefaultArtifactManagerServiceFactory
implements IAgentServiceFactory {
    public Object createService(IProvisioningAgent agent) {
        return new DefaultArtifactManager(agent);
    }

    private static final class DefaultArtifactManager
    implements ArtifactManager {
        private final IProvisioningAgent agent;

        public DefaultArtifactManager(IProvisioningAgent agent) {
            this.agent = agent;
        }

        @Override
        public IStatus getArtifact(URI source, OutputStream target, IArtifactDescriptor descriptor, IProgressMonitor monitor) {
            Transport transport = (Transport)this.agent.getService(Transport.class);
            if (transport == null) {
                return Status.error((String)"No transport service found in agent");
            }
            return transport.downloadArtifact(source, target, descriptor, monitor);
        }
    }
}

