/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck.checks.confluence;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDFactory;
import com.github.javabdd.BDDVarSet;
import org.eclipse.escet.cif.bdd.spec.CifBddEdge;
import org.eclipse.escet.cif.bdd.spec.CifBddEdgeApplyDirection;
import org.eclipse.escet.cif.bdd.spec.CifBddSpec;
import org.eclipse.escet.cif.bdd.utils.BddUtils;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.common.java.Termination;

class EventPairData {
    final Event event1;
    final Event event2;
    final CifBddEdge edge1;
    final CifBddEdge edge2;
    final String evt1Name;
    final String evt2Name;
    final BDDFactory factory;
    private final BDD zeroToOldVarRelations;
    final BDDVarSet varSetOld;
    private BDD commonEnabledGuardsNoZero;
    private BDD commonEnabledGuardsWithZero;
    private BDD commonEnabledZeroStates;
    private BDD event1Done;
    private BDD event2Done;
    private BDD event12Done;
    private BDD event21Done;

    EventPairData(CifBddSpec cifBddSpec, Event event1, Event event2, CifBddEdge edge1, CifBddEdge edge2, String evt1Name, String evt2Name, BDD zeroToOldVarRelations) {
        this.event1 = event1;
        this.event2 = event2;
        this.edge1 = edge1;
        this.edge2 = edge2;
        this.evt1Name = evt1Name;
        this.evt2Name = evt2Name;
        this.factory = cifBddSpec.factory;
        this.zeroToOldVarRelations = zeroToOldVarRelations;
        this.varSetOld = cifBddSpec.varSetOld;
    }

    BDD getCommonEnabledGuardsNoZero() {
        if (this.commonEnabledGuardsNoZero == null) {
            this.commonEnabledGuardsNoZero = this.edge1.guard.and(this.edge2.guard);
        }
        return this.commonEnabledGuardsNoZero;
    }

    private BDD getCommonEnabledGuardsWithZero(Termination termination) {
        if (this.commonEnabledGuardsWithZero == null) {
            BDD commonEnabledGuardsNoZero = this.getCommonEnabledGuardsNoZero();
            termination.throwIfRequested();
            this.commonEnabledGuardsWithZero = this.zeroToOldVarRelations.and(commonEnabledGuardsNoZero);
        }
        return this.commonEnabledGuardsWithZero;
    }

    BDD getCommonEnabledZeroStates(Termination termination) {
        if (this.commonEnabledZeroStates == null) {
            BDD commonEnabledGuardsWithZero = this.getCommonEnabledGuardsWithZero(termination);
            termination.throwIfRequested();
            this.commonEnabledZeroStates = commonEnabledGuardsWithZero.exist(this.varSetOld);
        }
        return this.commonEnabledZeroStates;
    }

    BDD getEvent1Done(Termination termination) {
        if (this.event1Done == null) {
            BDD commonEnabledGuardsWithZero = this.getCommonEnabledGuardsWithZero(termination);
            termination.throwIfRequested();
            this.event1Done = this.edge1.apply(commonEnabledGuardsWithZero.id(), CifBddEdgeApplyDirection.FORWARD, null);
        }
        return this.event1Done;
    }

    BDD getEvent2Done(Termination termination) {
        if (this.event2Done == null) {
            BDD commonEnabledGuardsWithZero = this.getCommonEnabledGuardsWithZero(termination);
            termination.throwIfRequested();
            this.event2Done = this.edge2.apply(commonEnabledGuardsWithZero.id(), CifBddEdgeApplyDirection.FORWARD, null);
        }
        return this.event2Done;
    }

    BDD getEvent12Done(Termination termination) {
        if (this.event12Done == null) {
            BDD event1Done = this.getEvent1Done(termination);
            termination.throwIfRequested();
            BDD event1Enabled2 = event1Done.and(this.edge2.guard);
            termination.throwIfRequested();
            this.event12Done = event1Enabled2.isZero() ? this.factory.zero() : this.edge2.apply(event1Enabled2.id(), CifBddEdgeApplyDirection.FORWARD, null);
            termination.throwIfRequested();
            event1Enabled2.free();
        }
        return this.event12Done;
    }

    BDD getEvent21Done(Termination termination) {
        if (this.event21Done == null) {
            BDD event2Done = this.getEvent2Done(termination);
            termination.throwIfRequested();
            BDD event2Enabled1 = event2Done.and(this.edge1.guard);
            termination.throwIfRequested();
            this.event21Done = event2Enabled1.isZero() ? this.factory.zero() : this.edge1.apply(event2Enabled1.id(), CifBddEdgeApplyDirection.FORWARD, null);
            termination.throwIfRequested();
            event2Enabled1.free();
        }
        return this.event21Done;
    }

    void free() {
        this.commonEnabledGuardsNoZero = BddUtils.free((BDD)this.commonEnabledGuardsNoZero);
        this.commonEnabledGuardsWithZero = BddUtils.free((BDD)this.commonEnabledGuardsWithZero);
        this.commonEnabledZeroStates = BddUtils.free((BDD)this.commonEnabledZeroStates);
        this.event1Done = BddUtils.free((BDD)this.event1Done);
        this.event2Done = BddUtils.free((BDD)this.event2Done);
        this.event12Done = BddUtils.free((BDD)this.event12Done);
        this.event21Done = BddUtils.free((BDD)this.event21Done);
    }
}

