/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.declwrap;

import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.InputParameter;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.parser.ast.AInputParameter;
import org.eclipse.escet.cif.typechecker.CheckStatus;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypesTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.declwrap.DeclWrap;
import org.eclipse.escet.cif.typechecker.scopes.ParentScope;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public class InputParamDeclWrap
extends DeclWrap<InputParameter> {
    private final AInputParameter astDecl;

    public InputParamDeclWrap(CifTypeChecker tchecker, ParentScope<?> scope, AInputParameter astDecl, InputParameter mmDecl) {
        super(tchecker, scope, mmDecl);
        this.astDecl = astDecl;
    }

    @Override
    public String getName() {
        return ((InputParameter)this.mmDecl).getVariable().getName();
    }

    @Override
    public String getAbsName() {
        return CifTextUtils.getAbsName((PositionObject)((InputParameter)this.mmDecl).getVariable());
    }

    @Override
    public void tcheckForUseImpl() {
        CifType type;
        this.checkName();
        this.tchecker.addToCycle(this);
        try {
            type = CifTypesTypeChecker.transCifType(this.astDecl.type, this.scope.getParent(), this.tchecker);
        }
        finally {
            this.tchecker.removeFromCycle(this);
        }
        if (CifTypeUtils.hasComponentLikeType((CifType)type)) {
            this.tchecker.addProblem(ErrMsg.DECL_INVALID_TYPE, type.getPosition(), "Input parameter", this.getAbsName(), CifTextUtils.typeToStr((CifType)type));
            throw new SemanticException();
        }
        ((InputParameter)this.mmDecl).getVariable().setType(type);
        this.status = CheckStatus.USE;
    }

    @Override
    public void tcheckFull() {
        this.tcheckForUse();
        if (this.isCheckedFull()) {
            return;
        }
        CifType type = ((InputParameter)this.mmDecl).getVariable().getType();
        if (CifValueUtils.getPossibleValueCount((CifType)type) == 1.0) {
            this.tchecker.addProblem(ErrMsg.TYPE_ONE_VALUE, type.getPosition(), "", CifTextUtils.typeToStr((CifType)type), "input parameter", CifTextUtils.getAbsName((PositionObject)this.mmDecl, (boolean)false), "input parameter");
        }
        this.status = CheckStatus.FULL;
    }
}

