/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.dsm;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.eclipse.escet.common.dsm.BusComputing;
import org.eclipse.escet.common.dsm.ClusterComputing;
import org.eclipse.escet.common.dsm.ClusterInput;
import org.eclipse.escet.common.dsm.Dsm;
import org.eclipse.escet.common.dsm.DsmHelper;
import org.eclipse.escet.common.dsm.Group;
import org.eclipse.escet.common.dsm.Label;
import org.eclipse.escet.common.dsm.MatrixHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.BitSets;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.output.DebugNormalOutput;

public class DsmClustering {
    private DsmClustering() {
    }

    public static Dsm flowBasedMarkovClustering(ClusterInput clusterInput) {
        RealMatrix adjacencies = clusterInput.adjacencies;
        double busInclusion = clusterInput.busInclusion;
        double evap = clusterInput.evap;
        int stepCount = clusterInput.stepCount;
        double inflation = clusterInput.inflation;
        double epsilon = clusterInput.epsilon;
        DebugNormalOutput dbg = clusterInput.debugOut;
        int size = adjacencies.getRowDimension();
        dbg.line("Flow-based Markov clustering for %d nodes.", new Object[]{size});
        List groups = Lists.list();
        RealMatrix adjacenciesOriginal = adjacencies.copy();
        MatrixHelper.clearDiagonal(adjacencies);
        BitSet potentionalBusNodes = BitSets.ones((int)size);
        BitSet busNodes = new BitSet();
        switch (clusterInput.busDetectionAlgorithm) {
            case NO_BUS: {
                break;
            }
            case FIX_POINT: {
                busNodes = BusComputing.computeFixPointBus(adjacencies, busInclusion, potentionalBusNodes);
                break;
            }
            case TOP_K: {
                busNodes = BusComputing.computeTopKBus(adjacencies, busInclusion, potentionalBusNodes);
            }
        }
        Group busGroup = ClusterComputing.hierarchicalClustering(adjacencies, busNodes, evap, stepCount, inflation, epsilon, Group.GroupType.BUS, dbg);
        if (busGroup != null) {
            dbg.line("Bus-group found:");
            busGroup.dbgDump("  ", dbg);
            Assert.implies((busGroup.childGroups.size() == 1 ? 1 : 0) != 0, (busGroup.localNodes != null ? 1 : 0) != 0);
            groups.add(busGroup);
        } else {
            dbg.line("No bus found.");
        }
        BitSet nonbusNodes = BitSets.ones((int)size);
        nonbusNodes.andNot(busNodes);
        Group nonbusGroup = ClusterComputing.hierarchicalClustering(adjacencies, nonbusNodes, evap, stepCount, inflation, epsilon, Group.GroupType.CLUSTER, dbg);
        if (nonbusGroup != null) {
            dbg.line("Clustering-group found:");
            nonbusGroup.dbgDump("  ", dbg);
            Assert.implies((nonbusGroup.childGroups.size() == 1 ? 1 : 0) != 0, (nonbusGroup.localNodes != null ? 1 : 0) != 0);
            groups.add(nonbusGroup);
        } else {
            dbg.line("No clustering found.");
        }
        if (groups.isEmpty()) {
            return null;
        }
        Group rootGroup = groups.size() == 1 ? (Group)Lists.first((List)groups) : new Group(Group.GroupType.COLLECTION, null, groups);
        Dsm dsm = DsmClustering.shuffleNodes(adjacenciesOriginal, clusterInput.labels, rootGroup, dbg);
        dbg.line("Shuffled nodes of groups near each other:");
        dsm.rootGroup.dbgDump("  ", dbg);
        return dsm;
    }

    private static Dsm shuffleNodes(RealMatrix adjacencies, Label[] labels, Group rootGroup, DebugNormalOutput dbg) {
        int[] nodeShuffle = DsmClustering.computeShuffle(rootGroup);
        if (dbg.isEnabled()) {
            dbg.line();
            dbg.line("Node mapping new <- original:");
            int i = 0;
            while (i < nodeShuffle.length) {
                dbg.line("  %d <- %d", new Object[]{i, nodeShuffle[i]});
                ++i;
            }
            dbg.line();
        }
        adjacencies = DsmClustering.shuffleMatrix(nodeShuffle, adjacencies);
        labels = DsmHelper.shuffleArray(labels, nodeShuffle);
        return new Dsm(nodeShuffle, adjacencies, labels, rootGroup);
    }

    private static int[] computeShuffle(Group group) {
        int size = group.members.cardinality();
        int[] nodeShuffle = new int[size];
        Arrays.fill(nodeShuffle, -1);
        int nextFree = DsmClustering.assignGroups(nodeShuffle, 0, group);
        Assert.check((nextFree == size ? 1 : 0) != 0);
        int i = 0;
        while (i < size) {
            Assert.check((nodeShuffle[i] >= 0 ? 1 : 0) != 0);
            ++i;
        }
        return nodeShuffle;
    }

    private static int assignGroups(int[] nodeShuffle, int base, Group group) {
        group.setShuffledBase(base);
        Collections.sort(group.childGroups, GroupComparator.COMPARATOR);
        for (Group child : group.childGroups) {
            int nextFree = DsmClustering.assignGroups(nodeShuffle, base, child);
            Assert.check((base + child.members.cardinality() == nextFree ? 1 : 0) != 0);
            base = nextFree;
        }
        if (group.localNodes != null) {
            Iterator<Group> iterator = BitSets.iterateTrueBits((BitSet)group.localNodes).iterator();
            while (iterator.hasNext()) {
                int i;
                nodeShuffle[base] = i = ((Integer)((Object)iterator.next())).intValue();
                ++base;
            }
        }
        return base;
    }

    private static RealMatrix shuffleMatrix(int[] nodeShuffle, RealMatrix adjacencies) {
        int size = nodeShuffle.length;
        Assert.check((adjacencies.getColumnDimension() == size ? 1 : 0) != 0);
        Assert.check((adjacencies.getRowDimension() == size ? 1 : 0) != 0);
        BlockRealMatrix result = new BlockRealMatrix(size, size);
        int i = 0;
        while (i < size) {
            int origRow = nodeShuffle[i];
            int j = 0;
            while (j < size) {
                result.setEntry(i, j, adjacencies.getEntry(origRow, nodeShuffle[j]));
                ++j;
            }
            ++i;
        }
        return result;
    }

    private static class GroupComparator
    implements Comparator<Group> {
        public static final GroupComparator COMPARATOR = new GroupComparator();

        private GroupComparator() {
        }

        @Override
        public int compare(Group g1, Group g2) {
            boolean g1Bus = g1.groupType.equals((Object)Group.GroupType.BUS);
            boolean g2Bus = g2.groupType.equals((Object)Group.GroupType.BUS);
            if (g1Bus && !g2Bus) {
                return -1;
            }
            if (!g1Bus && g2Bus) {
                return 1;
            }
            return Integer.compare(g1.members.cardinality(), g2.members.cardinality());
        }
    }
}

