/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java.output;

import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.output.DebugNormalOutput;
import org.eclipse.escet.common.java.output.DebugNormalOutputProvider;
import org.eclipse.escet.common.java.output.ErrorOutput;
import org.eclipse.escet.common.java.output.ErrorOutputProvider;
import org.eclipse.escet.common.java.output.WarnOutput;
import org.eclipse.escet.common.java.output.WarnOutputProvider;

public class StoredOutputProvider
implements WarnOutputProvider,
ErrorOutputProvider,
DebugNormalOutputProvider {
    private final StringBuilder stringStore = new StringBuilder();
    private final boolean isDebugEnabled;
    private final boolean isNormalEnabled;
    private final boolean isWarnEnabled;
    private final int indentSize;
    private int totalIndentLevel = 0;
    private String curIndentText = "";
    private DebugNormalOutput debugOutput = null;
    private DebugNormalOutput normalOutput = null;
    private WarnOutput warnOutput = null;
    private ErrorOutput errorOutput = null;

    public StoredOutputProvider() {
        this(true, true, true, 4);
    }

    public StoredOutputProvider(boolean isDebugEnabled, boolean isNormalEnabled, boolean isWarnEnabled) {
        this(isDebugEnabled, isNormalEnabled, isWarnEnabled, 4);
    }

    public StoredOutputProvider(boolean isDebugEnabled, boolean isNormalEnabled, boolean isWarnEnabled, int indentSize) {
        this.isDebugEnabled = isDebugEnabled;
        this.isNormalEnabled = isNormalEnabled;
        this.isWarnEnabled = isWarnEnabled;
        this.indentSize = indentSize;
    }

    @Override
    public DebugNormalOutput getDebugOutput(String linePrefix) {
        if (this.debugOutput == null) {
            this.debugOutput = this.makeDebugNormalOutput(this.isDebugEnabled, linePrefix);
        }
        return this.debugOutput;
    }

    @Override
    public DebugNormalOutput getNormalOutput(String linePrefix) {
        if (this.normalOutput == null) {
            this.normalOutput = this.makeDebugNormalOutput(this.isNormalEnabled, linePrefix);
        }
        return this.normalOutput;
    }

    private void incTotalIndentLevel() {
        ++this.totalIndentLevel;
        this.curIndentText = null;
    }

    private void decTotalIndentLevel() {
        Assert.check(this.totalIndentLevel > 0);
        --this.totalIndentLevel;
        this.curIndentText = null;
    }

    private String getIndentText() {
        if (this.curIndentText == null) {
            this.curIndentText = Strings.spaces(this.totalIndentLevel * this.indentSize);
        }
        return this.curIndentText;
    }

    private DebugNormalOutput makeDebugNormalOutput(final boolean isEnabled, final String linePrefix) {
        return new DebugNormalOutput(){
            private int streamIndentLevel = 0;

            @Override
            public void line(String message) {
                if (!this.isEnabled()) {
                    return;
                }
                String curIndentText = StoredOutputProvider.this.getIndentText();
                String[] stringArray = Strings.splitLines(message);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object line = stringArray[n2];
                    line = linePrefix != null && !linePrefix.isEmpty() ? (((String)line).isEmpty() ? curIndentText + linePrefix.stripTrailing() + "\n" : curIndentText + linePrefix + (String)line + "\n") : (((String)line).isEmpty() ? "\n" : curIndentText + (String)line + "\n");
                    StoredOutputProvider.this.stringStore.append((String)line);
                    ++n2;
                }
            }

            @Override
            public boolean isEnabled() {
                return isEnabled;
            }

            @Override
            public void inc() {
                if (this.isEnabled()) {
                    ++this.streamIndentLevel;
                    StoredOutputProvider.this.incTotalIndentLevel();
                }
            }

            @Override
            public void dec() {
                if (this.isEnabled()) {
                    Assert.check(this.streamIndentLevel > 0);
                    --this.streamIndentLevel;
                    StoredOutputProvider.this.decTotalIndentLevel();
                }
            }
        };
    }

    @Override
    public WarnOutput getWarnOutput(final String linePrefix) {
        if (this.warnOutput == null) {
            this.warnOutput = new WarnOutput(){

                @Override
                public void line(String message) {
                    if (!this.isEnabled()) {
                        return;
                    }
                    String curIndentText = StoredOutputProvider.this.getIndentText();
                    String[] stringArray = Strings.splitLines(message);
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object line = stringArray[n2];
                        line = linePrefix != null && !linePrefix.isEmpty() ? (((String)line).isEmpty() ? curIndentText + linePrefix.stripTrailing() + "\n" : curIndentText + linePrefix + (String)line + "\n") : (((String)line).isEmpty() ? "\n" : curIndentText + (String)line + "\n");
                        StoredOutputProvider.this.stringStore.append((String)line);
                        ++n2;
                    }
                }

                @Override
                public boolean isEnabled() {
                    return StoredOutputProvider.this.isWarnEnabled;
                }
            };
        }
        return this.warnOutput;
    }

    @Override
    public ErrorOutput getErrorOutput(final String linePrefix) {
        if (this.errorOutput == null) {
            this.errorOutput = new ErrorOutput(){

                @Override
                public void line(String message) {
                    String[] stringArray = Strings.splitLines(message);
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object line = stringArray[n2];
                        line = linePrefix != null && !linePrefix.isEmpty() ? (((String)line).isEmpty() ? linePrefix.stripTrailing() + "\n" : linePrefix + (String)line + "\n") : (String)line + "\n";
                        StoredOutputProvider.this.stringStore.append((String)line);
                        ++n2;
                    }
                }
            };
        }
        return this.errorOutput;
    }

    public String toString() {
        return this.stringStore.toString();
    }
}

