/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.generator.parser;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.setext.generator.parser.EmptySymbol;
import org.eclipse.escet.setext.generator.parser.Grammar;
import org.eclipse.escet.setext.generator.parser.GrammarItem;
import org.eclipse.escet.setext.generator.parser.GrammarItemsMap;
import org.eclipse.escet.setext.generator.parser.LALR1Automaton;
import org.eclipse.escet.setext.generator.parser.LALR1AutomatonState;
import org.eclipse.escet.setext.generator.parser.LR0Automaton;
import org.eclipse.escet.setext.generator.parser.LR0AutomatonState;
import org.eclipse.escet.setext.generator.parser.LookaheadItem;
import org.eclipse.escet.setext.generator.parser.ParserAcceptAction;
import org.eclipse.escet.setext.generator.parser.ParserReduceAction;
import org.eclipse.escet.setext.generator.parser.ParserShiftAction;
import org.eclipse.escet.setext.generator.parser.PropagationItem;
import org.eclipse.escet.setext.parser.ast.Specification;
import org.eclipse.escet.setext.parser.ast.Symbol;
import org.eclipse.escet.setext.parser.ast.parser.NonTerminal;
import org.eclipse.escet.setext.parser.ast.parser.ParserRule;
import org.eclipse.escet.setext.parser.ast.parser.ParserRulePart;
import org.eclipse.escet.setext.parser.ast.parser.StartSymbol;
import org.eclipse.escet.setext.parser.ast.regex.RegEx;
import org.eclipse.escet.setext.parser.ast.regex.RegExChar;
import org.eclipse.escet.setext.parser.ast.scanner.Terminal;
import org.eclipse.escet.setext.typechecker.SeTextTypeChecker;

public class LALR1ParserGenerator {
    public static final Terminal DUMMY_TERM = new Terminal("\\u00D7", (RegEx)new RegExChar(215, null), null, null, null, null);
    public GrammarItemsMap itemsMap;
    public Map<Symbol, Set<Symbol>> firstMap;
    public int conflicts = 0;
    public int shiftReduceConflicts = 0;
    public int reduceReduceConflicts = 0;
    public int acceptReduceConflicts = 0;

    public LALR1Automaton generate(Specification spec, StartSymbol start) {
        Set nonterminalSet = SeTextTypeChecker.getReachableNonTerms((NonTerminal)start.symbol);
        List nonterminals = Sets.sortedgeneric((Set)nonterminalSet, (Comparator)NonTerminal.NAME_COMPARER);
        Grammar grammar = new Grammar(nonterminals, start.symbol);
        this.constructGrammarItems(grammar);
        LR0Automaton aut0 = this.constructLR0Automaton(spec.terminals, grammar);
        List terminals = Lists.concat((List)spec.terminals, (Object)DUMMY_TERM);
        this.calcFirst(terminals, grammar);
        List eofTerminals = spec.getEofTerminals();
        LALR1Automaton aut1 = aut0.toLALR1();
        for (LALR1AutomatonState state : aut1.states) {
            this.fillPropagationMap(state);
        }
        for (LALR1AutomatonState state : aut1.states) {
            this.addLookaheads(state, eofTerminals);
        }
        for (LALR1AutomatonState state : aut1.states) {
            state.itemsClosure = this.closureLookahead(state.items.values());
        }
        this.fillParsingTable(aut1, terminals, nonterminals);
        return aut1;
    }

    public void constructGrammarItems(Grammar grammar) {
        Assert.check((this.itemsMap == null ? 1 : 0) != 0);
        this.itemsMap = new GrammarItemsMap();
        for (NonTerminal nonterminal : grammar.nonterminals) {
            Map ntMap = Maps.map();
            for (ParserRule rule : nonterminal.rules) {
                List items = Lists.list();
                int i = 0;
                while (i <= rule.symbols.size()) {
                    items.add(new GrammarItem(nonterminal, rule, i));
                    ++i;
                }
                ntMap.put(rule, items);
            }
            this.itemsMap.put(nonterminal, ntMap);
        }
    }

    public LR0Automaton constructLR0Automaton(List<Terminal> terminals, Grammar grammar) {
        List symbols = Lists.concat(terminals, grammar.nonterminals);
        ParserRule startRule = (ParserRule)Lists.first((List)grammar.startSymbol.rules);
        GrammarItem startItem = (GrammarItem)((List)((Map)this.itemsMap.get(grammar.startSymbol)).get(startRule)).get(0);
        Set<GrammarItem> initialItems = this.closure(Sets.set((Object)startItem));
        LR0AutomatonState initialState = new LR0AutomatonState(initialItems);
        LR0Automaton automaton = new LR0Automaton(initialState);
        LinkedList<LR0AutomatonState> todoStates = new LinkedList<LR0AutomatonState>();
        todoStates.push(initialState);
        while (!todoStates.isEmpty()) {
            LR0AutomatonState state = (LR0AutomatonState)todoStates.pop();
            for (Symbol symbol : symbols) {
                Set<GrammarItem> targetItems = this.getGoto(state.items, symbol);
                if (targetItems.isEmpty()) continue;
                LR0AutomatonState target = new LR0AutomatonState(targetItems);
                LR0AutomatonState representative = automaton.addState(target);
                if (representative == target) {
                    todoStates.push(target);
                }
                state.addEdge(symbol, representative);
            }
        }
        return automaton;
    }

    public Set<GrammarItem> closure(Set<GrammarItem> items) {
        int size;
        Set rslt = Sets.copy(items);
        Set addedNonTerminals = Sets.set();
        do {
            size = rslt.size();
            Set toAdd = Sets.set();
            for (GrammarItem item : rslt) {
                NonTerminal nonterminal;
                Symbol nextSymbol;
                if (item.isAfter() || !((nextSymbol = item.getNextSymbol()) instanceof NonTerminal) || addedNonTerminals.contains(nonterminal = (NonTerminal)nextSymbol)) continue;
                Map ntItemsMap = (Map)this.itemsMap.get(nonterminal);
                for (List itemToAdd : ntItemsMap.values()) {
                    toAdd.add((GrammarItem)itemToAdd.get(0));
                }
                addedNonTerminals.add(nonterminal);
            }
            rslt.addAll(toAdd);
        } while (rslt.size() != size);
        return rslt;
    }

    public Set<GrammarItem> getGoto(Set<GrammarItem> items, Symbol symbol) {
        Set rslt = Sets.set();
        for (GrammarItem item : items) {
            Symbol nextSymbol;
            if (item.isAfter() || (nextSymbol = item.getNextSymbol()) != symbol) continue;
            Set<GrammarItem> toAdd = this.closure(Sets.set((Object)item.getNextItem(this.itemsMap)));
            rslt.addAll(toAdd);
        }
        return rslt;
    }

    public void calcFirst(List<Terminal> terminals, Grammar grammar) {
        boolean progress;
        Assert.check((this.firstMap == null ? 1 : 0) != 0);
        this.firstMap = Maps.map();
        List symbols = Lists.concat(terminals, grammar.nonterminals);
        for (Symbol symbol : symbols) {
            Set firstSet = Sets.set();
            if (symbol instanceof Terminal) {
                firstSet.add(symbol);
            } else {
                Assert.check((boolean)(symbol instanceof NonTerminal));
                NonTerminal nonterminal = (NonTerminal)symbol;
                boolean hasEmptyProd = false;
                for (ParserRule rule : nonterminal.rules) {
                    if (!rule.symbols.isEmpty()) continue;
                    hasEmptyProd = true;
                    break;
                }
                if (hasEmptyProd) {
                    firstSet.add(EmptySymbol.EMPTY_SYMBOL);
                }
            }
            this.firstMap.put(symbol, firstSet);
        }
        do {
            progress = false;
            for (NonTerminal nonterminal : grammar.nonterminals) {
                Set<Symbol> nontermFirst = this.firstMap.get(nonterminal);
                for (ParserRule rule : nonterminal.rules) {
                    if (rule.symbols.isEmpty()) continue;
                    boolean allEmpty = true;
                    for (ParserRulePart part : rule.symbols) {
                        Set<Symbol> partFirst = this.firstMap.get(part.symbol);
                        for (Symbol addSymbol : partFirst) {
                            if (addSymbol == EmptySymbol.EMPTY_SYMBOL) continue;
                            progress |= nontermFirst.add(addSymbol);
                        }
                        if (partFirst.contains((Object)EmptySymbol.EMPTY_SYMBOL)) continue;
                        allEmpty = false;
                        break;
                    }
                    if (!allEmpty) continue;
                    progress |= nontermFirst.add(EmptySymbol.EMPTY_SYMBOL);
                }
            }
        } while (progress);
    }

    public Set<Symbol> getFirst(Symbol symbol) {
        Set<Symbol> rslt = this.firstMap.get(symbol);
        Assert.notNull(rslt);
        return rslt;
    }

    public Set<Symbol> getFirst(List<Symbol> symbols) {
        Assert.check((!symbols.isEmpty() ? 1 : 0) != 0);
        Set rslt = Sets.set();
        boolean allEmpty = true;
        for (Symbol symbol : symbols) {
            Set<Symbol> symbolFirst = this.getFirst(symbol);
            boolean hasEmpty = false;
            for (Symbol addSymbol : symbolFirst) {
                if (addSymbol != EmptySymbol.EMPTY_SYMBOL) {
                    rslt.add(addSymbol);
                    continue;
                }
                hasEmpty = true;
            }
            if (hasEmpty) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            rslt.add(EmptySymbol.EMPTY_SYMBOL);
        }
        return rslt;
    }

    public Set<LookaheadItem> closureLookahead(Collection<LookaheadItem> items) {
        boolean progress;
        Map rslt = Maps.map();
        for (LookaheadItem item : items) {
            LookaheadItem prev = rslt.put(item.item, item);
            Assert.check((prev == null ? 1 : 0) != 0);
        }
        do {
            progress = false;
            Set curRsltKeys = Sets.copy(rslt.keySet());
            for (GrammarItem item : curRsltKeys) {
                Symbol nextSymbol;
                if (item.isAfter() || !((nextSymbol = item.getNextSymbol()) instanceof NonTerminal)) continue;
                NonTerminal nonterminal = (NonTerminal)nextSymbol;
                Set<Terminal> lookaheads = ((LookaheadItem)rslt.get((Object)item)).lookaheads;
                for (Terminal terminal : lookaheads) {
                    List<Symbol> beta = item.remainderAfterNext();
                    Terminal alpha = terminal;
                    Set first = this.getFirst(Lists.concat(beta, (Object)alpha));
                    first = Sets.copy(first);
                    first.remove((Object)EmptySymbol.EMPTY_SYMBOL);
                    Set firstTerms = Sets.filter((Set)first, Terminal.class);
                    if (firstTerms.isEmpty()) continue;
                    Map ntItemsMap = (Map)this.itemsMap.get(nonterminal);
                    for (List itemToAdd : ntItemsMap.values()) {
                        GrammarItem addItem = (GrammarItem)itemToAdd.get(0);
                        LookaheadItem curLAI = (LookaheadItem)rslt.get(addItem);
                        if (curLAI == null) {
                            progress = true;
                            LookaheadItem newLAI = new LookaheadItem(addItem, firstTerms);
                            rslt.put(addItem, newLAI);
                            continue;
                        }
                        Set<Terminal> curLA = curLAI.lookaheads;
                        Set updLA = Sets.union(curLA, (Set)firstTerms);
                        if (updLA.size() == curLA.size()) continue;
                        progress = true;
                        LookaheadItem updLAI = new LookaheadItem(addItem, updLA);
                        rslt.put(addItem, updLAI);
                    }
                }
            }
        } while (progress);
        return new LinkedHashSet<LookaheadItem>(rslt.values());
    }

    public Set<LookaheadItem> getGotoLookahead(Set<LookaheadItem> items, Symbol symbol) {
        Set rslt = Sets.set();
        for (LookaheadItem item : items) {
            Symbol nextSymbol;
            if (item.item.isAfter() || (nextSymbol = item.item.getNextSymbol()) != symbol) continue;
            GrammarItem nextItem = item.item.getNextItem(this.itemsMap);
            LookaheadItem nextLAI = new LookaheadItem(nextItem, item.lookaheads);
            rslt.add(nextLAI);
        }
        return this.closureLookahead(rslt);
    }

    public void fillPropagationMap(LALR1AutomatonState state) {
        for (GrammarItem item : state.items.keySet()) {
            Assert.check((boolean)item.isKernelItem());
            LookaheadItem dummyItem = new LookaheadItem(item, Sets.set((Object)DUMMY_TERM));
            Set<LookaheadItem> closure = this.closureLookahead(Sets.set((Object)dummyItem));
            for (LookaheadItem cItem : closure) {
                if (cItem.item.isAfter()) continue;
                Symbol nextSymbol = cItem.item.getNextSymbol();
                LALR1AutomatonState target = state.edges.get(nextSymbol);
                Assert.notNull((Object)target);
                if (!cItem.lookaheads.contains(DUMMY_TERM)) continue;
                GrammarItem nextItem = cItem.item.getNextItem(this.itemsMap);
                PropagationItem propItem = new PropagationItem(target, nextItem);
                Set propagations = state.propagations.get(item);
                if (propagations == null) {
                    propagations = Sets.set();
                    state.propagations.put(item, propagations);
                }
                propagations.add(propItem);
            }
        }
    }

    public void addLookaheads(LALR1AutomatonState state, List<Terminal> eofTerminals) {
        for (GrammarItem item : state.items.keySet()) {
            Assert.check((boolean)item.isKernelItem());
            LookaheadItem dummyItem = new LookaheadItem(item, Sets.set((Object)DUMMY_TERM));
            Set<LookaheadItem> closure = this.closureLookahead(Sets.set((Object)dummyItem));
            for (LookaheadItem cItem : closure) {
                if (cItem.item.isAfter()) continue;
                Symbol nextSymbol = cItem.item.getNextSymbol();
                LALR1AutomatonState target = state.edges.get(nextSymbol);
                Assert.notNull((Object)target);
                GrammarItem nextItem = cItem.item.getNextItem(this.itemsMap);
                for (Terminal lookahead : cItem.lookaheads) {
                    if (lookahead == DUMMY_TERM) continue;
                    this.propagateLookahead(target, nextItem, lookahead);
                }
            }
        }
        if (state.id == 0) {
            GrammarItem item;
            Assert.check((state.items.size() == 1 ? 1 : 0) != 0);
            item = state.items.keySet().iterator().next();
            Assert.check((boolean)item.isKernelItem());
            for (Terminal eofTerminal : eofTerminals) {
                this.propagateLookahead(state, item, eofTerminal);
            }
        }
    }

    public void propagateLookahead(LALR1AutomatonState state, GrammarItem item, Terminal lookahead) {
        LookaheadItem laItem = state.items.get(item);
        Set<Terminal> curLA = laItem.lookaheads;
        boolean added = curLA.add(lookahead);
        if (!added) {
            return;
        }
        Set<PropagationItem> propagations = state.propagations.get(item);
        if (propagations == null) {
            return;
        }
        Assert.check((!propagations.isEmpty() ? 1 : 0) != 0);
        for (PropagationItem propagation : propagations) {
            this.propagateLookahead(propagation.state, propagation.item, lookahead);
        }
    }

    public void fillParsingTable(LALR1Automaton aut, List<Terminal> terminals, List<NonTerminal> nonterminals) {
        for (LALR1AutomatonState state : aut.states) {
            Set<LookaheadItem> items = state.itemsClosure;
            for (Terminal terminal : terminals) {
                Set actions = Sets.set();
                for (LookaheadItem item : items) {
                    if (!item.item.isAfter()) {
                        Symbol nextSymbol = item.item.getNextSymbol();
                        if (nextSymbol != terminal) continue;
                        LALR1AutomatonState target = state.edges.get(terminal);
                        actions.add(new ParserShiftAction(target));
                        continue;
                    }
                    if (!item.lookaheads.contains(terminal)) continue;
                    if (item.item.nonterminal.isAugmentedStartSymbol()) {
                        actions.add(new ParserAcceptAction());
                        continue;
                    }
                    actions.add(new ParserReduceAction(item.item.nonterminal, item.item.rule));
                }
                if (actions.isEmpty()) continue;
                state.actions.put(terminal, actions);
            }
            for (NonTerminal nonterminal : nonterminals) {
                LALR1AutomatonState target = state.edges.get(nonterminal);
                if (target == null) continue;
                state.gotos.put(nonterminal, target);
            }
        }
    }

    public String getConflictsText() {
        String conflictTxt = "";
        if (this.conflicts > 0) {
            conflictTxt = Strings.fmt((String)" (%d shift/reduce, %d reduce/reduce, %d accept/reduce)", (Object[])new Object[]{this.shiftReduceConflicts, this.reduceReduceConflicts, this.acceptReduceConflicts});
        }
        String msg = Strings.fmt((String)"%d conflict(s) in total%s.", (Object[])new Object[]{this.conflicts, conflictTxt});
        return msg;
    }
}

