/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.ChartPart;
import org.knowm.xchart.style.BoxStyler;
import org.knowm.xchart.style.OHLCStyler;
import org.knowm.xchart.style.Styler;

public class ToolTips
extends MouseAdapter
implements ChartPart {
    private static final int MARGIN = 5;
    private static final int MOUSE_MARGIN = 20;
    private final Chart chart;
    private final Styler styler;
    private final List<ToolTip> toolTipList = new ArrayList<ToolTip>();
    private ToolTip tooltip = null;

    public ToolTips(Chart chart) {
        this.chart = chart;
        this.styler = chart.getStyler();
        chart.plot.plotContent.setToolTips(this);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        boolean isRepaint = false;
        ToolTip newPoint = this.getSelectedTooltip(e.getX(), e.getY());
        if (newPoint != null) {
            if (this.tooltip != null && this.tooltip.equals(newPoint)) {
                isRepaint = false;
            }
            this.tooltip = newPoint;
            isRepaint = true;
        } else if (this.tooltip != null) {
            this.tooltip = null;
            isRepaint = true;
        }
        if (isRepaint) {
            e.getComponent().repaint();
        }
    }

    private ToolTip getSelectedTooltip(int x, int y) {
        ToolTip newPoint = null;
        for (ToolTip tooltip : this.toolTipList) {
            if (!tooltip.shape.contains(x, y)) continue;
            newPoint = tooltip;
            break;
        }
        return newPoint;
    }

    @Override
    public Rectangle2D getBounds() {
        return null;
    }

    @Override
    public void paint(Graphics2D g) {
        if (this.styler.isToolTipsAlwaysVisible()) {
            for (ToolTip tooltip : this.toolTipList) {
                this.paintToolTip(g, tooltip);
            }
        }
        if (this.tooltip != null) {
            if (this.styler instanceof BoxStyler || this.styler instanceof OHLCStyler) {
                this.paintMultiLineToolTip(g);
            } else {
                this.paintToolTip(g, this.tooltip);
            }
        }
    }

    private void paintToolTip(Graphics2D g, ToolTip tooltip) {
        TextLayout textLayout = new TextLayout(tooltip.label, this.styler.getToolTipFont(), new FontRenderContext(null, true, false));
        Rectangle2D annotationRectangle = textLayout.getBounds();
        double w = annotationRectangle.getWidth() + 10.0;
        double h = annotationRectangle.getHeight() + 10.0;
        double halfHeight = h / 2.0;
        if (tooltip == this.tooltip) {
            g.setColor(this.styler.getToolTipHighlightColor());
            g.fill(tooltip.shape);
        }
        int leftEdge = (int)this.chart.plot.plotContent.getBounds().getX();
        int rightEdge = (int)(this.chart.plot.plotContent.getBounds().getX() + this.chart.plot.plotContent.getBounds().getWidth());
        int topEdge = (int)this.chart.plot.plotContent.getBounds().getY();
        int bottomEdge = (int)(this.chart.plot.plotContent.getBounds().getY() + this.chart.plot.plotContent.getBounds().getHeight());
        double x = tooltip.x + tooltip.w / 2.0 - annotationRectangle.getWidth() / 2.0 - 5.0;
        double y = tooltip.y - 15.0 - annotationRectangle.getHeight();
        x = Math.max(x, (double)leftEdge);
        x = Math.min(x, (double)rightEdge - w);
        y = Math.max(y, (double)topEdge);
        y = Math.min(y, (double)bottomEdge - h);
        Rectangle2D.Double rectangle = new Rectangle2D.Double(x, y, w, h);
        g.setColor(this.styler.getToolTipBackgroundColor());
        g.fill(rectangle);
        g.setStroke(SOLID_STROKE);
        g.setColor(this.styler.getToolTipBorderColor());
        g.draw(rectangle);
        Shape shape = textLayout.getOutline(null);
        g.setColor(this.styler.getChartFontColor());
        g.setFont(this.styler.getToolTipFont());
        AffineTransform orig = g.getTransform();
        AffineTransform at = new AffineTransform();
        at.translate(x + 5.0 - 1.0, y + 5.0 - 1.0 + halfHeight);
        g.transform(at);
        g.fill(shape);
        g.setTransform(orig);
    }

    private void paintMultiLineToolTip(Graphics2D g) {
        String[] texts = this.tooltip.label.split(System.lineSeparator());
        ArrayList<TextLayout> list = new ArrayList<TextLayout>();
        TextLayout textLayout = null;
        Rectangle2D bounds = null;
        double backgroundHeight = 5.0;
        double backgroundWidth = 0.0;
        for (String text : texts) {
            textLayout = new TextLayout(text, this.styler.getToolTipFont(), new FontRenderContext(null, true, false));
            bounds = textLayout.getBounds();
            bounds.getHeight();
            if (backgroundWidth < bounds.getWidth()) {
                backgroundWidth = bounds.getWidth();
            }
            backgroundHeight += (double)(this.styler.getToolTipFont().getSize() + 5);
            list.add(textLayout);
        }
        Rectangle clipBounds = g.getClipBounds();
        double startX = this.tooltip.x;
        double startY = this.tooltip.y;
        if (this.tooltip.x + 20.0 + backgroundWidth > clipBounds.getX() + clipBounds.getWidth()) {
            startX = this.tooltip.x - backgroundWidth - 20.0;
        }
        if (this.tooltip.y + 20.0 + backgroundHeight > clipBounds.getY() + clipBounds.getHeight()) {
            startY = this.tooltip.y - backgroundHeight - 20.0;
        }
        g.setColor(this.styler.getToolTipBackgroundColor());
        g.fillRect((int)startX + 20, (int)startY + 20, (int)backgroundWidth + 10, (int)backgroundHeight);
        AffineTransform orig = g.getTransform();
        AffineTransform at = new AffineTransform();
        at.translate(startX + 20.0 + 5.0, startY + textLayout.getBounds().getHeight() + 20.0 + 5.0);
        g.transform(at);
        g.setColor(this.styler.getChartFontColor());
        g.setFont(this.styler.getToolTipFont());
        for (TextLayout t : list) {
            g.fill(t.getOutline(null));
            at = new AffineTransform();
            at.translate(0.0, this.styler.getToolTipFont().getSize() + 5);
            g.transform(at);
        }
        g.setTransform(orig);
    }

    void addData(double xOffset, double yOffset, String xValue, String yValue) {
        String label = this.getLabel(xValue, yValue);
        this.addData(xOffset, yOffset, label);
    }

    void addData(double xOffset, double yOffset, String label) {
        ToolTip toolTip = new ToolTip(xOffset, yOffset, label);
        this.toolTipList.add(toolTip);
    }

    void addData(Shape shape, double xOffset, double yOffset, double width, String xValue, String yValue) {
        String label = this.getLabel(xValue, yValue);
        this.addData(shape, xOffset, yOffset, width, label);
    }

    void addData(Shape shape, double xOffset, double yOffset, double width, String label) {
        ToolTip toolTip = new ToolTip(shape, xOffset, yOffset, width, label);
        this.toolTipList.add(toolTip);
    }

    private String getLabel(String xValue, String yValue) {
        switch (this.styler.getToolTipType()) {
            case xAndYLabels: {
                return "(" + xValue + ", " + yValue + ")";
            }
            case xLabels: {
                return xValue;
            }
            case yLabels: {
                return yValue;
            }
        }
        return "";
    }

    public void clearData() {
        this.toolTipList.clear();
    }

    static class ToolTip {
        final double w;
        private final String label;
        private final Shape shape;
        private final double x;
        private final double y;

        ToolTip(double x, double y, String label) {
            double halfSize = 7.5;
            double markerSize = 15.0;
            this.shape = new Ellipse2D.Double(x - halfSize, y - halfSize, markerSize, markerSize);
            this.x = x;
            this.y = y;
            this.w = 0.0;
            this.label = label;
        }

        ToolTip(Shape shape, double x, double y, double width, String label) {
            this.x = x;
            this.y = y;
            this.w = width;
            this.shape = shape;
            this.label = label;
        }

        public String toString() {
            return "DataPoint{w=" + this.w + ", label='" + this.label + '\'' + ", shape=" + this.shape + ", x=" + this.x + ", y=" + this.y + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ToolTip tooltip = (ToolTip)o;
            return this.label.equals(tooltip.label) && this.shape.equals(tooltip.shape);
        }

        public int hashCode() {
            return Objects.hash(this.label, this.shape);
        }
    }
}

