/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.typecheck;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.chi.metamodel.chi.BinaryExpression;
import org.eclipse.escet.chi.metamodel.chi.BinaryOperators;
import org.eclipse.escet.chi.metamodel.chi.BoolLiteral;
import org.eclipse.escet.chi.metamodel.chi.BoolType;
import org.eclipse.escet.chi.metamodel.chi.CallExpression;
import org.eclipse.escet.chi.metamodel.chi.CastExpression;
import org.eclipse.escet.chi.metamodel.chi.ChannelExpression;
import org.eclipse.escet.chi.metamodel.chi.ChannelOps;
import org.eclipse.escet.chi.metamodel.chi.ChannelType;
import org.eclipse.escet.chi.metamodel.chi.ConstantDeclaration;
import org.eclipse.escet.chi.metamodel.chi.ConstantReference;
import org.eclipse.escet.chi.metamodel.chi.DictType;
import org.eclipse.escet.chi.metamodel.chi.DictionaryExpression;
import org.eclipse.escet.chi.metamodel.chi.DictionaryPair;
import org.eclipse.escet.chi.metamodel.chi.DistributionType;
import org.eclipse.escet.chi.metamodel.chi.EnumDeclaration;
import org.eclipse.escet.chi.metamodel.chi.EnumValue;
import org.eclipse.escet.chi.metamodel.chi.Expression;
import org.eclipse.escet.chi.metamodel.chi.FieldReference;
import org.eclipse.escet.chi.metamodel.chi.FileType;
import org.eclipse.escet.chi.metamodel.chi.FunctionDeclaration;
import org.eclipse.escet.chi.metamodel.chi.FunctionType;
import org.eclipse.escet.chi.metamodel.chi.IntNumber;
import org.eclipse.escet.chi.metamodel.chi.IntType;
import org.eclipse.escet.chi.metamodel.chi.ListExpression;
import org.eclipse.escet.chi.metamodel.chi.ListType;
import org.eclipse.escet.chi.metamodel.chi.MatrixExpression;
import org.eclipse.escet.chi.metamodel.chi.MatrixRow;
import org.eclipse.escet.chi.metamodel.chi.MatrixType;
import org.eclipse.escet.chi.metamodel.chi.ModelDeclaration;
import org.eclipse.escet.chi.metamodel.chi.ModelType;
import org.eclipse.escet.chi.metamodel.chi.ProcessDeclaration;
import org.eclipse.escet.chi.metamodel.chi.ProcessType;
import org.eclipse.escet.chi.metamodel.chi.ReadCallExpression;
import org.eclipse.escet.chi.metamodel.chi.RealNumber;
import org.eclipse.escet.chi.metamodel.chi.RealType;
import org.eclipse.escet.chi.metamodel.chi.SetExpression;
import org.eclipse.escet.chi.metamodel.chi.SetType;
import org.eclipse.escet.chi.metamodel.chi.SliceExpression;
import org.eclipse.escet.chi.metamodel.chi.StdLibFunctionReference;
import org.eclipse.escet.chi.metamodel.chi.StdLibFunctions;
import org.eclipse.escet.chi.metamodel.chi.StringLiteral;
import org.eclipse.escet.chi.metamodel.chi.StringType;
import org.eclipse.escet.chi.metamodel.chi.TimeLiteral;
import org.eclipse.escet.chi.metamodel.chi.TimerType;
import org.eclipse.escet.chi.metamodel.chi.TupleExpression;
import org.eclipse.escet.chi.metamodel.chi.TupleField;
import org.eclipse.escet.chi.metamodel.chi.TupleType;
import org.eclipse.escet.chi.metamodel.chi.Type;
import org.eclipse.escet.chi.metamodel.chi.UnaryExpression;
import org.eclipse.escet.chi.metamodel.chi.UnaryOperators;
import org.eclipse.escet.chi.metamodel.chi.UnresolvedReference;
import org.eclipse.escet.chi.metamodel.chi.VariableDeclaration;
import org.eclipse.escet.chi.metamodel.chi.VoidType;
import org.eclipse.escet.chi.metamodel.java.ChiConstructors;
import org.eclipse.escet.chi.typecheck.CheckContext;
import org.eclipse.escet.chi.typecheck.CheckType;
import org.eclipse.escet.chi.typecheck.Message;
import org.eclipse.escet.chi.typecheck.symbols.ConstantSymbolEntry;
import org.eclipse.escet.chi.typecheck.symbols.EnumValueSymbolEntry;
import org.eclipse.escet.chi.typecheck.symbols.FunctionDefSymbolEntry;
import org.eclipse.escet.chi.typecheck.symbols.ModelDefSymbolEntry;
import org.eclipse.escet.chi.typecheck.symbols.ProcessDefSymbolEntry;
import org.eclipse.escet.chi.typecheck.symbols.SymbolEntry;
import org.eclipse.escet.chi.typecheck.symbols.VariableSymbolEntry;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Numbers;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.common.PositionUtils;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public abstract class CheckExpression {
    private static void checkArguments(List<Expression> exprs, List<Type> types, Expression call, CheckContext ctxt) {
        ctxt.checkThrowError(exprs.size() == types.size(), Message.BAD_ARG_COUNT, call.getPosition(), String.valueOf(types.size()), String.valueOf(exprs.size()));
        int i = 0;
        while (i < exprs.size()) {
            boolean cond = CheckType.matchType(exprs.get(i).getType(), types.get(i));
            ctxt.checkThrowError(cond, Message.ARGUMENT_TYPE_MISMATCH, exprs.get(i).getPosition(), String.valueOf(i + 1), CheckType.toString(types.get(i)), CheckType.toString(exprs.get(i).getType()));
            ++i;
        }
    }

    private static List<FunctionType> getSimpleStdLibFunctionTypes(StdLibFunctions fn) {
        List results = Lists.list();
        switch (fn) {
            case ABS: 
            case SIGN: {
                results.add(ChiConstructors.newFunctionType(CheckType.tlist(new Type[]{ChiConstructors.newIntType()}), null, (Type)ChiConstructors.newIntType()));
                results.add(ChiConstructors.newFunctionType(CheckType.tlist(new Type[]{ChiConstructors.newRealType()}), null, (Type)ChiConstructors.newRealType()));
                return results;
            }
            case ACOS: 
            case ACOSH: 
            case ASIN: 
            case ASINH: 
            case ATAN: 
            case ATANH: 
            case EXP: 
            case LN: 
            case LOG: 
            case SIN: 
            case SINH: 
            case SQRT: 
            case TAN: 
            case TANH: 
            case CBRT: 
            case COS: 
            case COSH: {
                results.add(ChiConstructors.newFunctionType(CheckType.tlist(new Type[]{ChiConstructors.newRealType()}), null, (Type)ChiConstructors.newRealType()));
                return results;
            }
            case FLOOR: 
            case ROUND: 
            case CEIL: {
                results.add(ChiConstructors.newFunctionType(CheckType.tlist(new Type[]{ChiConstructors.newRealType()}), null, (Type)ChiConstructors.newIntType()));
                return results;
            }
            case BERNOULLI: {
                results.add(ChiConstructors.newFunctionType(CheckType.tlist(new Type[]{ChiConstructors.newRealType()}), null, (Type)CheckType.newBoolDist()));
                return results;
            }
            case GAMMA: 
            case LOG_NORMAL: 
            case NORMAL: 
            case WEIBULL: 
            case BETA: {
                results.add(ChiConstructors.newFunctionType(CheckType.tlist(new Type[]{ChiConstructors.newRealType(), ChiConstructors.newRealType()}), null, (Type)CheckType.newRealDist()));
                return results;
            }
            case BINOMIAL: {
                results.add(ChiConstructors.newFunctionType(CheckType.tlist(new Type[]{ChiConstructors.newIntType(), ChiConstructors.newRealType()}), null, (Type)CheckType.newIntDist()));
                return results;
            }
            case CONSTANT: {
                results.add(ChiConstructors.newFunctionType(CheckType.tlist(new Type[]{ChiConstructors.newBoolType()}), null, (Type)CheckType.newBoolDist()));
                results.add(ChiConstructors.newFunctionType(CheckType.tlist(new Type[]{ChiConstructors.newIntType()}), null, (Type)CheckType.newIntDist()));
                results.add(ChiConstructors.newFunctionType(CheckType.tlist(new Type[]{ChiConstructors.newRealType()}), null, (Type)CheckType.newRealDist()));
                return results;
            }
            case ERLANG: {
                results.add(ChiConstructors.newFunctionType(CheckType.tlist(new Type[]{ChiConstructors.newRealType(), ChiConstructors.newIntType()}), null, (Type)CheckType.newRealDist()));
                return results;
            }
            case EXPONENTIAL: {
                results.add(ChiConstructors.newFunctionType(CheckType.tlist(new Type[]{ChiConstructors.newRealType()}), null, (Type)CheckType.newRealDist()));
                return results;
            }
            case FINISHED: {
                results.add(ChiConstructors.newFunctionType(CheckType.tlist(new Type[]{ChiConstructors.newInstanceType()}), null, (Type)ChiConstructors.newBoolType()));
                return results;
            }
            case GEOMETRIC: 
            case POISSON: {
                results.add(ChiConstructors.newFunctionType(CheckType.tlist(new Type[]{ChiConstructors.newRealType()}), null, (Type)CheckType.newIntDist()));
                return results;
            }
            case OPEN: {
                results.add(ChiConstructors.newFunctionType(CheckType.tlist(new Type[]{ChiConstructors.newStringType(), ChiConstructors.newStringType()}), null, (Type)ChiConstructors.newFileType()));
                return results;
            }
            case EOF: 
            case EOL: {
                results.add(ChiConstructors.newFunctionType(CheckType.tlist(new Type[]{ChiConstructors.newFileType()}), null, (Type)ChiConstructors.newBoolType()));
                return results;
            }
            case NEWLINES: {
                results.add(ChiConstructors.newFunctionType(CheckType.tlist(new Type[]{ChiConstructors.newFileType()}), null, (Type)ChiConstructors.newIntType()));
                return results;
            }
            case RANDOM: {
                results.add(ChiConstructors.newFunctionType((List)Lists.list(), null, (Type)CheckType.newRealDist()));
                return results;
            }
            case RANGE: {
                results.add(ChiConstructors.newFunctionType(CheckType.tlist(new Type[]{ChiConstructors.newIntType()}), null, (Type)ChiConstructors.newListType((Type)ChiConstructors.newIntType(), null, null)));
                results.add(ChiConstructors.newFunctionType(CheckType.tlist(new Type[]{ChiConstructors.newIntType(), ChiConstructors.newIntType()}), null, (Type)ChiConstructors.newListType((Type)ChiConstructors.newIntType(), null, null)));
                results.add(ChiConstructors.newFunctionType(CheckType.tlist(new Type[]{ChiConstructors.newIntType(), ChiConstructors.newIntType(), ChiConstructors.newIntType()}), null, (Type)ChiConstructors.newListType((Type)ChiConstructors.newIntType(), null, null)));
                return results;
            }
            case READY: {
                results.add(ChiConstructors.newFunctionType(CheckType.tlist(new Type[]{ChiConstructors.newTimerType()}), null, (Type)ChiConstructors.newBoolType()));
                return results;
            }
            case TRIANGLE: {
                results.add(ChiConstructors.newFunctionType(CheckType.tlist(new Type[]{ChiConstructors.newRealType(), ChiConstructors.newRealType(), ChiConstructors.newRealType()}), null, (Type)CheckType.newRealDist()));
                return results;
            }
            case UNIFORM: {
                results.add(ChiConstructors.newFunctionType(CheckType.tlist(new Type[]{ChiConstructors.newIntType(), ChiConstructors.newIntType()}), null, (Type)CheckType.newIntDist()));
                results.add(ChiConstructors.newFunctionType(CheckType.tlist(new Type[]{ChiConstructors.newRealType(), ChiConstructors.newRealType()}), null, (Type)CheckType.newRealDist()));
                return results;
            }
        }
        Assert.fail((Object)"Unknown simple standard library function encountered.");
        return null;
    }

    private static List<FunctionType> getAvailableStdLibFunctions(StdLibFunctionReference fnr, List<Expression> arguments, CheckContext ctxt) {
        Assert.notNull(arguments);
        switch (fnr.getFunction()) {
            case DICT_KEYS: {
                if (arguments.isEmpty()) {
                    return CheckExpression.reportZeroArguments("a dictionary argument", fnr.getPosition(), ctxt);
                }
                Type argType = arguments.get(0).getType();
                Type aType = CheckType.dropReferences(argType);
                if (aType instanceof DictType) {
                    DictType arg0 = (DictType)aType;
                    ListType resultType = ChiConstructors.newListType((Type)CheckType.copyType(arg0.getKeyType()), null, null);
                    return Lists.list((Object)ChiConstructors.newFunctionType(CheckType.tlist(CheckType.copyType((Type)arg0)), null, (Type)resultType));
                }
                String expectText = ", expected a dictionary argument";
                ctxt.throwError(Message.FUNC_CALL_WRONG_PARAMETER_TYPE, fnr.getPosition(), "1st", CheckType.toString(argType), expectText);
                return null;
            }
            case DICT_VALUES: {
                if (arguments.isEmpty()) {
                    return CheckExpression.reportZeroArguments("a dictionary argument", fnr.getPosition(), ctxt);
                }
                Type argType = arguments.get(0).getType();
                Type aType = CheckType.dropReferences(argType);
                if (aType instanceof DictType) {
                    DictType arg0 = (DictType)aType;
                    ListType rType = ChiConstructors.newListType((Type)CheckType.copyType(arg0.getValueType()), null, null);
                    return Lists.list((Object)ChiConstructors.newFunctionType(CheckType.tlist(CheckType.copyType((Type)arg0)), null, (Type)rType));
                }
                String expectText = ", expected a dictionary argument";
                ctxt.throwError(Message.FUNC_CALL_WRONG_PARAMETER_TYPE, fnr.getPosition(), "1st", CheckType.toString(argType), expectText);
                return null;
            }
            case SORT: {
                if (arguments.isEmpty()) {
                    return CheckExpression.reportZeroArguments("a list, and a predicate function argument", fnr.getPosition(), ctxt);
                }
                Type argType = arguments.get(0).getType();
                Type arg0 = CheckType.dropReferences(argType);
                if (arg0 instanceof ListType) {
                    ListType a0 = (ListType)arg0;
                    Type eType = a0.getElementType();
                    FunctionType funcType = ChiConstructors.newFunctionType((List)Lists.list((Object[])new Type[]{CheckType.copyType(eType), CheckType.copyType(eType)}), null, (Type)ChiConstructors.newBoolType());
                    funcType = ChiConstructors.newFunctionType((List)Lists.list((Object[])new Type[]{CheckType.copyType(arg0), funcType}), null, (Type)CheckType.copyType(arg0));
                    return Lists.list((Object)funcType);
                }
                String expectText = ", expected a list argument";
                ctxt.throwError(Message.FUNC_CALL_WRONG_PARAMETER_TYPE, fnr.getPosition(), "1st", CheckType.toString(argType), expectText);
                return null;
            }
            case INSERT: {
                if (arguments.isEmpty()) {
                    return CheckExpression.reportZeroArguments("a list, a new element, and a predicate function argument", fnr.getPosition(), ctxt);
                }
                Type argType = arguments.get(0).getType();
                Type arg0 = CheckType.dropReferences(argType);
                if (arg0 instanceof ListType) {
                    ListType a0 = (ListType)arg0;
                    Type eType = a0.getElementType();
                    FunctionType funcType = ChiConstructors.newFunctionType((List)Lists.list((Object[])new Type[]{CheckType.copyType(eType), CheckType.copyType(eType)}), null, (Type)ChiConstructors.newBoolType());
                    funcType = ChiConstructors.newFunctionType((List)Lists.list((Object[])new Type[]{CheckType.copyType(arg0), CheckType.copyType(eType), funcType}), null, (Type)CheckType.copyType(arg0));
                    return Lists.list((Object)funcType);
                }
                String expectText = ", expected a list argument";
                ctxt.throwError(Message.FUNC_CALL_WRONG_PARAMETER_TYPE, fnr.getPosition(), "1st", CheckType.toString(argType), expectText);
                return null;
            }
            case ENUMERATE: {
                if (arguments.isEmpty()) {
                    return CheckExpression.reportZeroArguments("a list, set, or dictionary argument", fnr.getPosition(), ctxt);
                }
                Type argType = arguments.get(0).getType();
                Type arg0 = CheckType.dropReferences(argType);
                if (arg0 instanceof ListType) {
                    ListType a0 = (ListType)arg0;
                    TupleType resType = CheckType.tuplet(new Type[]{ChiConstructors.newIntType(), CheckType.copyType(a0.getElementType())});
                    resType = ChiConstructors.newListType((Type)resType, null, null);
                    return Lists.list((Object)ChiConstructors.newFunctionType(CheckType.tlist(CheckType.copyType(arg0)), null, (Type)resType));
                }
                if (arg0 instanceof SetType) {
                    SetType a0 = (SetType)arg0;
                    TupleType resType = CheckType.tuplet(new Type[]{ChiConstructors.newIntType(), CheckType.copyType(a0.getElementType())});
                    resType = ChiConstructors.newListType((Type)resType, null, null);
                    return Lists.list((Object)ChiConstructors.newFunctionType(CheckType.tlist(CheckType.copyType(arg0)), null, (Type)resType));
                }
                if (arg0 instanceof DictType) {
                    DictType a0 = (DictType)arg0;
                    TupleType resType = CheckType.tuplet(CheckType.copyType(a0.getKeyType()), CheckType.copyType(a0.getValueType()));
                    resType = CheckType.tuplet(new Type[]{ChiConstructors.newIntType(), resType});
                    resType = ChiConstructors.newListType((Type)resType, null, null);
                    return Lists.list((Object)ChiConstructors.newFunctionType(CheckType.tlist(CheckType.copyType(arg0)), null, (Type)resType));
                }
                String eText = ", expected a list, set, or dictionary argument";
                ctxt.throwError(Message.FUNC_CALL_WRONG_PARAMETER_TYPE, fnr.getPosition(), "1st", CheckType.toString(argType), eText);
                return null;
            }
            case EMPTY: {
                if (arguments.isEmpty()) {
                    return CheckExpression.reportZeroArguments("a list, set, or dictionary argument", fnr.getPosition(), ctxt);
                }
                Type argType = arguments.get(0).getType();
                Type arg0 = CheckType.dropReferences(argType);
                if (arg0 instanceof ListType || arg0 instanceof SetType || arg0 instanceof DictType) {
                    return Lists.list((Object)ChiConstructors.newFunctionType(CheckType.tlist(CheckType.copyType(arg0)), null, (Type)ChiConstructors.newBoolType()));
                }
                String eText = ", expected a list, set, or dictionary argument";
                ctxt.throwError(Message.FUNC_CALL_WRONG_PARAMETER_TYPE, fnr.getPosition(), "1st", CheckType.toString(argType), eText);
                return null;
            }
            case SIZE: {
                if (arguments.isEmpty()) {
                    return CheckExpression.reportZeroArguments("a list, set, or dictionary argument", fnr.getPosition(), ctxt);
                }
                Type argType = arguments.get(0).getType();
                Type arg0 = CheckType.dropReferences(argType);
                if (arg0 instanceof ListType || arg0 instanceof SetType || arg0 instanceof DictType || arg0 instanceof StringType) {
                    return Lists.list((Object)ChiConstructors.newFunctionType(CheckType.tlist(CheckType.copyType(arg0)), null, (Type)ChiConstructors.newIntType()));
                }
                String eText = ", expected a list, set, or dictionary argument";
                ctxt.throwError(Message.FUNC_CALL_WRONG_PARAMETER_TYPE, fnr.getPosition(), "1st", CheckType.toString(argType), eText);
                return null;
            }
            case MAX: 
            case MIN: {
                if (arguments.isEmpty()) {
                    return CheckExpression.reportZeroArguments("a single list, set, or dictionary argument, or two or more numbers or strings", fnr.getPosition(), ctxt);
                }
                if (arguments.size() == 1) {
                    Type argType = arguments.get(0).getType();
                    Type arg0 = CheckType.dropReferences(argType);
                    if (arg0 instanceof ListType) {
                        ListType a0 = (ListType)arg0;
                        return Lists.list((Object)ChiConstructors.newFunctionType(CheckType.tlist(CheckType.copyType(arg0)), null, (Type)CheckType.copyType(a0.getElementType())));
                    }
                    if (arg0 instanceof SetType) {
                        SetType a0 = (SetType)arg0;
                        Type e0 = CheckType.dropReferences(a0.getElementType());
                        if (e0 instanceof IntType || e0 instanceof RealType || e0 instanceof StringType) {
                            return Lists.list((Object)ChiConstructors.newFunctionType(CheckType.tlist(CheckType.copyType(arg0)), null, (Type)CheckType.copyType(e0)));
                        }
                    } else if (arg0 instanceof DictType) {
                        DictType a0 = (DictType)arg0;
                        return Lists.list((Object)ChiConstructors.newFunctionType(CheckType.tlist(CheckType.copyType(arg0)), null, (Type)CheckType.copyType(a0.getKeyType())));
                    }
                    String eT = ", expected a list, set, or dictionary argument";
                    ctxt.throwError(Message.FUNC_CALL_WRONG_PARAMETER_TYPE, fnr.getPosition(), "1st", CheckType.toString(argType), eT);
                    return null;
                }
                List params = Lists.list();
                int stringCount = 0;
                boolean hasRealType = false;
                for (Expression e : arguments) {
                    Type tp = CheckType.dropReferences(e.getType());
                    Assert.notNull((Object)tp);
                    params.add(CheckType.copyType(tp));
                    if (tp instanceof StringType) {
                        ++stringCount;
                        continue;
                    }
                    if (tp instanceof RealType) {
                        hasRealType = true;
                        continue;
                    }
                    if (tp instanceof IntType) continue;
                    ctxt.throwError(Message.UNEXPECTED_TYPE_MINMAX, e.getPosition(), CheckType.toString(tp));
                }
                if (stringCount > 0) {
                    if (stringCount != params.size()) {
                        int i = 0;
                        while (i < arguments.size()) {
                            Type ptp = (Type)params.get(i);
                            if (!(ptp instanceof StringType)) {
                                ctxt.throwError(Message.STRING_TYPE_EXPECTED, arguments.get(i).getPosition(), CheckType.toString(ptp));
                            }
                            ++i;
                        }
                        Assert.fail();
                    }
                    StringType result = ChiConstructors.newStringType();
                    return Lists.list((Object)ChiConstructors.newFunctionType((List)params, null, (Type)result));
                }
                RealType result = hasRealType ? ChiConstructors.newRealType() : ChiConstructors.newIntType();
                return Lists.list((Object)ChiConstructors.newFunctionType((List)params, null, (Type)result));
            }
            case POP: {
                if (arguments.isEmpty()) {
                    return CheckExpression.reportZeroArguments("a list, set, or dictionary argument", fnr.getPosition(), ctxt);
                }
                Type argType = arguments.get(0).getType();
                Type arg0 = CheckType.dropReferences(argType);
                if (arg0 instanceof ListType) {
                    ListType a0 = (ListType)arg0;
                    return Lists.list((Object)ChiConstructors.newFunctionType(CheckType.tlist(CheckType.copyType(arg0)), null, (Type)CheckType.tuplet(CheckType.copyType(a0.getElementType()), CheckType.copyType(arg0))));
                }
                if (arg0 instanceof SetType) {
                    SetType a0 = (SetType)arg0;
                    return Lists.list((Object)ChiConstructors.newFunctionType(CheckType.tlist(CheckType.copyType(arg0)), null, (Type)CheckType.tuplet(CheckType.copyType(a0.getElementType()), CheckType.copyType(arg0))));
                }
                if (arg0 instanceof DictType) {
                    DictType a0 = (DictType)arg0;
                    return Lists.list((Object)ChiConstructors.newFunctionType(CheckType.tlist(CheckType.copyType(arg0)), null, (Type)CheckType.tuplet(CheckType.copyType(a0.getKeyType()), CheckType.copyType(a0.getValueType()), CheckType.copyType(arg0))));
                }
                String eText = ", expected a list, set, or dictionary argument";
                ctxt.throwError(Message.FUNC_CALL_WRONG_PARAMETER_TYPE, fnr.getPosition(), "1st", CheckType.toString(argType), eText);
                return null;
            }
            case DELETE: {
                if (arguments.isEmpty()) {
                    String m = "a list, set, or dictionary, and an index (for a list) or value (otherwise) argument";
                    return CheckExpression.reportZeroArguments(m, fnr.getPosition(), ctxt);
                }
                Expression arg1 = arguments.get(0);
                Type tp1 = CheckType.dropReferences(arg1.getType());
                if (tp1 instanceof ListType) {
                    return Lists.list((Object)ChiConstructors.newFunctionType(CheckType.tlist(new Type[]{CheckType.copyType(tp1), ChiConstructors.newIntType()}), null, (Type)CheckType.copyType(tp1)));
                }
                if (tp1 instanceof SetType) {
                    SetType st = (SetType)tp1;
                    Type eType = st.getElementType();
                    return Lists.list((Object)ChiConstructors.newFunctionType((List)Lists.list((Object[])new Type[]{CheckType.copyType((Type)st), CheckType.copyType(eType)}), null, (Type)CheckType.copyType((Type)st)));
                }
                if (tp1 instanceof DictType) {
                    DictType dt = (DictType)tp1;
                    Type eType = dt.getKeyType();
                    return Lists.list((Object)ChiConstructors.newFunctionType((List)Lists.list((Object[])new Type[]{CheckType.copyType((Type)dt), CheckType.copyType(eType)}), null, (Type)CheckType.copyType((Type)dt)));
                }
                String eText = ", expected a list, set, or dictionary argument";
                ctxt.throwError(Message.FUNC_CALL_WRONG_PARAMETER_TYPE, fnr.getPosition(), "1st", CheckType.toString(tp1), eText);
                return null;
            }
        }
        return CheckExpression.getSimpleStdLibFunctionTypes(fnr.getFunction());
    }

    private static FunctionType getStdLibFunctionType(StdLibFunctionReference fnr, List<Expression> arguments, CheckContext ctxt) {
        if (arguments == null) {
            ctxt.throwError(Message.STDLIB_FUNC_MUST_BE_CALLED, fnr.getPosition(), new String[0]);
            return null;
        }
        List<FunctionType> candidates = CheckExpression.getAvailableStdLibFunctions(fnr, arguments, ctxt);
        Assert.notNull(candidates);
        FunctionType result = null;
        int argCount = arguments.size();
        for (FunctionType fn : candidates) {
            if (fn.getParameterTypes().size() != argCount) continue;
            boolean match = true;
            int i = 0;
            while (i < arguments.size()) {
                Type argType;
                Type fnType = (Type)fn.getParameterTypes().get(i);
                if (!CheckType.matchType(fnType, argType = arguments.get(i).getType())) {
                    match = false;
                    break;
                }
                ++i;
            }
            if (!match) continue;
            Assert.check((result == null ? 1 : 0) != 0);
            result = fn;
        }
        if (result != null) {
            return result;
        }
        boolean foundMatch = false;
        int manyCount = -1;
        int fewCount = -1;
        int matchCount = -1;
        FunctionType manyFn = null;
        FunctionType fewFn = null;
        FunctionType matchFn = null;
        for (FunctionType fn : candidates) {
            Type argType;
            Type fnType;
            int fnCount = fn.getParameterTypes().size();
            if (fnCount < argCount) {
                if (manyCount < fnCount) {
                    manyCount = fnCount;
                    manyFn = fn;
                    continue;
                }
                if (manyCount != fnCount) continue;
                manyFn = null;
                continue;
            }
            if (fnCount > argCount) {
                if (fewCount < 0 || fewCount > fnCount) {
                    fewCount = fnCount;
                    fewFn = fn;
                    continue;
                }
                if (fewCount != fnCount) continue;
                fewFn = null;
                continue;
            }
            foundMatch = true;
            int i = 0;
            while (CheckType.matchType(fnType = (Type)fn.getParameterTypes().get(i), argType = arguments.get(i).getType())) {
                ++i;
            }
            if (matchCount < i) {
                matchCount = i;
                matchFn = fn;
                continue;
            }
            if (matchCount != i) continue;
            matchFn = null;
        }
        if (foundMatch) {
            String funcText;
            Type argType = arguments.get(matchCount).getType();
            if (matchFn == null) {
                funcText = "";
            } else {
                Type fnType = (Type)matchFn.getParameterTypes().get(matchCount);
                funcText = Strings.fmt((String)", expected type \"%s\"", (Object[])new Object[]{CheckType.toString(fnType)});
            }
            ctxt.throwError(Message.FUNC_CALL_WRONG_PARAMETER_TYPE, fnr.getPosition(), Numbers.toOrdinal((int)(matchCount + 1)), CheckType.toString(argType), funcText);
        }
        if (manyCount < 0) {
            Assert.check((fewCount >= 0 ? 1 : 0) != 0);
            CheckExpression.reportTooFewArguments(fnr.getPosition(), argCount, fewCount, fewFn, ctxt);
        } else if (fewCount < 0) {
            CheckExpression.reportTooManyArguments(fnr.getPosition(), argCount, manyCount, manyFn, ctxt);
        } else {
            int manyError = argCount - manyCount;
            int fewError = fewCount - argCount;
            if (manyError < fewError) {
                CheckExpression.reportTooManyArguments(fnr.getPosition(), argCount, manyCount, manyFn, ctxt);
            } else if (fewError < manyError) {
                CheckExpression.reportTooFewArguments(fnr.getPosition(), argCount, fewCount, fewFn, ctxt);
            } else {
                ctxt.throwError(Message.FUNC_CALL_INCORRECT_NUMBER_PARAMETERS, fnr.getPosition(), String.valueOf(argCount), String.valueOf(fewCount), String.valueOf(manyCount));
            }
        }
        return null;
    }

    private static List<FunctionType> reportZeroArguments(String expected, Position pos, CheckContext ctxt) {
        ctxt.throwError(Message.FUNC_CALL_WITHOUT_PARAMETERS, pos, expected);
        return null;
    }

    private static void reportTooFewArguments(Position pos, int argCount, int neededCount, FunctionType bestFn, CheckContext ctxt) {
        String txt = bestFn == null ? "parameters" : Strings.fmt((String)"to call \"%s\"", (Object[])new Object[]{CheckType.toString((Type)bestFn)});
        ctxt.throwError(Message.FUNC_CALL_TOO_FEW_PARAMETERS, pos, String.valueOf(argCount), String.valueOf(neededCount), txt);
    }

    private static void reportTooManyArguments(Position pos, int argCount, int neededCount, FunctionType bestFn, CheckContext ctxt) {
        String txt = bestFn == null ? "parameters" : Strings.fmt((String)"to call \"%s\"", (Object[])new Object[]{CheckType.toString((Type)bestFn)});
        ctxt.throwError(Message.FUNC_CALL_TOO_MANY_PARAMETERS, pos, String.valueOf(argCount), String.valueOf(neededCount), txt);
    }

    public static List<Expression> transExpressionList(List<Expression> exprs, CheckContext ctxt) {
        List newExprs = Lists.list();
        for (Expression e : exprs) {
            newExprs.add(CheckExpression.transExpression(e, ctxt));
        }
        return newExprs;
    }

    public static Expression transExpression(Expression expr, CheckContext ctxt) {
        if (expr instanceof BinaryExpression) {
            return CheckExpression.transBinaryExpression((BinaryExpression)expr, ctxt);
        }
        if (expr instanceof BoolLiteral) {
            return CheckExpression.transBoolLiteral((BoolLiteral)expr);
        }
        if (expr instanceof RealNumber) {
            return CheckExpression.transRealNumber((RealNumber)expr, ctxt);
        }
        if (expr instanceof IntNumber) {
            return CheckExpression.transNumber((IntNumber)expr, ctxt);
        }
        if (expr instanceof StringLiteral) {
            return CheckExpression.transStringLiteral((StringLiteral)expr);
        }
        if (expr instanceof CallExpression) {
            return CheckExpression.transCallExpression((CallExpression)expr, ctxt);
        }
        if (expr instanceof DictionaryExpression) {
            return CheckExpression.transDictionaryExpression((DictionaryExpression)expr, ctxt);
        }
        if (expr instanceof TupleExpression) {
            return CheckExpression.transTupleExpression((TupleExpression)expr, ctxt);
        }
        if (expr instanceof SetExpression) {
            return CheckExpression.transSetExpression((SetExpression)expr, ctxt);
        }
        if (expr instanceof ListExpression) {
            return CheckExpression.transListExpression((ListExpression)expr, ctxt);
        }
        if (expr instanceof TimeLiteral) {
            return CheckExpression.transTimeLiteral((TimeLiteral)expr, ctxt);
        }
        if (expr instanceof UnresolvedReference) {
            return CheckExpression.transUnresolvedReference((UnresolvedReference)expr, ctxt);
        }
        if (expr instanceof MatrixExpression) {
            return CheckExpression.transMatrixExpression((MatrixExpression)expr, ctxt);
        }
        if (expr instanceof ReadCallExpression) {
            return CheckExpression.transReadCallExpression((ReadCallExpression)expr, ctxt);
        }
        if (expr instanceof ChannelExpression) {
            return CheckExpression.transChannelExpression((ChannelExpression)expr, ctxt);
        }
        if (expr instanceof SliceExpression) {
            return CheckExpression.transSliceExpression((SliceExpression)expr, ctxt);
        }
        if (expr instanceof UnaryExpression) {
            return CheckExpression.transUnaryExpression((UnaryExpression)expr, ctxt);
        }
        if (expr instanceof StdLibFunctionReference) {
            return CheckExpression.transStdLibFunctionReference((StdLibFunctionReference)expr, null, ctxt);
        }
        if (expr instanceof CastExpression) {
            return CheckExpression.transCastExpression((CastExpression)expr, ctxt);
        }
        Assert.fail((Object)"Unknown Expression class encountered");
        return null;
    }

    private static Expression transTimeLiteral(TimeLiteral e, CheckContext ctxt) {
        if (ctxt.contains(CheckContext.ContextItem.NO_TIME)) {
            ctxt.throwError(Message.USE_OF_TIME_NOT_ALLOWED, e.getPosition(), new String[0]);
        }
        return ChiConstructors.newTimeLiteral((Position)PositionUtils.copyPosition((PositionObject)e), (Type)ChiConstructors.newRealType());
    }

    private static Expression transBoolLiteral(BoolLiteral e) {
        return ChiConstructors.newBoolLiteral((Position)PositionUtils.copyPosition((PositionObject)e), (Type)ChiConstructors.newBoolType(), (Boolean)e.isValue());
    }

    private static Expression transRealNumber(RealNumber e, CheckContext ctxt) {
        double d = Double.valueOf(e.getValue());
        if (Double.isInfinite(d)) {
            ctxt.throwError(Message.NUMBER_OUT_OF_RANGE, e.getPosition(), new String[0]);
        }
        return ChiConstructors.newRealNumber((Position)PositionUtils.copyPosition((PositionObject)e), (Type)ChiConstructors.newRealType(), (String)e.getValue());
    }

    private static Expression transNumber(IntNumber e, CheckContext ctxt) {
        try {
            Integer.parseInt(e.getValue(), 10);
        }
        catch (NumberFormatException exc) {
            ctxt.throwError(Message.NUMBER_OUT_OF_RANGE, e.getPosition(), new String[0]);
        }
        return ChiConstructors.newIntNumber((Position)PositionUtils.copyPosition((PositionObject)e), (Type)ChiConstructors.newIntType(), (String)e.getValue());
    }

    private static boolean isBoolIntRealType(Type tp) {
        return tp instanceof BoolType || tp instanceof IntType || tp instanceof RealType;
    }

    private static Expression transCastExpression(CastExpression e, CheckContext ctxt) {
        Type newType;
        Type resType;
        Expression child = CheckExpression.transExpression(e.getExpression(), ctxt);
        Type exprType = CheckType.dropReferences(child.getType());
        if (exprType instanceof ListType) {
            ListType lt = (ListType)exprType;
            if (e.getCastType() instanceof MatrixType) {
                Type resType2 = CheckType.transNonvoidType(e.getCastType(), ctxt);
                Type elemType = CheckType.dropReferences(lt.getElementType());
                boolean cond = elemType instanceof RealType;
                ctxt.checkThrowError(cond, Message.CANNOT_CAST, e.getPosition(), CheckType.toString(exprType), CheckType.toString(resType2));
                return ChiConstructors.newCastExpression((Type)resType2, (Expression)child, (Position)PositionUtils.copyPosition((PositionObject)e), (Type)CheckType.copyType(resType2));
            }
            if (e.getCastType() instanceof SetType) {
                Type newType2 = CheckType.copyType(CheckType.dropReferences(lt.getElementType()));
                newType2 = ChiConstructors.newSetType((Type)newType2, (Position)e.getCastType().getPosition());
                return ChiConstructors.newCastExpression((Type)newType2, (Expression)child, (Position)PositionUtils.copyPosition((PositionObject)e), (Type)CheckType.copyType(newType2));
            }
            Type newType3 = CheckType.transNonvoidType(e.getCastType(), ctxt);
            Type resType3 = CheckType.dropReferences(newType3);
            ctxt.throwError(Message.CANNOT_CAST, e.getPosition(), CheckType.toString(exprType), CheckType.toString(resType3));
        }
        if (CheckType.matchType(exprType, resType = CheckType.dropReferences(newType = CheckType.transNonvoidType(e.getCastType(), ctxt)))) {
            return child;
        }
        if (resType instanceof IntType && exprType instanceof RealType) {
            ctxt.throwError(Message.NO_INT_REAL_CAST, e.getPosition(), new String[0]);
        }
        if (ctxt.contains(CheckContext.ContextItem.NO_REAL_TIMER_CAST) && resType instanceof RealType && exprType instanceof TimerType) {
            ctxt.throwError(Message.REAL_TIMER_CAST_NOT_ALLOWED, e.getPosition(), new String[0]);
        }
        boolean cond = resType instanceof TimerType && exprType instanceof RealType;
        cond |= resType instanceof RealType && exprType instanceof TimerType;
        cond |= CheckExpression.isBoolIntRealType(resType) && exprType instanceof StringType;
        cond |= resType instanceof StringType && CheckExpression.isBoolIntRealType(exprType);
        ctxt.checkThrowError(cond |= resType instanceof RealType && exprType instanceof IntType, Message.CANNOT_CAST, e.getPosition(), CheckType.toString(exprType), CheckType.toString(resType));
        return ChiConstructors.newCastExpression((Type)newType, (Expression)child, (Position)PositionUtils.copyPosition((PositionObject)e), (Type)CheckType.copyType(newType));
    }

    private static Expression transStringLiteral(StringLiteral e) {
        return ChiConstructors.newStringLiteral((Position)PositionUtils.copyPosition((PositionObject)e), (Type)ChiConstructors.newStringType(), (String)e.getValue());
    }

    private static Expression transMatrixExpression(MatrixExpression e, CheckContext ctxt) {
        int colLength = -1;
        List newRows = Lists.list();
        for (MatrixRow r : e.getRows()) {
            List vals = Lists.list();
            for (Expression elm : r.getElements()) {
                Expression me = CheckExpression.transExpression(elm, ctxt);
                Type tme = CheckType.dropReferences(me.getType());
                boolean cond = tme instanceof RealType;
                ctxt.checkThrowError(cond, Message.MATRIX_LITERAL_REAL_ELEMENTS, elm.getPosition(), CheckType.toString(tme));
                vals.add(me);
            }
            if (colLength < 0) {
                colLength = r.getElements().size();
            } else {
                boolean cond = colLength == vals.size();
                ctxt.checkThrowError(cond, Message.MATRIX_LITERAL_ROW_LENGTH, r.getPosition(), String.valueOf(colLength), String.valueOf(vals.size()));
            }
            MatrixRow mr = ChiConstructors.newMatrixRow((List)vals, (Position)PositionUtils.copyPosition((PositionObject)r));
            newRows.add(mr);
        }
        Assert.check((colLength > 0 ? 1 : 0) != 0);
        IntNumber columnSize = ChiConstructors.newIntNumber(null, (Type)ChiConstructors.newIntType(), (String)String.valueOf(colLength));
        IntNumber rowSize = ChiConstructors.newIntNumber(null, (Type)ChiConstructors.newIntType(), (String)String.valueOf(newRows.size()));
        MatrixType type = ChiConstructors.newMatrixType((Expression)columnSize, null, (Expression)rowSize);
        return ChiConstructors.newMatrixExpression((Position)PositionUtils.copyPosition((PositionObject)e), (List)newRows, (Type)type);
    }

    private static Type getExprsCommonType(List<Expression> exprs, Message msg, CheckContext ctxt) {
        Assert.check((!exprs.isEmpty() ? 1 : 0) != 0);
        Type elmType = null;
        for (Expression elm : exprs) {
            if (elmType == null) {
                elmType = elm.getType();
                continue;
            }
            Type sType = CheckType.smallestType(elmType, elm.getType());
            ctxt.checkThrowError(sType != null, msg, elm.getPosition(), CheckType.toString(elmType), CheckType.toString(elm.getType()));
            elmType = sType;
        }
        return elmType;
    }

    private static Expression transSetExpression(SetExpression e, CheckContext ctxt) {
        if (e.getElements().isEmpty()) {
            Assert.notNull((Object)e.getType());
            Type newType = CheckType.transNonvoidType(e.getType(), ctxt);
            return ChiConstructors.newSetExpression(null, (Position)PositionUtils.copyPosition((PositionObject)e), (Type)newType);
        }
        List<Expression> newVals = CheckExpression.transExpressionList((List<Expression>)e.getElements(), ctxt);
        Type elmType = CheckExpression.getExprsCommonType(newVals, Message.SET_LITERAL_ELEMENT_TYPE, ctxt);
        return ChiConstructors.newSetExpression(newVals, (Position)PositionUtils.copyPosition((PositionObject)e), (Type)ChiConstructors.newSetType((Type)CheckType.copyType(elmType), null));
    }

    private static Expression transListExpression(ListExpression e, CheckContext ctxt) {
        if (e.getElements().isEmpty()) {
            Assert.notNull((Object)e.getType());
            Type newType = CheckType.transNonvoidType(e.getType(), ctxt);
            return ChiConstructors.newListExpression(null, (Position)PositionUtils.copyPosition((PositionObject)e), (Type)newType);
        }
        List<Expression> newVals = CheckExpression.transExpressionList((List<Expression>)e.getElements(), ctxt);
        Type elmType = CheckExpression.getExprsCommonType(newVals, Message.LIST_LITERAL_ELEMENT_TYPE, ctxt);
        IntNumber initLength = ChiConstructors.newIntNumber(null, (Type)ChiConstructors.newIntType(), (String)"0");
        return ChiConstructors.newListExpression(newVals, (Position)PositionUtils.copyPosition((PositionObject)e), (Type)ChiConstructors.newListType((Type)CheckType.copyType(elmType), (Expression)initLength, null));
    }

    private static Expression transTupleExpression(TupleExpression e, CheckContext ctxt) {
        List fldTypes = Lists.list();
        List fields = Lists.list();
        for (Expression fld : e.getFields()) {
            Expression nf = CheckExpression.transExpression(fld, ctxt);
            fields.add(nf);
            fldTypes.add(ChiConstructors.newTupleField(null, null, (Type)CheckType.copyType(nf.getType())));
        }
        return ChiConstructors.newTupleExpression((List)fields, (Position)PositionUtils.copyPosition((PositionObject)e), (Type)ChiConstructors.newTupleType((List)fldTypes, null));
    }

    private static Expression transReadCallExpression(ReadCallExpression e, CheckContext ctxt) {
        if (ctxt.contains(CheckContext.ContextItem.NO_READ)) {
            ctxt.throwError(Message.READ_NOT_ALLOWED, e.getPosition(), new String[0]);
        }
        Expression newFile = null;
        if (e.getFile() != null) {
            newFile = CheckExpression.transExpression(e.getFile(), ctxt);
            Type tNewFile = CheckType.dropReferences(newFile.getType());
            boolean cond = tNewFile instanceof FileType;
            ctxt.checkThrowError(cond, Message.FILE_TYPE_EXPECTED, e.getFile().getPosition(), CheckType.toString(tNewFile));
        }
        Type newType = CheckType.transNonvoidType(e.getLoadType(), ctxt);
        return ChiConstructors.newReadCallExpression((Expression)newFile, (Type)newType, (Position)PositionUtils.copyPosition((PositionObject)e), (Type)CheckType.copyType(newType));
    }

    private static Expression transChannelExpression(ChannelExpression e, CheckContext ctxt) {
        if (ctxt.contains(CheckContext.ContextItem.NO_CHANNEL)) {
            ctxt.throwError(Message.CHANNEL_NOT_ALLOWED, e.getPosition(), new String[0]);
        }
        Type newType = CheckType.transNonvoidType(e.getElementType(), ctxt);
        ChannelType chanType = ChiConstructors.newChannelType((Type)CheckType.copyType(newType), (ChannelOps)ChannelOps.SEND_RECEIVE, null);
        return ChiConstructors.newChannelExpression((Type)newType, (Position)PositionUtils.copyPosition((PositionObject)e), (Type)chanType);
    }

    private static Expression transCallExpression(CallExpression e, CheckContext ctxt) {
        List newArgs = Lists.list();
        for (Expression arg : e.getArguments()) {
            newArgs.add(CheckExpression.transExpression(arg, ctxt));
        }
        if (e.getFunction() instanceof StdLibFunctionReference) {
            StdLibFunctionReference fnr = (StdLibFunctionReference)e.getFunction();
            FunctionType fntp = CheckExpression.getStdLibFunctionType(fnr, newArgs, ctxt);
            Expression newFunc = CheckExpression.transStdLibFunctionReference(fnr, newArgs, ctxt);
            boolean cond = e.getName() == null;
            ctxt.checkThrowError(cond, Message.FUNCTION_CALL_NO_NAME, e.getFunction().getPosition(), new String[0]);
            return ChiConstructors.newCallExpression((List)newArgs, (Expression)newFunc, null, (Position)PositionUtils.copyPosition((PositionObject)e), (Type)CheckType.copyType(fntp.getResultType()));
        }
        Expression newFunc = CheckExpression.transExpression(e.getFunction(), ctxt);
        Type tNewFunc = CheckType.dropReferences(newFunc.getType());
        if (tNewFunc instanceof FunctionType) {
            FunctionType fntp = (FunctionType)tNewFunc;
            CheckExpression.checkArguments(newArgs, (List<Type>)fntp.getParameterTypes(), (Expression)e, ctxt);
            boolean cond = e.getName() == null;
            ctxt.checkThrowError(cond, Message.FUNCTION_CALL_NO_NAME, e.getFunction().getPosition(), new String[0]);
            return ChiConstructors.newCallExpression((List)newArgs, (Expression)newFunc, null, (Position)PositionUtils.copyPosition((PositionObject)e), (Type)CheckType.copyType(fntp.getResultType()));
        }
        Expression newName = null;
        if (e.getName() != null) {
            newName = CheckExpression.transExpression(e.getName(), ctxt);
            Type t = CheckType.dropReferences(newName.getType());
            boolean cond = t instanceof StringType || t instanceof IntType;
            ctxt.checkThrowError(cond, Message.STRING_INT_TYPE_EXPECTED, e.getName().getPosition(), CheckType.toString(t));
        }
        if (tNewFunc instanceof ProcessType) {
            ProcessType ptp = (ProcessType)tNewFunc;
            CheckExpression.checkArguments(newArgs, (List<Type>)ptp.getParameterTypes(), (Expression)e, ctxt);
            return ChiConstructors.newCallExpression((List)newArgs, (Expression)newFunc, (Expression)newName, (Position)PositionUtils.copyPosition((PositionObject)e), (Type)ChiConstructors.newInstanceType());
        }
        if (tNewFunc instanceof ModelType) {
            ModelType mtp = (ModelType)tNewFunc;
            CheckExpression.checkArguments(newArgs, (List<Type>)mtp.getParameterTypes(), (Expression)e, ctxt);
            Type exitType = mtp.getExitType();
            if (exitType != null) {
                exitType = CheckType.dropReferences(exitType);
            }
            if (exitType == null || exitType instanceof VoidType) {
                ctxt.throwError(Message.CANNOT_CALL_NONVOID_MODEL, e.getFunction().getPosition(), new String[0]);
            }
            return ChiConstructors.newCallExpression((List)newArgs, (Expression)newFunc, (Expression)newName, (Position)PositionUtils.copyPosition((PositionObject)e), (Type)CheckType.copyType(exitType));
        }
        ctxt.throwError(Message.NOT_CALLABLE, PositionUtils.copyPosition((PositionObject)e.getFunction()), new String[0]);
        return null;
    }

    private static Expression transDictionaryExpression(DictionaryExpression e, CheckContext ctxt) {
        if (e.getPairs().isEmpty()) {
            Assert.notNull((Object)e.getType());
            Type newType = CheckType.transNonvoidType(e.getType(), ctxt);
            return ChiConstructors.newDictionaryExpression(null, (Position)PositionUtils.copyPosition((PositionObject)e), (Type)newType);
        }
        Type keyType = null;
        Type valueType = null;
        List newPairs = Lists.list();
        for (DictionaryPair dp : e.getPairs()) {
            Type newType;
            Expression newKey = CheckExpression.transExpression(dp.getKey(), ctxt);
            Expression newVal = CheckExpression.transExpression(dp.getValue(), ctxt);
            newPairs.add(ChiConstructors.newDictionaryPair((Expression)newKey, (Position)PositionUtils.copyPosition((PositionObject)dp), (Expression)newVal));
            if (keyType == null) {
                newType = newKey.getType();
            } else {
                newType = CheckType.smallestType(keyType, newKey.getType());
                ctxt.checkThrowError(newType != null, Message.DICT_LITERAL_KEY_TYPE, dp.getKey().getPosition(), CheckType.toString(keyType), CheckType.toString(newKey.getType()));
            }
            keyType = newType;
            if (valueType == null) {
                newType = newVal.getType();
            } else {
                newType = CheckType.smallestType(valueType, newVal.getType());
                ctxt.checkThrowError(newType != null, Message.DICT_LITERAL_VALUE_TYPE, dp.getValue().getPosition(), CheckType.toString(valueType), CheckType.toString(newVal.getType()));
            }
            valueType = newType;
        }
        DictType dictType = ChiConstructors.newDictType((Type)CheckType.copyType(keyType), null, (Type)CheckType.copyType(valueType));
        return ChiConstructors.newDictionaryExpression((List)newPairs, (Position)PositionUtils.copyPosition((PositionObject)e), (Type)dictType);
    }

    private static Expression transBinaryExpression(BinaryExpression e, CheckContext ctxt) {
        Expression newLeft = CheckExpression.transExpression(e.getLeft(), ctxt);
        Type tNewLeft = CheckType.dropReferences(newLeft.getType());
        if (e.getOp() == BinaryOperators.FIELD_PROJECTION) {
            if (tNewLeft instanceof TupleType) {
                boolean cond = e.getRight() instanceof UnresolvedReference;
                ctxt.checkThrowError(cond, Message.RHS_TUPLE_PROJ_FIELD_NAME, e.getRight().getPosition(), new String[0]);
                String name = ((UnresolvedReference)e.getRight()).getName();
                Assert.check((!name.isEmpty() ? 1 : 0) != 0);
                EList fields = ((TupleType)tNewLeft).getFields();
                int i = 0;
                while (i < fields.size()) {
                    TupleField tf = (TupleField)fields.get(i);
                    if (name.equals(tf.getName())) {
                        FieldReference newRight = ChiConstructors.newFieldReference((TupleField)tf, null, (Type)CheckType.copyType(tf.getType()));
                        return ChiConstructors.newBinaryExpression((Expression)newLeft, (BinaryOperators)BinaryOperators.PROJECTION, (Position)PositionUtils.copyPosition((PositionObject)e), (Expression)newRight, (Type)CheckType.copyType(tf.getType()));
                    }
                    ++i;
                }
                ctxt.throwError(Message.RHS_TUPLE_PROJ_UNKNOWN_NAME, e.getRight().getPosition(), CheckType.toString(tNewLeft), name);
            }
            ctxt.throwError(Message.LHS_TUPLE_PROJ_NOT_A_TUPLE, e.getLeft().getPosition(), CheckType.toString(tNewLeft));
        }
        Expression newRight = CheckExpression.transExpression(e.getRight(), ctxt);
        Type tNewRight = CheckType.dropReferences(newRight.getType());
        BoolType resultType = null;
        switch (e.getOp()) {
            case CONJUNCTION: 
            case DISJUNCTION: {
                ctxt.checkThrowError(tNewLeft instanceof BoolType, Message.LHS_OPERAND_MUST_HAVE_BOOL_TYPE, e.getLeft().getPosition(), CheckType.toString(tNewLeft));
                ctxt.checkThrowError(tNewRight instanceof BoolType, Message.RHS_OPERAND_MUST_HAVE_BOOL_TYPE, e.getRight().getPosition(), CheckType.toString(tNewRight));
                resultType = ChiConstructors.newBoolType();
                break;
            }
            case DIVISION: 
            case POWER: {
                ctxt.checkThrowError(CheckType.isNumericType(tNewLeft), Message.LHS_OPERAND_MUST_HAVE_NUMERIC_TYPE, e.getLeft().getPosition(), CheckType.toString(tNewLeft));
                ctxt.checkThrowError(CheckType.isNumericType(tNewRight), Message.RHS_OPERAND_MUST_HAVE_NUMERIC_TYPE, e.getRight().getPosition(), CheckType.toString(tNewRight));
                resultType = ChiConstructors.newRealType();
                break;
            }
            case EQUAL: 
            case NOT_EQUAL: {
                if (CheckType.isNumericType(tNewLeft) && CheckType.isNumericType(tNewRight)) {
                    resultType = ChiConstructors.newBoolType();
                    break;
                }
                Type st = CheckType.smallestType(tNewLeft, tNewRight);
                if (st != null) {
                    resultType = ChiConstructors.newBoolType();
                    break;
                }
                ctxt.throwError(Message.OPERANDS_EQUAL_OR_NUMERIC, e.getPosition(), CheckType.toString(tNewLeft), CheckType.toString(tNewRight));
                break;
            }
            case FLOOR_DIVISION: 
            case MODULUS: {
                ctxt.checkThrowError(tNewLeft instanceof IntType, Message.LHS_OPERAND_MUST_HAVE_INT_TYPE, e.getLeft().getPosition(), CheckType.toString(tNewLeft));
                ctxt.checkThrowError(tNewRight instanceof IntType, Message.RHS_OPERAND_MUST_HAVE_INT_TYPE, e.getRight().getPosition(), CheckType.toString(tNewRight));
                resultType = ChiConstructors.newIntType();
                break;
            }
            case GREATER_EQUAL: 
            case GREATER_THAN: 
            case LESS_THAN: 
            case LESS_EQUAL: {
                boolean cond = CheckType.isNumericType(tNewLeft) || tNewLeft instanceof StringType;
                ctxt.checkThrowError(cond, Message.LHS_MUST_NUMERIC_STRING_TYPE, e.getLeft().getPosition(), CheckType.toString(tNewLeft));
                if (CheckType.isNumericType(tNewLeft)) {
                    ctxt.checkThrowError(CheckType.isNumericType(tNewRight), Message.RHS_OPERAND_MUST_HAVE_NUMERIC_TYPE, e.getRight().getPosition(), CheckType.toString(tNewRight));
                    resultType = ChiConstructors.newBoolType();
                    break;
                }
                Assert.check((boolean)(tNewLeft instanceof StringType));
                ctxt.checkThrowError(tNewRight instanceof StringType, Message.RHS_OPERAND_MUST_HAVE_STRING_TYPE, e.getRight().getPosition(), CheckType.toString(tNewRight));
                resultType = ChiConstructors.newBoolType();
                break;
            }
            case ADDITION: {
                Type st;
                if (tNewLeft instanceof StringType && tNewRight instanceof StringType) {
                    resultType = ChiConstructors.newStringType();
                    break;
                }
                if (CheckType.isNumericType(tNewLeft) && CheckType.isNumericType(tNewRight)) {
                    if (tNewLeft instanceof IntType && tNewRight instanceof IntType) {
                        resultType = ChiConstructors.newIntType();
                        break;
                    }
                    resultType = ChiConstructors.newRealType();
                    break;
                }
                if ((tNewLeft instanceof ListType || tNewLeft instanceof SetType || tNewLeft instanceof DictType) && (st = CheckType.smallestType(tNewLeft, tNewRight)) != null) {
                    resultType = CheckType.copyType(st);
                    break;
                }
                if (tNewLeft instanceof TupleType && tNewRight instanceof TupleType) {
                    EList lf = ((TupleType)tNewLeft).getFields();
                    EList rf = ((TupleType)tNewRight).getFields();
                    List rslt = Lists.listc((int)(lf.size() + rf.size()));
                    for (TupleField fld : lf) {
                        rslt.add(ChiConstructors.newTupleField((String)"", null, (Type)CheckType.copyType(fld.getType())));
                    }
                    for (TupleField fld : rf) {
                        rslt.add(ChiConstructors.newTupleField((String)"", null, (Type)CheckType.copyType(fld.getType())));
                    }
                    resultType = ChiConstructors.newTupleType((List)rslt, null);
                    break;
                }
                ctxt.throwError(Message.BAD_ADDITION, e.getPosition(), CheckType.toString(tNewLeft), CheckType.toString(tNewRight));
                return null;
            }
            case MULTIPLICATION: {
                Type st;
                if (CheckType.isNumericType(tNewLeft) && CheckType.isNumericType(tNewRight)) {
                    if (tNewLeft instanceof IntType && tNewRight instanceof IntType) {
                        resultType = ChiConstructors.newIntType();
                        break;
                    }
                    resultType = ChiConstructors.newRealType();
                    break;
                }
                if (tNewLeft instanceof SetType && (st = CheckType.smallestType(tNewLeft, tNewRight)) != null) {
                    resultType = CheckType.copyType(st);
                    break;
                }
                ctxt.throwError(Message.BAD_MULTIPLICATION, e.getPosition(), CheckType.toString(tNewLeft), CheckType.toString(tNewRight));
                return null;
            }
            case SUBTRACTION: {
                Type smt;
                SetType st;
                Type st2;
                if (CheckType.isNumericType(tNewLeft) && CheckType.isNumericType(tNewRight)) {
                    if (tNewLeft instanceof IntType && tNewRight instanceof IntType) {
                        resultType = ChiConstructors.newIntType();
                        break;
                    }
                    resultType = ChiConstructors.newRealType();
                    break;
                }
                if ((tNewLeft instanceof SetType && tNewRight instanceof SetType || tNewLeft instanceof ListType && tNewRight instanceof ListType || tNewLeft instanceof DictType && tNewRight instanceof DictType) && (st2 = CheckType.smallestType(tNewLeft, tNewRight)) != null) {
                    resultType = CheckType.copyType(tNewLeft);
                    break;
                }
                if (tNewLeft instanceof DictType && tNewRight instanceof SetType) {
                    DictType dt = (DictType)tNewLeft;
                    st = (SetType)tNewRight;
                    smt = CheckType.smallestType(dt.getKeyType(), st.getElementType());
                    if (smt != null) {
                        resultType = CheckType.copyType((Type)dt);
                        break;
                    }
                }
                if (tNewLeft instanceof DictType && tNewRight instanceof ListType) {
                    DictType dt = (DictType)tNewLeft;
                    st = (ListType)tNewRight;
                    smt = CheckType.smallestType(dt.getKeyType(), st.getElementType());
                    if (smt != null) {
                        resultType = CheckType.copyType((Type)dt);
                        break;
                    }
                }
                ctxt.throwError(Message.BAD_SUBTRACTION, e.getPosition(), CheckType.toString(tNewLeft), CheckType.toString(tNewRight));
                return null;
            }
            case ELEMENT_TEST: {
                ListType tp;
                Type elementType = null;
                if (tNewRight instanceof ListType) {
                    tp = (ListType)tNewRight;
                    elementType = tp.getElementType();
                } else if (tNewRight instanceof SetType) {
                    tp = (SetType)tNewRight;
                    elementType = tp.getElementType();
                } else if (tNewRight instanceof DictType) {
                    tp = (DictType)tNewRight;
                    elementType = tp.getKeyType();
                }
                boolean cond = elementType != null;
                ctxt.checkThrowError(cond, Message.LIST_SET_DICT_EXPECTED, e.getRight().getPosition(), CheckType.toString(tNewRight));
                Type t = CheckType.smallestType(tNewLeft, elementType);
                cond = t != null;
                ctxt.checkThrowError(cond, Message.LHS_MATCH_NOT_ELEMENT_TYPE, e.getPosition(), CheckType.toString(elementType), CheckType.toString(tNewLeft));
                resultType = ChiConstructors.newBoolType();
                break;
            }
            case PROJECTION: {
                ListType tp;
                boolean cond;
                if (tNewLeft instanceof ListType) {
                    cond = tNewRight instanceof IntType;
                    ctxt.checkThrowError(cond, Message.INDEX_EXPR_MUST_BE_INT, e.getRight().getPosition(), CheckType.toString(tNewRight));
                    tp = (ListType)tNewLeft;
                    resultType = CheckType.copyType(tp.getElementType());
                    break;
                }
                if (tNewLeft instanceof StringType) {
                    cond = tNewRight instanceof IntType;
                    ctxt.checkThrowError(cond, Message.INDEX_EXPR_MUST_BE_INT, e.getRight().getPosition(), CheckType.toString(tNewRight));
                    resultType = CheckType.copyType(tNewLeft);
                    break;
                }
                if (tNewLeft instanceof DictType) {
                    DictType dt = (DictType)tNewLeft;
                    boolean cond2 = CheckType.matchType(tNewRight, dt.getKeyType());
                    ctxt.checkThrowError(cond2, Message.DICT_PROJ_TYPE_MATCH, e.getRight().getPosition(), CheckType.toString(dt.getKeyType()), CheckType.toString(tNewRight));
                    resultType = CheckType.copyType(dt.getValueType());
                    break;
                }
                ctxt.throwError(Message.TYPE_HAS_NO_PROJECTION, e.getPosition(), CheckType.toString(tNewLeft));
                break;
            }
            case SUBSET: {
                boolean cond = tNewLeft instanceof SetType;
                ctxt.checkThrowError(cond, Message.SET_EXPECTED, e.getPosition(), CheckType.toString(tNewLeft));
                Type t = CheckType.smallestType(tNewLeft, tNewRight);
                ctxt.checkThrowError(t != null, Message.OPERANDS_EQUAL, e.getPosition(), CheckType.toString(tNewLeft), CheckType.toString(tNewRight));
                resultType = ChiConstructors.newBoolType();
                break;
            }
            default: {
                Assert.fail((Object)"Unknown binary operator encountered.");
            }
        }
        Assert.check((resultType != null ? 1 : 0) != 0);
        return ChiConstructors.newBinaryExpression((Expression)newLeft, (BinaryOperators)e.getOp(), (Position)PositionUtils.copyPosition((PositionObject)e), (Expression)newRight, (Type)resultType);
    }

    private static Expression transUnaryExpression(UnaryExpression e, CheckContext ctxt) {
        Expression newChild = CheckExpression.transExpression(e.getChild(), ctxt);
        Type tNewChild = CheckType.dropReferences(newChild.getType());
        BoolType resultType = null;
        switch (e.getOp()) {
            case INVERSE: {
                boolean cond = tNewChild instanceof BoolType;
                ctxt.checkThrowError(cond, Message.BOOLEAN_TYPE_EXPECTED, e.getChild().getPosition(), CheckType.toString(tNewChild));
                resultType = ChiConstructors.newBoolType();
                break;
            }
            case NEGATE: 
            case PLUS: {
                boolean cond = CheckType.isNumericType(tNewChild);
                ctxt.checkThrowError(cond, Message.NUMERIC_TYPE_EXPECTED, e.getChild().getPosition(), CheckType.toString(tNewChild));
                resultType = CheckType.copyType(tNewChild);
                break;
            }
            case SAMPLE: {
                if (ctxt.contains(CheckContext.ContextItem.NO_SAMPLE)) {
                    ctxt.throwError(Message.SAMPLING_NOT_ALLOWED_HERE, e.getPosition(), new String[0]);
                }
                boolean cond = tNewChild instanceof DistributionType;
                ctxt.checkThrowError(cond, Message.DISTRIBUTION_TYPE_EXPECTED, e.getChild().getPosition(), CheckType.toString(tNewChild));
                DistributionType tp = (DistributionType)tNewChild;
                Type elmType = tp.getResultType();
                cond = elmType instanceof BoolType || CheckType.isNumericType(elmType);
                ctxt.checkThrowError(cond, Message.DISTRIBUTION_ELEMENT_TYPE_WRONG, e.getChild().getPosition(), CheckType.toString(elmType));
                resultType = CheckType.copyType(elmType);
                break;
            }
            default: {
                Assert.fail((Object)"Unknown unary operator encountered.");
            }
        }
        return ChiConstructors.newUnaryExpression((Expression)newChild, (UnaryOperators)e.getOp(), (Position)PositionUtils.copyPosition((PositionObject)e), resultType);
    }

    private static Expression transSliceExpression(SliceExpression e, CheckContext ctxt) {
        Expression source = CheckExpression.transExpression(e.getSource(), ctxt);
        Type tSource = CheckType.dropReferences(source.getType());
        StringType resultType = null;
        if (tSource instanceof ListType) {
            ListType tp = (ListType)tSource;
            resultType = CheckType.copyType((Type)tp);
        } else if (tSource instanceof StringType) {
            resultType = ChiConstructors.newStringType();
        }
        boolean cond = resultType != null;
        ctxt.checkThrowError(cond, Message.SLICE_EXPR_MUST_BE_STRING_OR_LIST, e.getSource().getPosition(), CheckType.toString(tSource));
        Expression start = null;
        if (e.getStart() != null) {
            start = CheckExpression.transExpression(e.getStart(), ctxt);
            Type tStart = CheckType.dropReferences(start.getType());
            cond = tStart instanceof IntType;
            ctxt.checkThrowError(cond, Message.START_EXPR_MUST_BE_INT, e.getStart().getPosition(), CheckType.toString(tStart));
        }
        Expression step = null;
        if (e.getStep() != null) {
            step = CheckExpression.transExpression(e.getStep(), ctxt);
            Type tStep = CheckType.dropReferences(step.getType());
            cond = tStep instanceof IntType;
            ctxt.checkThrowError(cond, Message.STEP_EXPR_MUST_BE_INT, e.getStep().getPosition(), CheckType.toString(tStep));
        }
        Expression end = null;
        if (e.getEnd() != null) {
            end = CheckExpression.transExpression(e.getEnd(), ctxt);
            Type tEnd = CheckType.dropReferences(end.getType());
            cond = tEnd instanceof IntType;
            ctxt.checkThrowError(cond, Message.END_EXPR_MUST_BE_INT, e.getEnd().getPosition(), CheckType.toString(tEnd));
        }
        return ChiConstructors.newSliceExpression((Expression)end, (Position)PositionUtils.copyPosition((PositionObject)e), (Expression)source, (Expression)start, (Expression)step, (Type)resultType);
    }

    private static Expression transStdLibFunctionReference(StdLibFunctionReference e, List<Expression> args, CheckContext ctxt) {
        StdLibFunctions sf = e.getFunction();
        if (ctxt.contains(CheckContext.ContextItem.NO_INPUT)) {
            String s = null;
            switch (sf) {
                case EOF: {
                    s = "eof";
                    break;
                }
                case EOL: {
                    s = "eol";
                    break;
                }
                case NEWLINES: {
                    s = "newlines";
                    break;
                }
            }
            if (s != null) {
                ctxt.throwError(Message.INPUT_FUNC_NOT_ALLOWED, e.getPosition(), s);
            }
        }
        FunctionType newFnType = CheckExpression.getStdLibFunctionType(e, args, ctxt);
        return ChiConstructors.newStdLibFunctionReference((StdLibFunctions)sf, (Position)PositionUtils.copyPosition((PositionObject)e), (Type)newFnType);
    }

    private static Expression transUnresolvedReference(UnresolvedReference e, CheckContext ctxt) {
        SymbolEntry se = ctxt.getSymbol(e.getName());
        if (se != null) {
            se.typeCheckForUse();
            se.setUsed();
        }
        if (se instanceof VariableSymbolEntry) {
            if (ctxt.contains(CheckContext.ContextItem.NO_VARIABLES)) {
                ctxt.throwError(Message.VARIABLE_NOT_ALLOWED, e.getPosition(), e.getName());
            }
            VariableSymbolEntry vse = (VariableSymbolEntry)se;
            VariableDeclaration vd = vse.getVariable();
            return ChiConstructors.newVariableReference((Position)PositionUtils.copyPosition((PositionObject)e), (Type)CheckType.copyType(vd.getType()), (VariableDeclaration)vd);
        }
        if (se instanceof ConstantSymbolEntry) {
            ConstantSymbolEntry cse = (ConstantSymbolEntry)se;
            ConstantDeclaration cd = cse.getConstant();
            return ChiConstructors.newConstantReference((ConstantDeclaration)cd, (Position)PositionUtils.copyPosition((PositionObject)e), (Type)CheckType.copyType(cd.getType()));
        }
        if (se instanceof EnumValueSymbolEntry) {
            EnumValueSymbolEntry ese = (EnumValueSymbolEntry)se;
            EnumValue ev = ese.getEnumValue();
            EnumDeclaration ed = ese.enumDeclSymbol.getEnumTypeDeclaration();
            Assert.notNull((Object)ed);
            return ChiConstructors.newEnumValueReference((Position)PositionUtils.copyPosition((PositionObject)e), (Type)ChiConstructors.newEnumTypeReference(null, (EnumDeclaration)ed), (EnumValue)ev);
        }
        if (se instanceof ProcessDefSymbolEntry) {
            if (ctxt.contains(CheckContext.ContextItem.NO_PROCESSES)) {
                ctxt.throwError(Message.PROCESS_REF_NOT_ALLOWED, e.getPosition(), e.getName());
            }
            ProcessDefSymbolEntry pse = (ProcessDefSymbolEntry)se;
            ProcessDeclaration pd = pse.getNewDecl();
            ProcessType pt = ChiConstructors.newProcessType((Type)CheckType.copyType(pd.getReturnType()), CheckType.copyTypes(pse.getParameterTypes()), null);
            return ChiConstructors.newProcessReference((Position)PositionUtils.copyPosition((PositionObject)e), (ProcessDeclaration)pd, (Type)pt);
        }
        if (se instanceof FunctionDefSymbolEntry) {
            FunctionDefSymbolEntry fse = (FunctionDefSymbolEntry)se;
            FunctionDeclaration fdef = fse.getNewDecl();
            FunctionType ftype = ChiConstructors.newFunctionType(fse.getParameterTypes(), null, (Type)CheckType.copyType(fdef.getReturnType()));
            return ChiConstructors.newFunctionReference((FunctionDeclaration)fdef, (Position)PositionUtils.copyPosition((PositionObject)e), (Type)ftype);
        }
        if (se instanceof ModelDefSymbolEntry) {
            if (ctxt.contains(CheckContext.ContextItem.NO_MODELS)) {
                ctxt.throwError(Message.MODEL_REF_NOT_ALLOWED, e.getPosition(), e.getName());
            }
            ModelDefSymbolEntry mde = (ModelDefSymbolEntry)se;
            ModelDeclaration mdef = mde.getNewDecl();
            ModelType mt = ChiConstructors.newModelType((Type)CheckType.copyType(mdef.getReturnType()), CheckType.copyTypes(mde.getParameterTypes()), null);
            return ChiConstructors.newModelReference((ModelDeclaration)mdef, (Position)PositionUtils.copyPosition((PositionObject)e), (Type)mt);
        }
        ctxt.throwError(Message.NO_VALUE_NAME, e.getPosition(), e.getName());
        return null;
    }

    public static int evalExpression(Expression e, CheckContext ctxt) {
        block25: {
            CallExpression ce;
            block26: {
                block24: {
                    if (!(CheckType.dropReferences(e.getType()) instanceof IntType)) {
                        ctxt.throwError(Message.EVALUATE_ERROR, e.getPosition(), new String[0]);
                    }
                    if (e instanceof IntNumber) {
                        IntNumber n = (IntNumber)e;
                        Assert.check((boolean)(CheckType.dropReferences(n.getType()) instanceof IntType));
                        return Integer.parseInt(n.getValue());
                    }
                    if (e instanceof ConstantReference) {
                        ConstantReference cr = (ConstantReference)e;
                        return CheckExpression.evalExpression(cr.getConstant().getValue(), ctxt);
                    }
                    if (!(e instanceof UnaryExpression)) break block24;
                    UnaryExpression ue = (UnaryExpression)e;
                    switch (ue.getOp()) {
                        case NEGATE: {
                            return -CheckExpression.evalExpression(ue.getChild(), ctxt);
                        }
                        case PLUS: {
                            return CheckExpression.evalExpression(ue.getChild(), ctxt);
                        }
                    }
                    break block25;
                }
                if (!(e instanceof BinaryExpression)) break block26;
                BinaryExpression be = (BinaryExpression)e;
                switch (be.getOp()) {
                    case ADDITION: {
                        int left = CheckExpression.evalExpression(be.getLeft(), ctxt);
                        int right = CheckExpression.evalExpression(be.getRight(), ctxt);
                        return left + right;
                    }
                    case FLOOR_DIVISION: {
                        int left = CheckExpression.evalExpression(be.getLeft(), ctxt);
                        int right = CheckExpression.evalExpression(be.getRight(), ctxt);
                        if (right != 0) {
                            return left / right;
                        }
                        break block25;
                    }
                    case MODULUS: {
                        int left = CheckExpression.evalExpression(be.getLeft(), ctxt);
                        int right = CheckExpression.evalExpression(be.getRight(), ctxt);
                        if (right != 0) {
                            return left % right;
                        }
                        break block25;
                    }
                    case MULTIPLICATION: {
                        int left = CheckExpression.evalExpression(be.getLeft(), ctxt);
                        int right = CheckExpression.evalExpression(be.getRight(), ctxt);
                        return left * right;
                    }
                    case POWER: {
                        int left = CheckExpression.evalExpression(be.getLeft(), ctxt);
                        int right = CheckExpression.evalExpression(be.getRight(), ctxt);
                        if (right >= 0) {
                            int result = 1;
                            while (right > 0) {
                                result *= left;
                                --right;
                            }
                            return result;
                        }
                        break block25;
                    }
                    case SUBTRACTION: {
                        int left = CheckExpression.evalExpression(be.getLeft(), ctxt);
                        int right = CheckExpression.evalExpression(be.getRight(), ctxt);
                        return left - right;
                    }
                }
                break block25;
            }
            if (e instanceof CallExpression && (ce = (CallExpression)e).getFunction() instanceof StdLibFunctionReference) {
                StdLibFunctionReference sr = (StdLibFunctionReference)ce.getFunction();
                if (sr.getFunction().equals((Object)StdLibFunctions.ABS)) {
                    return CheckExpression.evalExpression((Expression)ce.getArguments().get(0), ctxt);
                }
                if (sr.getFunction().equals((Object)StdLibFunctions.SIGN)) {
                    int i = CheckExpression.evalExpression((Expression)ce.getArguments().get(0), ctxt);
                    if (i > 0) {
                        return 1;
                    }
                    if (i < 0) {
                        return -1;
                    }
                    return 0;
                }
            }
        }
        ctxt.throwError(Message.EVALUATE_ERROR, e.getPosition(), new String[0]);
        return 0;
    }
}

