/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck.mdd;

import java.util.Map;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.multivaluetrees.Node;
import org.eclipse.escet.common.multivaluetrees.Tree;

public class MddIntegerValueCollection {
    public final Map<Integer, Node> valueNodes;

    public MddIntegerValueCollection() {
        this.valueNodes = Maps.map();
    }

    public MddIntegerValueCollection(int numValues) {
        this.valueNodes = Maps.mapc((int)numValues);
    }

    public void addValue(Tree tree, Integer value, Node node) {
        Node n = this.valueNodes.get(value);
        if (n != null) {
            node = tree.disjunct(node, n);
        }
        this.valueNodes.put(value, node);
    }

    public Node get(Integer value) {
        return this.valueNodes.get(value);
    }

    public Node getExist(Integer value) {
        Node n = this.get(value);
        Assert.notNull((Object)n);
        return n;
    }

    public int size() {
        return this.valueNodes.size();
    }
}

